/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.util.BoundingBoxHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class SmallTunnel
extends BetterMineshaftPiece {
    private final List<Integer> supports = new ArrayList<Integer>();
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 8;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 7;

    public SmallTunnel(CompoundTag compoundTag) {
        super(StructurePieceTypeModule.SMALL_TUNNEL, compoundTag);
        ListTag listTag1 = compoundTag.m_128437_("Supports", 3);
        for (int i = 0; i < listTag1.size(); ++i) {
            this.supports.add(listTag1.m_128763_(i));
        }
    }

    public SmallTunnel(int chunkPieceLen, BoundingBox blockBox, Direction direction, BetterMineshaftConfiguration config) {
        super(StructurePieceTypeModule.SMALL_TUNNEL, chunkPieceLen, config, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
        ListTag listTag1 = new ListTag();
        this.supports.forEach(z -> listTag1.add((Object)IntTag.m_128679_((int)z)));
        compoundTag.m_128365_("Supports", (Tag)listTag1);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePieceAccessor, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)8, (Direction)direction);
        StructurePiece intersectingPiece = structurePieceAccessor.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_214092_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, RandomSource randomSource) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, direction, this.f_73384_);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.f_73383_.m_162399_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, direction, this.f_73384_);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_(), direction, this.f_73384_);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), direction, this.f_73384_);
            }
        }
        this.buildSupports(randomSource);
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        this.chanceReplaceNonAir(world, box, randomSource, this.config.replacementRate, 0, 1, 0, 4, 4, 7, this.config.blockStateRandomizers.mainRandomizer);
        this.chanceReplaceNonAir(world, box, randomSource, this.config.replacementRate, 0, 0, 0, 4, 0, 7, this.config.blockStateRandomizers.floorRandomizer);
        this.fill(world, box, 1, 1, 0, 3, 3, 7, AIR);
        this.replaceAirOrChains(world, box, 1, 0, 0, 3, 0, 7, this.config.blockStates.mainBlockState);
        this.generateSupports(world, box, randomSource);
        this.generateRails(world, box, randomSource);
        this.generateChestCarts(world, box, randomSource);
        this.generateTntCarts(world, box, randomSource);
        this.addVines(world, box, randomSource, this.config.decorationChances.vineChance, 1, 0, 1, 3, 4, 6);
        this.addBiomeDecorations(world, box, randomSource, 1, 0, 0, 3, 3, 6);
        this.generateTorches(world, box, randomSource);
        this.generatePillarsOrChains(world, box, randomSource);
        this.replaceExistingChainsWithChainBlock(world, box);
    }

    private void generateChestCarts(WorldGenLevel world, BoundingBox box, RandomSource randomSource) {
        for (int z = 0; z <= 7; ++z) {
            BlockPos.MutableBlockPos blockPos;
            if (!((double)randomSource.m_188501_() < BetterMineshaftsCommon.CONFIG.spawnRates.smallShaftChestMinecartSpawnRate) || !box.m_71051_((Vec3i)(blockPos = this.m_163582_(2, 1, z))) || world.m_8055_(blockPos.m_7495_()).m_60795_()) continue;
            MinecartChest chestMinecartEntity = new MinecartChest((Level)world.m_6018_(), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
            chestMinecartEntity.m_38236_(BuiltInLootTables.f_78759_, randomSource.m_188505_());
            world.m_7967_((Entity)chestMinecartEntity);
        }
    }

    private void generateSupports(WorldGenLevel world, BoundingBox box, RandomSource randomSource) {
        float cobwebChance = (float)BetterMineshaftsCommon.CONFIG.spawnRates.cobwebSpawnRate;
        BlockState supportBlock = this.config.blockStates.supportBlockState;
        if (supportBlock.m_61147_().contains(BlockStateProperties.f_61378_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61381_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61378_, (Comparable)WallSide.TALL)).m_61124_((Property)BlockStateProperties.f_61381_, (Comparable)WallSide.TALL);
        } else if (supportBlock.m_61147_().contains(BlockStateProperties.f_61369_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61371_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.supports) {
            int numCovered = 0;
            for (int x = 1; x <= 3; ++x) {
                BlockState blockState = this.m_73398_((BlockGetter)world, x, 4, z, box);
                if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50184_)) continue;
                ++numCovered;
            }
            if (numCovered < 2) continue;
            this.fill(world, box, 1, 1, z, 1, 2, z, this.config.blockStates.supportBlockState);
            this.fill(world, box, 3, 1, z, 3, 2, z, this.config.blockStates.supportBlockState);
            this.fill(world, box, 1, 3, z, 3, 3, z, this.config.blockStates.mainBlockState);
            this.chanceReplaceNonAir(world, box, randomSource, 0.25f, 1, 3, z, 3, 3, z, supportBlock);
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 1, 3, z - 1, 1, 3, z + 1, Blocks.f_50033_.m_49966_());
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 3, 3, z - 1, 3, 3, z + 1, Blocks.f_50033_.m_49966_());
        }
    }

    private void generateRails(WorldGenLevel world, BoundingBox box, RandomSource randomSource) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int z = 0; z <= 7; ++z) {
            mutable.m_122178_(this.m_73392_(2, z), this.m_73544_(1), this.m_73525_(2, z));
            if (!(randomSource.m_188501_() < 0.5f) || !this.m_73398_((BlockGetter)world, 2, 1, z, box).m_60713_(Blocks.f_50016_) && !this.m_73398_((BlockGetter)world, 2, 1, z, box).m_60713_(Blocks.f_50627_) || !Blocks.f_50156_.m_7898_(AIR, (LevelReader)world, (BlockPos)mutable)) continue;
            this.m_73434_(world, Blocks.f_50156_.m_49966_(), 2, 1, z, this.f_73383_);
        }
        for (int n = 0; n <= 7; ++n) {
            this.chanceReplaceAir(world, randomSource, 0.07f, (BlockState)Blocks.f_50030_.m_49966_().m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(true)), 2, 1, n, box);
        }
    }

    private void generateTntCarts(WorldGenLevel world, BoundingBox box, RandomSource randomSource) {
        for (int z = 0; z <= 7; ++z) {
            BlockPos.MutableBlockPos blockPos;
            if (!((double)randomSource.m_188501_() < BetterMineshaftsCommon.CONFIG.spawnRates.smallShaftTntMinecartSpawnRate) || !box.m_71051_((Vec3i)(blockPos = this.m_163582_(2, 1, z))) || world.m_8055_(blockPos.m_7495_()).m_60795_()) continue;
            MinecartTNT tntMinecartEntity = new MinecartTNT((Level)world.m_6018_(), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
            world.m_7967_((Entity)tntMinecartEntity);
        }
    }

    private void generateTorches(WorldGenLevel world, BoundingBox box, RandomSource randomSource) {
        BlockState torchBlock = Blocks.f_50082_.m_49966_();
        for (int z = 0; z <= 7; ++z) {
            boolean canPlace;
            BlockPos.MutableBlockPos adjPos;
            BlockPos.MutableBlockPos pos;
            if (this.supports.contains(z)) continue;
            float r = randomSource.m_188501_();
            if ((double)r < BetterMineshaftsCommon.CONFIG.spawnRates.torchSpawnRate / 2.0) {
                pos = this.m_163582_(1, 2, z);
                adjPos = this.m_163582_(0, 2, z);
                boolean bl = canPlace = world.m_8055_((BlockPos)pos).m_60795_() && world.m_8055_((BlockPos)adjPos) != AIR;
                if (!canPlace) continue;
                this.replaceAirOrChains(world, box, 1, 2, z, 1, 2, z, (BlockState)torchBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST));
                continue;
            }
            if (!((double)r < BetterMineshaftsCommon.CONFIG.spawnRates.torchSpawnRate)) continue;
            pos = this.m_163582_(3, 2, z);
            adjPos = this.m_163582_(4, 2, z);
            boolean bl = canPlace = world.m_8055_((BlockPos)pos).m_60795_() && world.m_8055_((BlockPos)adjPos) != AIR;
            if (!canPlace) continue;
            this.replaceAirOrChains(world, box, 3, 2, z, 3, 2, z, (BlockState)torchBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST));
        }
    }

    private void generatePillarsOrChains(WorldGenLevel world, BoundingBox box, RandomSource randomSource) {
        this.generatePillarDownOrChainUp(world, randomSource, box, 1, 0, 1);
        this.generatePillarDownOrChainUp(world, randomSource, box, 3, 0, 1);
        this.generatePillarDownOrChainUp(world, randomSource, box, 1, 0, 6);
        this.generatePillarDownOrChainUp(world, randomSource, box, 3, 0, 6);
    }

    private void replaceExistingChainsWithChainBlock(WorldGenLevel world, BoundingBox box) {
        for (int x = 0; x <= 4; ++x) {
            for (int z = 0; z <= 7; ++z) {
                if (!this.m_73398_((BlockGetter)world, x, 1, z, box).m_60713_(Blocks.f_50184_)) continue;
                this.m_73434_(world, this.config.blockStates.supportBlockState, x, 1, z, box);
            }
        }
    }

    private void buildSupports(RandomSource randomSource) {
        for (int z = 0; z <= 7; ++z) {
            int r = randomSource.m_188503_(7);
            if (r != 0) continue;
            this.supports.add(z);
            z += 5;
        }
    }
}

