/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigType;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ConfigSpec {
    private static final Map<String, Map<ConfigType, ConfigSpec>> CONFIG_STORAGE = new ConcurrentHashMap<String, Map<ConfigType, ConfigSpec>>();
    private final String fileName;
    private final String modId;
    private final Path filePath;
    private final ConfigType type;
    private final boolean synced;
    @Nullable
    private final Runnable changeCallback;

    public static void addTrackedSpec(ConfigSpec spec) {
        Map map = CONFIG_STORAGE.computeIfAbsent(spec.getModId(), n -> new HashMap());
        map.put(spec.getConfigType(), spec);
    }

    @Nullable
    public static ConfigSpec getSpec(String modId, ConfigType type) {
        Map<ConfigType, ConfigSpec> map = CONFIG_STORAGE.get(modId);
        if (map != null) {
            return map.getOrDefault((Object)type, null);
        }
        return null;
    }

    protected ConfigSpec(ResourceLocation name, Path configDirectory, ConfigType type) {
        this(name, configDirectory, type, false, null);
    }

    protected ConfigSpec(ResourceLocation name, Path configDirectory, ConfigType type, boolean synced, @Nullable Runnable changeCallback) {
        this.fileName = name.m_135827_() + "-" + name.m_135815_() + ".json";
        this.modId = name.m_135827_();
        this.filePath = configDirectory.resolve(this.fileName);
        this.type = type;
        this.synced = synced;
        this.changeCallback = changeCallback;
    }

    protected void onRefresh() {
        if (this.changeCallback != null) {
            this.changeCallback.run();
        }
    }

    public boolean isLoaded() {
        return true;
    }

    public abstract void loadFromFile();

    public abstract void register();

    public ConfigType getConfigType() {
        return this.type;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Path getFullPath() {
        return this.filePath;
    }

    public abstract void loadFromBytes(InputStream var1);

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Screen makeScreen(Screen parent) {
        return this.makeScreen(parent, null);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public abstract Screen makeScreen(Screen var1, @Nullable ResourceLocation var2);

    public abstract boolean hasConfigScreen();

    public void syncConfigsToPlayer(ServerPlayer player) {
    }

    public void sendSyncedConfigsToAllPlayers() {
    }
}

