/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.data;

import com.kirdow.itemlocks.ItemLocks;
import com.kirdow.itemlocks.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.multiplayer.ServerData;

public class LockRepository {
    public static final LockRepository NULL = new LockRepository();
    private Thread asyncThread = null;
    private Set<Integer> locks = new HashSet<Integer>();
    private final String node;
    private final String name;
    private final String raw;

    public LockRepository(ServerData data) {
        this.node = "MP";
        this.raw = data.f_105363_;
        this.name = this.raw.replace('.', '_').replace(':', '-');
    }

    public LockRepository(String world) {
        this.node = "SP";
        this.raw = world;
        this.name = world;
    }

    private LockRepository() {
        this.node = null;
        this.name = null;
        this.raw = null;
    }

    public void lock(int id) {
        if (this.isNull()) {
            return;
        }
        this.locks.add(id);
    }

    public void unlock(int id) {
        if (this.isNull()) {
            return;
        }
        this.locks.remove(id);
    }

    public boolean isLocked(int id) {
        return this.locks.contains(id);
    }

    public void toggle(int id) {
        boolean newState;
        if (this.isNull()) {
            return;
        }
        boolean bl = newState = !this.isLocked(id);
        if (newState) {
            this.lock(id);
        } else {
            this.unlock(id);
        }
    }

    public String getRaw() {
        return this.raw;
    }

    public static File getRepoFile(String node, String name, boolean old) {
        File modFolder = ItemLocks.modFolder;
        File nodeFolder = new File(modFolder, String.format("nodes/%s/", node));
        if (!nodeFolder.exists()) {
            nodeFolder.mkdirs();
        }
        return new File(nodeFolder, String.format(old ? "%s.ilcks.old" : "%s.ilcks", name));
    }

    public static File getRepoFileLoad(String node, String name) {
        File repoFile = LockRepository.getRepoFile(node, name, false);
        if (!repoFile.exists()) {
            return null;
        }
        return repoFile;
    }

    public static File getRepoFileSave(String node, String name) {
        File repoFile = LockRepository.getRepoFile(node, name, false);
        File repoFileOld = LockRepository.getRepoFile(node, name, true);
        if (repoFile.exists()) {
            repoFile.renameTo(repoFileOld);
        }
        repoFile.delete();
        return repoFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        if (this.isNull()) {
            return false;
        }
        File repoFile = LockRepository.getRepoFileLoad(this.node, this.name);
        if (repoFile == null) {
            return false;
        }
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(repoFile));
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
            byte[] buffer = new byte[4];
            while (true) {
                ((DataInputStream)dis).readFully(buffer);
                byteBuffer2.rewind();
                byteBuffer2.put(buffer).rewind();
                int id = byteBuffer2.getInt();
                integerList.add(id);
            }
        }
        catch (EOFException byteBuffer2) {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (Throwable byteBuffer2) {}
        }
        catch (IOException ignored) {
            try {
                boolean buffer = false;
                return buffer;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        this.locks.clear();
        for (Integer id : integerList) {
            this.locks.add(id);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        if (this.isNull()) {
            return false;
        }
        HashSet<Integer> set = new HashSet<Integer>(this.locks);
        File repoFile = LockRepository.getRepoFileSave(this.node, this.name);
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(repoFile));
            for (Integer id : set) {
                ((DataOutputStream)dos).writeInt(id);
            }
            ((DataOutputStream)dos).flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isNull() {
        return this.raw == null || this.node == null || this.name == null;
    }

    public void saveAsync() {
        if (this.asyncThread != null || this.isNull()) {
            return;
        }
        HashSet<Integer> set = new HashSet<Integer>(this.locks);
        this.asyncThread = new Thread(() -> {
            try {
                File repoFile = LockRepository.getRepoFileSave(this.node, this.name);
                DataOutputStream dos = null;
                dos = new DataOutputStream(new FileOutputStream(repoFile));
                for (Integer id : set) {
                    dos.writeInt(id);
                }
                dos.flush();
                Logger.info("Saved lock repository '%s'\n", this.raw);
                try {
                    if (dos == null) return;
                    dos.close();
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
                catch (IOException ignored) {
                    try {
                        if (dos != null) {
                            dos.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.asyncThread = null;
                    return;
                    catch (Throwable throwable) {
                        try {
                            if (dos == null) throw throwable;
                            dos.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                this.asyncThread = null;
            }
        });
        this.asyncThread.start();
    }
}

