/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.update;

public class UpdateCache {
    private boolean lastValue;
    private long lastCheckTime;
    private boolean firstRun;
    private final UpdateCallback callback;

    UpdateCache(UpdateCallback callback) {
        this.callback = callback;
        this.firstRun = false;
    }

    boolean run(long timeout) {
        long currentTime = System.currentTimeMillis();
        long passed = currentTime - this.lastCheckTime;
        if (this.firstRun && passed < timeout) {
            return this.lastValue;
        }
        try {
            this.lastValue = this.callback.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.lastCheckTime = System.currentTimeMillis();
        this.firstRun = true;
        return this.lastValue;
    }

    static interface UpdateCallback {
        public boolean run();
    }
}

