/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.config.gui;

import com.kirdow.itemlocks.config.LockOptions;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.reflect.ReflectClass;
import com.kirdow.itemlocks.util.reflect.ReflectField;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.common.ForgeConfigSpec;

public class LocksConfigGui
extends Screen {
    private int centerX;
    private int centerY;
    private int marginX;
    private int marginY;
    private int mouseX;
    private int mouseY;
    private Screen previousMenu;
    private Button globalBtn;
    private Button chatBtn;
    private Button bypassHeldBtn;
    private Button bypassAllBtn;
    private Button bypassOffhandBtn;
    private Button hotbarVisBtn;
    private int buttonY;
    private double scrollY;
    private double scrollYmax;
    private boolean dirty;
    private List<Consumer<Integer>> scrollCorrectionList = new ArrayList<Consumer<Integer>>();
    private static ReflectField isHoveredField = ReflectClass.forClass(AbstractWidget.class).getDeclaredFieldAt(6);
    private Component activeTooltip;

    public LocksConfigGui() {
        this(null);
    }

    public LocksConfigGui(Screen previous) {
        super((Component)Component.m_237115_((String)"config.ktnilcks.base.config_title"));
        this.previousMenu = previous;
    }

    private int getOptionPosition(int index, boolean isText) {
        return 44 + 24 * index + (isText ? 6 : 0);
    }

    private void resetButtonPlacement() {
        this.buttonY = 0;
    }

    private void correctScroll() {
        double max = this.scrollYmax;
        this.scrollYmax = this.getOptionPosition(11, true) - this.f_96544_;
        if (this.scrollYmax < 0.0) {
            this.scrollYmax = 0.0;
        }
        if (this.scrollYmax != max) {
            this.dirty = true;
        }
        if (this.scrollY < 0.0) {
            this.dirty = true;
            this.scrollY = 0.0;
        }
        if (this.scrollY > this.scrollYmax) {
            this.dirty = true;
            this.scrollY = this.scrollYmax;
        }
        if (this.dirty) {
            for (Consumer<Integer> f : this.scrollCorrectionList) {
                f.accept((int)this.scrollY);
            }
            this.dirty = false;
        }
    }

    private Button nextButton(String titleCode, String hoverCode, boolean state, Supplier<Boolean> stateCallback) {
        Button result = Button.m_253074_((Component)this.getMessageFromState(state), btn -> {
            boolean newState = (Boolean)stateCallback.get();
            btn.m_93666_(this.getMessageFromState((Boolean)stateCallback.get()));
        }).m_252794_(this.centerX + 10, this.getOptionPosition(this.buttonY, false)).m_253046_(100, 20).m_253136_();
        return result;
    }

    public void m_7856_() {
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.marginX = 10;
        this.marginY = 10;
        MutableComponent backText = Component.m_237115_((String)"gui.back");
        Button button = Button.m_253074_((Component)backText, btn -> this.m_7379_()).m_252794_(10, 10).m_253046_(Core.mc().f_91062_.m_92895_(backText.getString()) + 12, 20).m_253136_();
        this.m_142416_((GuiEventListener)button);
        this.globalBtn = this.addRenderableToggle(1, LockOptions.CLIENT.notifyGlobal);
        this.chatBtn = this.addRenderableToggle(2, LockOptions.CLIENT.notifyChat);
        this.bypassHeldBtn = this.addRenderableToggle(5, LockOptions.CLIENT.bypassHeld);
        this.bypassOffhandBtn = this.addRenderableToggle(6, LockOptions.CLIENT.offhandBypass);
        this.bypassAllBtn = this.addRenderableToggle(7, LockOptions.CLIENT.bypassAll);
        this.hotbarVisBtn = this.addRenderableToggle(10, LockOptions.CLIENT.hotbarVis);
        this.chatBtn.f_93623_ = (Boolean)LockOptions.CLIENT.notifyGlobal.get();
    }

    private Button addRenderableToggle(int pos, ForgeConfigSpec.ConfigValue<Boolean> option) {
        Button button = Button.m_253074_((Component)this.getMessageFromState((Boolean)option.get()), btn -> {
            boolean newState = (Boolean)option.get() == false;
            option.set((Object)newState);
            btn.m_93666_(this.getMessageFromState(newState));
        }).m_252794_(this.centerX + 10, this.getOptionPosition(pos, false)).m_253046_(100, 20).m_253136_();
        this.scrollCorrectionList.add(scroll -> button.m_253211_(this.getOptionPosition(pos, false) - scroll));
        this.m_142416_((GuiEventListener)button);
        return button;
    }

    private Component getMessageFromState(boolean state) {
        return Component.m_237115_((String)(state ? "gui.yes" : "gui.no")).m_6270_(Style.f_131099_.m_131140_(state ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.correctScroll();
        this.m_7333_(matrixStack);
        MutableComponent titleText = Component.m_237115_((String)"config.ktnilcks.base.config_title");
        Font font = Core.mc().f_91062_;
        font.m_92763_(matrixStack, (Component)titleText, (float)((this.f_96543_ - font.m_92895_(titleText.getString())) / 2), (float)(20 - (int)this.scrollY), 0xF0F0F0);
        this.drawButtonPrefix(matrixStack, 0, "config.ktnilcks.section.versions", null);
        this.drawButtonPrefix(matrixStack, 1, "config.ktnilcks.notify.global.short", "config.ktnilcks.notify.global.long");
        this.drawButtonPrefix(matrixStack, 2, "config.ktnilcks.notify.chat.short", "config.ktnilcks.notify.chat.long");
        this.drawButtonPrefix(matrixStack, 4, "config.ktnilcks.section.actions", null);
        this.drawButtonPrefix(matrixStack, 5, "config.ktnilcks.action.bypassheld.short", "config.ktnilcks.action.bypassheld.long");
        this.drawButtonPrefix(matrixStack, 6, "config.ktnilcks.action.bypassoffhand.short", "config.ktnilcks.action.bypassoffhand.long");
        this.drawButtonPrefix(matrixStack, 7, "config.ktnilcks.action.bypassall.short", "config.ktnilcks.action.bypassall.long");
        this.drawButtonPrefix(matrixStack, 9, "config.ktnilcks.section.hotbar", null);
        this.drawButtonPrefix(matrixStack, 10, "config.ktnilcks.hotbar.visible.short", "config.ktnilcks.hotbar.visible.long");
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != null) {
            List hoverTextLines = font.m_92923_((FormattedText)this.activeTooltip, 134);
            this.m_96617_(matrixStack, hoverTextLines, mouseX, mouseY);
        }
    }

    private void drawButtonPrefix(PoseStack ms, int index, String key, String hover) {
        Style style = Style.f_131099_.m_131140_(ChatFormatting.WHITE);
        if (hover != null) {
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)hover).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN))));
        }
        this.drawButtonPrefix(ms, (Component)Component.m_237115_((String)key).m_6270_(style), index, hover == null);
    }

    private void drawButtonPrefix(PoseStack matrixStack, Component text, int index, boolean isTitle) {
        block5: {
            block4: {
                Font font = Core.mc().f_91062_;
                int textWidth = font.m_92895_(text.getString());
                int x = this.centerX - (isTitle ? textWidth / 2 : textWidth + 10);
                int y = this.getOptionPosition(index, true) - (int)this.scrollY;
                Core.mc().f_91062_.m_92763_(matrixStack, text, (float)x, (float)y, 0xF0F0F0);
                if (this.mouseX < x - 10 || this.mouseY < y - 10 || this.mouseX > x + textWidth + 10) break block4;
                Objects.requireNonNull(font);
                if (this.mouseY <= y + 9 + 10) break block5;
            }
            return;
        }
        HoverEvent event = text.m_7383_().m_131186_();
        if (event != null && event.m_130820_() == HoverEvent.Action.f_130831_) {
            this.activeTooltip = (Component)event.m_130823_(HoverEvent.Action.f_130831_);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (amount != 0.0) {
            this.scrollY -= 9.0 * amount;
            this.dirty = true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_7379_() {
        if (this.previousMenu != null) {
            Core.mc().m_91152_(this.previousMenu);
        } else {
            super.m_7379_();
        }
    }
}

