/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.util.reflect;

import com.kirdow.itemlocks.util.reflect.ReflectClass;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ReflectField {
    private static final ReflectField NULL = new ReflectField(null);
    private static Map<Field, ReflectField> cache = new HashMap<Field, ReflectField>();
    public final Field field;

    public static ReflectField forField(Field field) {
        if (field == null) {
            return null;
        }
        return cache.computeIfAbsent(field, key -> new ReflectField((Field)key));
    }

    private ReflectField(Field field) {
        this.field = field;
    }

    public boolean isNull() {
        return this.field == null;
    }

    public boolean isValid() {
        return this.field != null;
    }

    public ReflectClass getParent() {
        if (this.field == null) {
            return ReflectClass.forClass((Class)null);
        }
        return ReflectClass.forClass(this.field.getDeclaringClass());
    }

    public ReflectClass getType() {
        if (this.field == null) {
            return ReflectClass.forClass((Class)null);
        }
        return ReflectClass.forClass(this.field.getType());
    }

    public <T> T get(Object owner) {
        Object obj = null;
        this.field.setAccessible(true);
        try {
            obj = this.field.get(owner);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return (T)obj;
    }

    public <T> void set(Object owner, T value) {
        this.field.setAccessible(true);
        try {
            this.field.set(owner, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public boolean move(Object src, Object dst) {
        this.field.setAccessible(true);
        try {
            Object obj = this.field.get(src);
            this.field.set(dst, obj);
            return true;
        }
        catch (IllegalAccessException ignored) {
            return false;
        }
    }
}

