/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.util.reflect;

import com.kirdow.itemlocks.util.reflect.ReflectClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ReflectMethod {
    private static final ReflectMethod NULL = new ReflectMethod(null);
    private static Map<Method, ReflectMethod> cache = new HashMap<Method, ReflectMethod>();
    public final Method method;

    public static ReflectMethod forMethod(Method method) {
        if (method == null) {
            return null;
        }
        return cache.computeIfAbsent(method, key -> new ReflectMethod((Method)key));
    }

    private ReflectMethod(Method method) {
        this.method = method;
    }

    public boolean isNull() {
        return this.method == null;
    }

    public boolean isValid() {
        return this.method != null;
    }

    public ReflectClass getParent() {
        if (this.method == null) {
            return ReflectClass.forClass((Class)null);
        }
        return ReflectClass.forClass(this.method.getDeclaringClass());
    }

    public ReflectClass getReturnType() {
        if (this.method == null) {
            return ReflectClass.forClass((Class)null);
        }
        return ReflectClass.forClass(this.method.getReturnType());
    }

    public ReflectClass[] getParameterTypes() {
        if (this.method == null) {
            return new ReflectClass[0];
        }
        return Arrays.stream(this.method.getParameterTypes()).map(ReflectClass::forClass).collect(Collectors.toList()).toArray(new ReflectClass[0]);
    }

    public <T> T invoke(Object owner, Object ... args) {
        if (this.method == null) {
            return null;
        }
        Object obj = null;
        this.method.setAccessible(true);
        try {
            obj = this.method.invoke(owner, args);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return (T)obj;
    }
}

