/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rpgstylemoreweapons.network;

import java.util.function.Supplier;
import net.mcreator.rpgstylemoreweapons.RpgsmwMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RpgsmwModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        RpgsmwMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        RpgsmwMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.mana = message.data.mana;
                    variables.Iron_scane = message.data.Iron_scane;
                    variables.Amethyst_scane = message.data.Amethyst_scane;
                    variables.Dash_allow = message.data.Dash_allow;
                    variables.Dash = message.data.Dash;
                    variables.Spears_dashing = message.data.Spears_dashing;
                    variables.Aquamarine_nuckle = message.data.Aquamarine_nuckle;
                    variables.ManaAuraNephris = message.data.ManaAuraNephris;
                    variables.Shield_paladin = message.data.Shield_paladin;
                    variables.Armour_count = message.data.Armour_count;
                    variables.Berserk_armor = message.data.Berserk_armor;
                    variables.Ice_scane = message.data.Ice_scane;
                    variables.Mage_skill = message.data.Mage_skill;
                    variables.AssassinEqiupedTool = message.data.AssassinEqiupedTool;
                    variables.PaladinEqiupedTool = message.data.PaladinEqiupedTool;
                    variables.BerserkEqiupedTool = message.data.BerserkEqiupedTool;
                    variables.MageEqiupedTool = message.data.MageEqiupedTool;
                    variables.WeaponsAbility = message.data.WeaponsAbility;
                    variables.SmallTimeResistanceAfterUseAbility = message.data.SmallTimeResistanceAfterUseAbility;
                    variables.RingOfUnbrecable = message.data.RingOfUnbrecable;
                    variables.RingOfCD = message.data.RingOfCD;
                    variables.FireResistanceRing = message.data.FireResistanceRing;
                    variables.AssassinClassWeaponInMainHand = message.data.AssassinClassWeaponInMainHand;
                    variables.BerserkClassWeaponInMainHand = message.data.BerserkClassWeaponInMainHand;
                    variables.PaladinClassWeaponInMainHand = message.data.PaladinClassWeaponInMainHand;
                    variables.MageClassWeaponInMainHand = message.data.MageClassWeaponInMainHand;
                    variables.CopperBerserkRing = message.data.CopperBerserkRing;
                    variables.CopperPaladinRing = message.data.CopperPaladinRing;
                    variables.CopperAssassinRing = message.data.CopperAssassinRing;
                    variables.AssassinArmorAbilityresistance = message.data.AssassinArmorAbilityresistance;
                    variables.FireBoltResistance = message.data.FireBoltResistance;
                    variables.PoisonBoltResistance = message.data.PoisonBoltResistance;
                    variables.RangerClassWeaponInMainHand = message.data.RangerClassWeaponInMainHand;
                    variables.RangerArmorAbility = message.data.RangerArmorAbility;
                    variables.BurstingShotDamage = message.data.BurstingShotDamage;
                    variables.SmallResistanceAfterNetheriteRifleShoot = message.data.SmallResistanceAfterNetheriteRifleShoot;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double mana = 0.0;
        public double Iron_scane = 1.0;
        public double Amethyst_scane = 1.0;
        public boolean Dash_allow = false;
        public double Dash = 1.0;
        public double Spears_dashing = 0.0;
        public boolean Aquamarine_nuckle = false;
        public boolean ManaAuraNephris = false;
        public double Shield_paladin = 0.0;
        public double Armour_count = 0.0;
        public double Berserk_armor = 0.0;
        public boolean Ice_scane = false;
        public double Mage_skill = 0.0;
        public boolean AssassinEqiupedTool = false;
        public boolean PaladinEqiupedTool = false;
        public boolean BerserkEqiupedTool = false;
        public boolean MageEqiupedTool = false;
        public boolean WeaponsAbility = true;
        public boolean SmallTimeResistanceAfterUseAbility = false;
        public boolean RingOfUnbrecable = false;
        public boolean RingOfCD = false;
        public boolean FireResistanceRing = false;
        public boolean AssassinClassWeaponInMainHand = false;
        public boolean BerserkClassWeaponInMainHand = false;
        public boolean PaladinClassWeaponInMainHand = false;
        public boolean MageClassWeaponInMainHand = false;
        public boolean CopperBerserkRing = false;
        public boolean CopperPaladinRing = false;
        public boolean CopperAssassinRing = false;
        public boolean AssassinArmorAbilityresistance = false;
        public boolean FireBoltResistance = false;
        public boolean PoisonBoltResistance = false;
        public boolean RangerClassWeaponInMainHand = false;
        public double RangerArmorAbility = 0.0;
        public double BurstingShotDamage = 0.0;
        public boolean SmallResistanceAfterNetheriteRifleShoot = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                RpgsmwMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("mana", this.mana);
            nbt.m_128347_("Iron_scane", this.Iron_scane);
            nbt.m_128347_("Amethyst_scane", this.Amethyst_scane);
            nbt.m_128379_("Dash_allow", this.Dash_allow);
            nbt.m_128347_("Dash", this.Dash);
            nbt.m_128347_("Spears_dashing", this.Spears_dashing);
            nbt.m_128379_("Aquamarine_nuckle", this.Aquamarine_nuckle);
            nbt.m_128379_("ManaAuraNephris", this.ManaAuraNephris);
            nbt.m_128347_("Shield_paladin", this.Shield_paladin);
            nbt.m_128347_("Armour_count", this.Armour_count);
            nbt.m_128347_("Berserk_armor", this.Berserk_armor);
            nbt.m_128379_("Ice_scane", this.Ice_scane);
            nbt.m_128347_("Mage_skill", this.Mage_skill);
            nbt.m_128379_("AssassinEqiupedTool", this.AssassinEqiupedTool);
            nbt.m_128379_("PaladinEqiupedTool", this.PaladinEqiupedTool);
            nbt.m_128379_("BerserkEqiupedTool", this.BerserkEqiupedTool);
            nbt.m_128379_("MageEqiupedTool", this.MageEqiupedTool);
            nbt.m_128379_("WeaponsAbility", this.WeaponsAbility);
            nbt.m_128379_("SmallTimeResistanceAfterUseAbility", this.SmallTimeResistanceAfterUseAbility);
            nbt.m_128379_("RingOfUnbrecable", this.RingOfUnbrecable);
            nbt.m_128379_("RingOfCD", this.RingOfCD);
            nbt.m_128379_("FireResistanceRing", this.FireResistanceRing);
            nbt.m_128379_("AssassinClassWeaponInMainHand", this.AssassinClassWeaponInMainHand);
            nbt.m_128379_("BerserkClassWeaponInMainHand", this.BerserkClassWeaponInMainHand);
            nbt.m_128379_("PaladinClassWeaponInMainHand", this.PaladinClassWeaponInMainHand);
            nbt.m_128379_("MageClassWeaponInMainHand", this.MageClassWeaponInMainHand);
            nbt.m_128379_("CopperBerserkRing", this.CopperBerserkRing);
            nbt.m_128379_("CopperPaladinRing", this.CopperPaladinRing);
            nbt.m_128379_("CopperAssassinRing", this.CopperAssassinRing);
            nbt.m_128379_("AssassinArmorAbilityresistance", this.AssassinArmorAbilityresistance);
            nbt.m_128379_("FireBoltResistance", this.FireBoltResistance);
            nbt.m_128379_("PoisonBoltResistance", this.PoisonBoltResistance);
            nbt.m_128379_("RangerClassWeaponInMainHand", this.RangerClassWeaponInMainHand);
            nbt.m_128347_("RangerArmorAbility", this.RangerArmorAbility);
            nbt.m_128347_("BurstingShotDamage", this.BurstingShotDamage);
            nbt.m_128379_("SmallResistanceAfterNetheriteRifleShoot", this.SmallResistanceAfterNetheriteRifleShoot);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.mana = nbt.m_128459_("mana");
            this.Iron_scane = nbt.m_128459_("Iron_scane");
            this.Amethyst_scane = nbt.m_128459_("Amethyst_scane");
            this.Dash_allow = nbt.m_128471_("Dash_allow");
            this.Dash = nbt.m_128459_("Dash");
            this.Spears_dashing = nbt.m_128459_("Spears_dashing");
            this.Aquamarine_nuckle = nbt.m_128471_("Aquamarine_nuckle");
            this.ManaAuraNephris = nbt.m_128471_("ManaAuraNephris");
            this.Shield_paladin = nbt.m_128459_("Shield_paladin");
            this.Armour_count = nbt.m_128459_("Armour_count");
            this.Berserk_armor = nbt.m_128459_("Berserk_armor");
            this.Ice_scane = nbt.m_128471_("Ice_scane");
            this.Mage_skill = nbt.m_128459_("Mage_skill");
            this.AssassinEqiupedTool = nbt.m_128471_("AssassinEqiupedTool");
            this.PaladinEqiupedTool = nbt.m_128471_("PaladinEqiupedTool");
            this.BerserkEqiupedTool = nbt.m_128471_("BerserkEqiupedTool");
            this.MageEqiupedTool = nbt.m_128471_("MageEqiupedTool");
            this.WeaponsAbility = nbt.m_128471_("WeaponsAbility");
            this.SmallTimeResistanceAfterUseAbility = nbt.m_128471_("SmallTimeResistanceAfterUseAbility");
            this.RingOfUnbrecable = nbt.m_128471_("RingOfUnbrecable");
            this.RingOfCD = nbt.m_128471_("RingOfCD");
            this.FireResistanceRing = nbt.m_128471_("FireResistanceRing");
            this.AssassinClassWeaponInMainHand = nbt.m_128471_("AssassinClassWeaponInMainHand");
            this.BerserkClassWeaponInMainHand = nbt.m_128471_("BerserkClassWeaponInMainHand");
            this.PaladinClassWeaponInMainHand = nbt.m_128471_("PaladinClassWeaponInMainHand");
            this.MageClassWeaponInMainHand = nbt.m_128471_("MageClassWeaponInMainHand");
            this.CopperBerserkRing = nbt.m_128471_("CopperBerserkRing");
            this.CopperPaladinRing = nbt.m_128471_("CopperPaladinRing");
            this.CopperAssassinRing = nbt.m_128471_("CopperAssassinRing");
            this.AssassinArmorAbilityresistance = nbt.m_128471_("AssassinArmorAbilityresistance");
            this.FireBoltResistance = nbt.m_128471_("FireBoltResistance");
            this.PoisonBoltResistance = nbt.m_128471_("PoisonBoltResistance");
            this.RangerClassWeaponInMainHand = nbt.m_128471_("RangerClassWeaponInMainHand");
            this.RangerArmorAbility = nbt.m_128459_("RangerArmorAbility");
            this.BurstingShotDamage = nbt.m_128459_("BurstingShotDamage");
            this.SmallResistanceAfterNetheriteRifleShoot = nbt.m_128471_("SmallResistanceAfterNetheriteRifleShoot");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("rpgsmw", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "rpgsmw_mapvars";
        public boolean Fire_hammer_rage = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.Fire_hammer_rage = nbt.m_128471_("Fire_hammer_rage");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("Fire_hammer_rage", this.Fire_hammer_rage);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                RpgsmwMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "rpgsmw_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                RpgsmwMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            if (!event.isWasDeath()) {
                clone.mana = original.mana;
                clone.Iron_scane = original.Iron_scane;
                clone.Amethyst_scane = original.Amethyst_scane;
                clone.Dash_allow = original.Dash_allow;
                clone.Dash = original.Dash;
                clone.Spears_dashing = original.Spears_dashing;
                clone.Aquamarine_nuckle = original.Aquamarine_nuckle;
                clone.ManaAuraNephris = original.ManaAuraNephris;
                clone.Shield_paladin = original.Shield_paladin;
                clone.Armour_count = original.Armour_count;
                clone.Berserk_armor = original.Berserk_armor;
                clone.Ice_scane = original.Ice_scane;
                clone.Mage_skill = original.Mage_skill;
                clone.AssassinEqiupedTool = original.AssassinEqiupedTool;
                clone.PaladinEqiupedTool = original.PaladinEqiupedTool;
                clone.BerserkEqiupedTool = original.BerserkEqiupedTool;
                clone.MageEqiupedTool = original.MageEqiupedTool;
                clone.WeaponsAbility = original.WeaponsAbility;
                clone.SmallTimeResistanceAfterUseAbility = original.SmallTimeResistanceAfterUseAbility;
                clone.RingOfUnbrecable = original.RingOfUnbrecable;
                clone.RingOfCD = original.RingOfCD;
                clone.FireResistanceRing = original.FireResistanceRing;
                clone.AssassinClassWeaponInMainHand = original.AssassinClassWeaponInMainHand;
                clone.BerserkClassWeaponInMainHand = original.BerserkClassWeaponInMainHand;
                clone.PaladinClassWeaponInMainHand = original.PaladinClassWeaponInMainHand;
                clone.MageClassWeaponInMainHand = original.MageClassWeaponInMainHand;
                clone.CopperBerserkRing = original.CopperBerserkRing;
                clone.CopperPaladinRing = original.CopperPaladinRing;
                clone.CopperAssassinRing = original.CopperAssassinRing;
                clone.AssassinArmorAbilityresistance = original.AssassinArmorAbilityresistance;
                clone.FireBoltResistance = original.FireBoltResistance;
                clone.PoisonBoltResistance = original.PoisonBoltResistance;
                clone.RangerClassWeaponInMainHand = original.RangerClassWeaponInMainHand;
                clone.RangerArmorAbility = original.RangerArmorAbility;
                clone.BurstingShotDamage = original.BurstingShotDamage;
                clone.SmallResistanceAfterNetheriteRifleShoot = original.SmallResistanceAfterNetheriteRifleShoot;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    RpgsmwMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    RpgsmwMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                RpgsmwMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

