/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import com.mcwwindows.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindowBarred
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty LOCKED = BlockStateProperties.f_61444_;
    protected static final VoxelShape EE = WindowBarred.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = WindowBarred.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public WindowBarred(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Boolean openik = (Boolean)state.m_61143_((Property)OPEN);
        switch ((Direction)state.m_61143_((Property)FACING)) {
            default: {
                if (openik.booleanValue()) {
                    return Shapes.m_83040_();
                }
                return EE;
            }
            case NORTH: {
                if (openik.booleanValue()) {
                    return Shapes.m_83040_();
                }
                return EE;
            }
            case EAST: {
                if (openik.booleanValue()) {
                    return Shapes.m_83040_();
                }
                return NN;
            }
            case WEST: 
        }
        if (openik.booleanValue()) {
            return Shapes.m_83040_();
        }
        return NN;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(context));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livent, ItemStack stack) {
        Block block = level.m_8055_(pos).m_60734_();
        Block below = level.m_8055_(pos.m_6625_(1)).m_60734_();
        if (block == this && below == block) {
            DoorHingeSide hinge = (DoorHingeSide)level.m_8055_(pos.m_6625_(1)).m_61143_(HINGE);
            level.m_46597_(pos, (BlockState)state.m_61124_(HINGE, (Comparable)hinge));
        }
    }

    protected DoorHingeSide getHinge(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        int j = direction.m_122429_();
        int k = direction.m_122431_();
        Vec3 vector3d = context.m_43720_();
        double d0 = vector3d.f_82479_ - (double)blockpos.m_123341_();
        double d1 = vector3d.f_82481_ - (double)blockpos.m_123343_();
        return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item == ItemInit.KEY.get()) {
            this.raiseBlinds(level, pos, (Boolean)state.m_61143_((Property)LOCKED) == false, (Direction)state.m_61143_((Property)FACING), 1000);
            level.m_5594_(null, pos, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
            state = (BlockState)state.m_61122_((Property)LOCKED);
            level.m_7731_(pos, state, 10);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)LOCKED)).booleanValue() || item == this.m_5456_()) {
            return InteractionResult.PASS;
        }
        Boolean open = (Boolean)state.m_61143_((Property)OPEN);
        if (open.booleanValue()) {
            level.m_5594_(null, pos, (SoundEvent)SoundsInit.WINDOW_CLOSE.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
        } else {
            level.m_5594_(null, pos, (SoundEvent)SoundsInit.WINDOW_OPEN.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
        }
        this.openWindow(level, pos, (DoorHingeSide)state.m_61143_(HINGE), (Boolean)state.m_61143_((Property)OPEN) == false);
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 10);
        return InteractionResult.SUCCESS;
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean bool) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)OPEN) != bool) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(bool)), 10);
            level.m_142346_(entity, bool ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? NN : EE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, HINGE, LOCKED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.m_7417_(stateIn, facing, facingState, (LevelAccessor)worldIn, currentPos, facingPos);
    }

    private void openWindow(Level world, BlockPos pos, DoorHingeSide hingeSide, boolean open) {
        DoorHingeSide blockHingeSide;
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this && (blockHingeSide = (DoorHingeSide)state.m_61143_(HINGE)) == hingeSide && (Boolean)state.m_61143_((Property)OPEN) != open) {
            int y;
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)));
            for (y = 1; y <= 2; ++y) {
                BlockPos newPosUp = pos.m_6630_(y);
                if (!world.m_46749_(newPosUp) || world.m_8055_(newPosUp).m_60734_() != this) continue;
                this.openWindow(world, newPosUp, hingeSide, open);
            }
            for (y = 1; y <= 2; ++y) {
                BlockPos newPosDown = pos.m_6625_(y);
                if (!world.m_46749_(newPosDown) || world.m_8055_(newPosDown).m_60734_() != this) continue;
                this.openWindow(world, newPosDown, hingeSide, open);
            }
        }
    }

    private void raiseBlinds(Level world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            boolean open = (Boolean)state.m_61143_((Property)LOCKED);
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(targetOpen)));
                if (direction.m_122434_() == Direction.Axis.X) {
                    this.raiseBlinds(world, pos.m_122020_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_122013_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                }
                if (direction.m_122434_() == Direction.Axis.Z) {
                    this.raiseBlinds(world, pos.m_122030_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_122025_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                }
            }
        }
    }
}

