/*
 * Decompiled with CFR 0.152.
 */
package com.forgivingworld.config;

import com.forgivingworld.ForgivingWorldMod;
import com.forgivingworld.config.DimensionData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class CommonConfiguration {
    private static final String DIMENSIONCON = "dimensionconnections";
    public Map<ResourceLocation, List<DimensionData>> dimensionConnections = new HashMap<ResourceLocation, List<DimensionData>>();
    private List<DimensionData> dimensionDataList = new ArrayList<DimensionData>();
    public boolean debuglogging = false;

    protected CommonConfiguration() {
        DimensionData owToNether = new DimensionData(Level.f_46428_.m_135782_(), Level.f_46429_.m_135782_(), DimensionData.SPAWNTYPE.AIR);
        owToNether.belowY = -60;
        owToNether.xMult = 0.125;
        owToNether.zMult = 0.125;
        owToNether.slowFallDuration = 400;
        owToNether.teleportToYlevel = 125;
        this.dimensionDataList.add(owToNether);
        DimensionData endToOw = new DimensionData(Level.f_46430_.m_135782_(), Level.f_46428_.m_135782_(), DimensionData.SPAWNTYPE.AIR);
        endToOw.belowY = 0;
        endToOw.slowFallDuration = 400;
        endToOw.teleportToYlevel = 300;
        this.dimensionDataList.add(endToOw);
        DimensionData netherToNether = new DimensionData(Level.f_46429_.m_135782_(), Level.f_46429_.m_135782_(), DimensionData.SPAWNTYPE.CAVE);
        netherToNether.belowY = 0;
        netherToNether.teleportToYlevel = 4;
        this.dimensionDataList.add(netherToNether);
        DimensionData netherToOw = new DimensionData(Level.f_46429_.m_135782_(), Level.f_46428_.m_135782_(), DimensionData.SPAWNTYPE.CAVE);
        netherToOw.aboveY = 121;
        netherToOw.xMult = 8.0;
        netherToOw.zMult = 8.0;
        netherToOw.teleportToYlevel = -60;
        this.dimensionDataList.add(netherToOw);
        DimensionData owToOw = new DimensionData(Level.f_46428_.m_135782_(), Level.f_46428_.m_135782_(), DimensionData.SPAWNTYPE.AIR);
        owToOw.aboveY = 364;
        owToOw.teleportToYlevel = 360;
        owToNether.slowFallDuration = 400;
        this.dimensionDataList.add(owToOw);
    }

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Enable debug logging, default:false");
        entry2.addProperty("debuglogging", Boolean.valueOf(this.debuglogging));
        root.add("debuglogging", (JsonElement)entry2);
        JsonArray list1 = new JsonArray();
        for (DimensionData data : this.dimensionDataList) {
            list1.add((JsonElement)data.serialize());
        }
        root.add(DIMENSIONCON, (JsonElement)list1);
        return root;
    }

    public void deserialize(JsonObject data) {
        try {
            this.debuglogging = data.get("debuglogging").getAsJsonObject().get("debuglogging").getAsBoolean();
            JsonArray dimensionData = data.get(DIMENSIONCON).getAsJsonArray();
            this.dimensionDataList.clear();
            this.dimensionConnections.clear();
            for (JsonElement element : dimensionData) {
                DimensionData newData = new DimensionData((JsonObject)element);
                this.dimensionDataList.add(newData);
                this.dimensionConnections.computeIfAbsent(newData.from, n -> new ArrayList()).add(newData);
            }
        }
        catch (Exception e) {
            ForgivingWorldMod.LOGGER.error("Could not parse config file", (Throwable)e);
            throw e;
        }
    }
}

