/*
 * Decompiled with CFR 0.152.
 */
package com.forgivingworld.config;

import com.forgivingworld.ForgivingWorldMod;
import com.forgivingworld.config.CommonConfiguration;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class Configuration {
    private final CommonConfiguration commonConfig = new CommonConfiguration();
    final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void load() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("forgivingworld.json");
        File config = configPath.toFile();
        if (!config.exists()) {
            ForgivingWorldMod.LOGGER.warn("Config not found, recreating default");
            this.save();
            this.load();
        } else {
            try {
                this.commonConfig.deserialize((JsonObject)this.gson.fromJson((Reader)Files.newBufferedReader(configPath), JsonObject.class));
            }
            catch (Exception e) {
                ForgivingWorldMod.LOGGER.error("Could not read config from:" + configPath, (Throwable)e);
                this.save();
                this.load();
            }
        }
    }

    public void save() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("forgivingworld.json");
        try {
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            this.gson.toJson((Object)this.commonConfig.serialize(), JsonObject.class, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            ForgivingWorldMod.LOGGER.error("Could not write config to:" + configPath, (Throwable)e);
        }
    }

    public CommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }
}

