/*
 * Decompiled with CFR 0.152.
 */
package com.forgivingworld.event;

import com.forgivingworld.ForgivingWorldMod;
import com.forgivingworld.config.DimensionData;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    public static final TicketType<ChunkPos> TELEPORT_TICKET = TicketType.m_9465_((String)"forgivingworldTP", Comparator.comparingLong(ChunkPos::m_45588_), (int)1200);
    private static final Integer TP_TIME = 10;
    private static final Map<UUID, Integer> playerTpTime = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastTpTime = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.f_19853_.m_5776_() || player.f_19853_.m_46467_() % 80L != 0L || player.m_213877_() || event.phase == TickEvent.Phase.START) {
            return;
        }
        Long lastTime = lastTpTime.get(player.m_20148_());
        if (lastTime != null && player.f_19853_.m_46467_() - lastTime < 300L) {
            return;
        }
        List<DimensionData> dimensionTPs = ForgivingWorldMod.config.getCommonConfig().dimensionConnections.get(player.f_19853_.m_46472_().m_135782_());
        if (dimensionTPs == null || dimensionTPs.isEmpty()) {
            return;
        }
        DimensionData tp = null;
        for (DimensionData data : dimensionTPs) {
            if (!data.shouldTP(player.m_20186_())) continue;
            tp = data;
            break;
        }
        if (tp == null) {
            playerTpTime.remove(player.m_20148_());
            return;
        }
        if (player.m_20186_() < (double)tp.belowY && Math.abs(player.m_20186_() - (double)tp.belowY) > 15.0 || player.m_20186_() > (double)tp.aboveY && Math.abs(player.m_20186_() - (double)tp.aboveY) > 15.0) {
            EventHandler.tryTpPlayer((ServerPlayer)player, tp);
            return;
        }
        int time = playerTpTime.computeIfAbsent(player.m_20148_(), player2 -> 0);
        playerTpTime.put(player.m_20148_(), ++time);
        if (time == 1) {
            player.m_213846_((Component)Component.m_237113_((String)("Dimensional forces are starting to affect you, pulling you " + (player.m_20186_() > (double)tp.aboveY ? "up" : "down") + ", take care!")).m_130940_(ChatFormatting.DARK_AQUA));
        }
        if (time == 6) {
            player.m_213846_((Component)Component.m_237113_((String)"Dimensional forces are getting stronger...").m_130940_(ChatFormatting.DARK_PURPLE));
            ServerLevel gotoWorld = null;
            for (ResourceKey key : player.f_19853_.m_7654_().m_129784_()) {
                if (!key.m_135782_().equals((Object)tp.to)) continue;
                gotoWorld = player.f_19853_.m_7654_().m_129880_(key);
                break;
            }
            if (gotoWorld != null) {
                ChunkPos dimensionPos = new ChunkPos(tp.translatePosition(player.m_20183_()));
                gotoWorld.m_7726_().m_8387_(TELEPORT_TICKET, dimensionPos, 10, (Object)dimensionPos);
            }
        }
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12286_, player.m_5720_(), 0.5f, 2.0f + (ForgivingWorldMod.rand.nextFloat() - ForgivingWorldMod.rand.nextFloat()) * 0.2f);
        if (time > TP_TIME && EventHandler.tryTpPlayer((ServerPlayer)player, tp)) {
            playerTpTime.remove(player.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onVoidDamageRecv(LivingHurtEvent event) {
        if (event.getSource().m_276093_(DamageTypes.f_268724_)) {
            if (!(event.getEntity() instanceof Player) || event.getEntity().f_19853_.f_46443_) {
                return;
            }
            ServerPlayer playerEntity = (ServerPlayer)event.getEntity();
            List<DimensionData> dimensions = ForgivingWorldMod.config.getCommonConfig().dimensionConnections.get(playerEntity.f_19853_.m_46472_().m_135782_());
            if (dimensions == null || dimensions.isEmpty()) {
                return;
            }
            for (DimensionData data : dimensions) {
                if (!(playerEntity.m_20186_() < (double)data.belowY) || !EventHandler.tryTpPlayer(playerEntity, data)) continue;
                event.setAmount(0.0f);
                break;
            }
        }
    }

    private static boolean tryTpPlayer(ServerPlayer playerEntity, DimensionData gotoDim) {
        if (playerEntity.m_7500_() || playerEntity.m_5833_()) {
            return false;
        }
        ServerLevel world = (ServerLevel)playerEntity.f_19853_;
        if (gotoDim == null || !gotoDim.shouldTP(playerEntity.m_20186_())) {
            return false;
        }
        ServerLevel gotoWorld = null;
        for (ResourceKey key : world.m_7654_().m_129784_()) {
            if (!key.m_135782_().equals((Object)gotoDim.to)) continue;
            gotoWorld = world.m_7654_().m_129880_(key);
            break;
        }
        if (gotoWorld == null) {
            return false;
        }
        BlockPos tpPos = gotoDim.getSpawnPos(gotoWorld, playerEntity.m_20185_(), playerEntity.m_20189_());
        if (tpPos == null) {
            return false;
        }
        Long lastTime = lastTpTime.get(playerEntity.m_20148_());
        if (lastTime != null && world.m_46467_() - lastTime < 300L) {
            return false;
        }
        lastTpTime.put(playerEntity.m_20148_(), playerEntity.f_19853_.m_46467_());
        if (ForgivingWorldMod.config.getCommonConfig().debuglogging) {
            ForgivingWorldMod.LOGGER.info("Teleporting player " + playerEntity.m_5446_().getString() + "(" + playerEntity.m_19879_() + ") from " + playerEntity.m_20183_().m_123344_() + " in " + playerEntity.f_19853_.m_46472_().m_135782_() + " to: " + tpPos.m_123344_() + " in " + gotoWorld.m_46472_().m_135782_() + " with TP type:" + gotoDim.yspawn);
        }
        ChunkPos chunkpos = new ChunkPos(tpPos);
        gotoWorld.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)playerEntity.m_19879_());
        playerEntity.m_8127_();
        if (playerEntity.m_5803_()) {
            playerEntity.m_6145_(true, true);
        }
        playerEntity.m_8999_(gotoWorld, (double)tpPos.m_123341_() + 0.5, (double)tpPos.m_123342_(), (double)tpPos.m_123343_() + 0.5, playerEntity.m_146908_(), playerEntity.m_146909_());
        if (gotoDim.slowFallDuration > 0) {
            playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, gotoDim.slowFallDuration));
        }
        playerEntity.f_19789_ = 0.0f;
        playerEntity.f_19853_.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_12287_, playerEntity.m_5720_(), 1.0f, 2.0f + (ForgivingWorldMod.rand.nextFloat() - ForgivingWorldMod.rand.nextFloat()) * 0.2f);
        return true;
    }
}

