/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalentsNext;
import doggytalents.common.block.DogBathBlock;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.block.FoodBowlBlock;
import doggytalents.common.util.Util;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DoggyBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BLOCKS, (String)"doggytalents");
    public static final DeferredRegister<Item> ITEMS = DoggyItems.ITEMS;
    public static final RegistryObject<DogBedBlock> DOG_BED = DoggyBlocks.registerWithItem("dog_bed", DogBedBlock::new, prop -> prop);
    public static final RegistryObject<DogBathBlock> DOG_BATH = DoggyBlocks.registerWithItem("dog_bath", DogBathBlock::new);
    public static final RegistryObject<FoodBowlBlock> FOOD_BOWL = DoggyBlocks.registerWithItem("food_bowl", FoodBowlBlock::new);

    private static Item.Properties createInitialProp() {
        return new Item.Properties();
    }

    private static BlockItem makeItemBlock(Block block) {
        return DoggyBlocks.makeItemBlock(block, null);
    }

    private static BlockItem makeItemBlock(Block block, @Nullable Function<Item.Properties, Item.Properties> extraPropFunc) {
        Item.Properties prop = DoggyBlocks.createInitialProp();
        return new BlockItem(block, extraPropFunc != null ? extraPropFunc.apply(prop) : prop);
    }

    private static <T extends Block> RegistryObject<T> registerWithItem(String name, Supplier<T> blockSupplier, @Nullable Function<Item.Properties, Item.Properties> extraPropFunc) {
        return DoggyBlocks.register(name, blockSupplier, b -> DoggyBlocks.makeItemBlock((Block)b.get(), extraPropFunc));
    }

    private static <T extends Block> RegistryObject<T> registerWithItem(String name, Supplier<T> blockSupplier) {
        return DoggyBlocks.register(name, blockSupplier, b -> DoggyBlocks.makeItemBlock((Block)b.get()));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, Function<RegistryObject<T>, Item> itemFunction) {
        RegistryObject blockObj = DoggyBlocks.register(name, blockSupplier);
        ITEMS.register(name, () -> (Item)itemFunction.apply(blockObj));
        return blockObj;
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier) {
        return BLOCKS.register(name, blockSupplier);
    }

    public static void registerBlockColours(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        Util.acceptOrElse(DOG_BATH, block -> blockColors.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos) : -1, new Block[]{block}), DoggyBlocks::logError);
    }

    public static void logError() {
        DoggyTalentsNext.LOGGER.info("Items/Blocks were not registered for some reason... probably beacuse we are c...r..a..s.hing");
    }
}

