/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyBlocks;
import doggytalents.DoggySounds;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.registry.Accessory;
import doggytalents.common.artifacts.FeatheredMantleArtifact;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.accessory.Wig;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.item.BandaidItem;
import doggytalents.common.item.CanineTrackerItem;
import doggytalents.common.item.ConductingBoneItem;
import doggytalents.common.item.DogResizeItem;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.item.DoggyCharmItem;
import doggytalents.common.item.DroolBoneItem;
import doggytalents.common.item.DyeableAccessoryItem;
import doggytalents.common.item.EggSandwichItem;
import doggytalents.common.item.EnergizerStick;
import doggytalents.common.item.ThrowableItem;
import doggytalents.common.item.TreatBagItem;
import doggytalents.common.item.TreatItem;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.util.Util;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DoggyItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"doggytalents");
    public static final RegistryObject<Item> THROW_BONE = DoggyItems.registerThrowBone("throw_bone");
    public static final RegistryObject<Item> THROW_BONE_WET = DoggyItems.registerThrowBoneWet("throw_bone_wet");
    public static final RegistryObject<Item> THROW_STICK = DoggyItems.registerThrowStick("throw_stick");
    public static final RegistryObject<Item> THROW_STICK_WET = DoggyItems.registerThrowStickWet("throw_stick_wet");
    public static final RegistryObject<Item> TRAINING_TREAT = DoggyItems.registerTreat("training_treat", DogLevel.Type.NORMAL, 20);
    public static final RegistryObject<Item> SUPER_TREAT = DoggyItems.registerTreat("super_treat", DogLevel.Type.NORMAL, 40);
    public static final RegistryObject<Item> MASTER_TREAT = DoggyItems.registerTreat("master_treat", DogLevel.Type.NORMAL, 60);
    public static final RegistryObject<Item> DIRE_TREAT = DoggyItems.registerTreat("dire_treat", DogLevel.Type.DIRE, 30);
    public static final RegistryObject<Item> BREEDING_BONE = DoggyItems.register("breeding_bone");
    public static final RegistryObject<Item> DOGGY_CHARM = DoggyItems.registerWith("doggy_charm", DoggyCharmItem::new, 1);
    public static final RegistryObject<AccessoryItem> RADIO_COLLAR = DoggyItems.registerAccessory("radio_collar", DoggyAccessories.RADIO_BAND);
    public static final RegistryObject<DyeableAccessoryItem> WOOL_COLLAR = DoggyItems.registerAccessoryDyed("wool_collar", DoggyAccessories.DYEABLE_COLLAR);
    public static final RegistryObject<AccessoryItem> CREATIVE_COLLAR = DoggyItems.register("creative_collar", () -> new AccessoryItem((Supplier)DoggyAccessories.GOLDEN_COLLAR, DoggyItems.createInitialProp()){

        public boolean m_5812_(ItemStack stack) {
            return true;
        }
    });
    public static final RegistryObject<AccessoryItem> SPOTTED_COLLAR = DoggyItems.registerAccessory("spotted_collar", DoggyAccessories.SPOTTED_COLLAR);
    public static final RegistryObject<AccessoryItem> MULTICOLOURED_COLLAR = DoggyItems.registerAccessory("multicoloured_collar", DoggyAccessories.MULTICOLORED_COLLAR);
    public static final RegistryObject<Item> CANINE_TRACKER = DoggyItems.registerWith("canine_tracker", CanineTrackerItem::new, 1);
    public static final RegistryObject<Item> CONDUCTING_BONE = DoggyItems.registerWithFireResistant("conducting_bone", ConductingBoneItem::new, 1);
    public static final RegistryObject<Item> CREATIVE_CANINE_TRACKER = DoggyItems.registerWith("creative_canine_tracker", props -> new CanineTrackerItem((Item.Properties)props){

        public boolean m_5812_(ItemStack stack) {
            return true;
        }
    }, 1);
    public static final RegistryObject<WhistleItem> WHISTLE = DoggyItems.registerWith("whistle", WhistleItem::new, 1);
    public static final RegistryObject<Item> TREAT_BAG = DoggyItems.registerWith("treat_bag", TreatBagItem::new, 1);
    public static final RegistryObject<Item> ENERGIZER_STICK = DoggyItems.register("energizer_stick", EnergizerStick::new);
    public static final RegistryObject<Item> EGG_SANDWICH = DoggyItems.register("egg_sandwich", EggSandwichItem::new);
    public static final RegistryObject<Item> BANDAID = DoggyItems.register("bandaid", BandaidItem::new);
    public static final RegistryObject<AccessoryItem> TANTAN_CAPE = DoggyItems.registerAccessory("tantan_cape", DoggyAccessories.TANTAN_CAPE);
    public static final RegistryObject<DyeableAccessoryItem> CAPE_COLOURED = DoggyItems.registerAccessoryDyed("cape_coloured", DoggyAccessories.DYEABLE_CAPE);
    public static final RegistryObject<AccessoryItem> SUNGLASSES = DoggyItems.registerAccessory("sunglasses", DoggyAccessories.SUNGLASSES);
    public static final RegistryObject<AccessoryItem> GUARD_SUIT = DoggyItems.registerAccessory("guard_suit", DoggyAccessories.GUARD_SUIT);
    public static final RegistryObject<AccessoryItem> PIANIST_SUIT = DoggyItems.registerAccessory("pianist_suit", DoggyAccessories.PIANIST_SUIT);
    public static final RegistryObject<AccessoryItem> CONAN_SUIT = DoggyItems.registerAccessory("conan_suit", DoggyAccessories.CONAN_SUIT);
    public static final RegistryObject<AccessoryItem> BEASTARS_UNIFORM_MALE = DoggyItems.registerAccessory("beastars_uniform_male", DoggyAccessories.BEASTARS_UNIFORM_MALE);
    public static final RegistryObject<AccessoryItem> BEASTARS_UNIFORM_FEMALE = DoggyItems.registerAccessory("beastars_uniform_female", DoggyAccessories.BEASTARS_UNIFORM_FEMALE);
    public static final RegistryObject<AccessoryItem> DEATH_HOOD = DoggyItems.registerAccessory("death_hood", DoggyAccessories.DEATH_HOOD);
    public static final RegistryObject<DyeableAccessoryItem> BOWTIE = DoggyItems.registerAccessoryDyed("bowtie", DoggyAccessories.BOWTIE);
    public static final RegistryObject<AccessoryItem> SMARTY_GLASSES = DoggyItems.registerAccessory("smarty_glasses", DoggyAccessories.SMARTY_GLASSES);
    public static final RegistryObject<DyeableAccessoryItem> WIG = DoggyItems.register("wig", () -> new Wig.WigItem((Supplier<? extends DyeableAccessory>)DoggyAccessories.WIG, DoggyItems.createInitialProp()));
    public static final RegistryObject<AccessoryItem> BACH_WIG = DoggyItems.registerAccessory("bach_wig", DoggyAccessories.BACH_WIG);
    public static final RegistryObject<AccessoryItem> LEATHER_JACKET = DoggyItems.registerAccessory("leather_jacket", DoggyAccessories.LEATHER_JACKET_CLOTHING);
    public static final RegistryObject<Item> SHRINKING_MALLET = DoggyItems.registerSizeBone("shrinking_mallet", DogResizeItem.Type.TINY);
    public static final RegistryObject<Item> MAGNIFYING_BONE = DoggyItems.registerSizeBone("magnifying_bone", DogResizeItem.Type.BIG);
    public static final RegistryObject<Item> AMNESIA_BONE = DoggyItems.registerWith("amnesia_bone", AmnesiaBoneItem::new, 1);
    public static final RegistryObject<DoggyArtifactItem> FEATHERED_MANTLE = DoggyItems.registerWith("feathered_mantle", props -> new DoggyArtifactItem(() -> new FeatheredMantleArtifact(), (Item.Properties)props), 1);
    public static final RegistryObject<Item> MUSIC_DISC_BWV_1080_FUGUE_11_KIMIKO = DoggyItems.register("disc_bwv_1080_fugue_11", () -> new RecordItem(13, () -> (SoundEvent)DoggySounds.BWV_1080_FUGUE_11_KIMIKO.get(), new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE), 5840));
    public static final RegistryObject<Item> MUSIC_DISC_BWV_849_FUGUE_KIMIKO = DoggyItems.register("disc_bwv_849_fugue", () -> new RecordItem(13, () -> (SoundEvent)DoggySounds.BWV_849_FUGUE_KIMIKO.get(), new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE), 3200));
    public static final RegistryObject<Item> MUSIC_DISC_OKAMI_1 = DoggyItems.register("disc_okami_ryoshima_coast_arr", () -> new RecordItem(13, () -> (SoundEvent)DoggySounds.OKAMI_RYOSHIMA_COAST_ARR.get(), new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE), 2220));

    private static Item.Properties createInitialProp() {
        return new Item.Properties();
    }

    private static RegistryObject<Item> registerThrowBone(String name) {
        return DoggyItems.register(name, () -> new ThrowableItem((Supplier<? extends Item>)THROW_BONE_WET, (Supplier<? extends Item>)((Supplier<Item>)() -> Items.f_42500_), DoggyItems.createInitialProp().m_41487_(2)));
    }

    private static RegistryObject<Item> registerThrowStick(String name) {
        return DoggyItems.register(name, () -> new ThrowableItem((Supplier<? extends Item>)THROW_STICK_WET, (Supplier<? extends Item>)THROW_STICK, DoggyItems.createInitialProp().m_41487_(8)));
    }

    private static RegistryObject<Item> registerThrowBoneWet(String name) {
        return DoggyItems.register(name, () -> new DroolBoneItem((Supplier<? extends Item>)THROW_BONE, DoggyItems.createInitialProp().m_41487_(1)));
    }

    private static RegistryObject<Item> registerThrowStickWet(String name) {
        return DoggyItems.register(name, () -> new DroolBoneItem((Supplier<? extends Item>)THROW_STICK, DoggyItems.createInitialProp().m_41487_(1)));
    }

    private static RegistryObject<Item> registerSizeBone(String name, DogResizeItem.Type typeIn) {
        return DoggyItems.register(name, () -> new DogResizeItem(typeIn, DoggyItems.createInitialProp().m_41487_(1).m_41503_(10)));
    }

    private static RegistryObject<Item> registerTreat(String name, DogLevel.Type typeIn, int maxLevel) {
        return DoggyItems.register(name, () -> new TreatItem(maxLevel, typeIn, DoggyItems.createInitialProp()));
    }

    private static RegistryObject<DyeableAccessoryItem> registerAccessoryDyed(String name, Supplier<? extends DyeableAccessory> type) {
        return DoggyItems.register(name, () -> new DyeableAccessoryItem(type, DoggyItems.createInitialProp()));
    }

    private static RegistryObject<AccessoryItem> registerAccessory(String name, Supplier<? extends Accessory> type) {
        return DoggyItems.register(name, () -> new AccessoryItem(type, DoggyItems.createInitialProp()));
    }

    private static <T extends Item> RegistryObject<T> registerWith(String name, Function<Item.Properties, T> itemConstructor, int maxStackSize) {
        return DoggyItems.register(name, () -> (Item)itemConstructor.apply(DoggyItems.createInitialProp().m_41487_(maxStackSize)));
    }

    private static <T extends Item> RegistryObject<T> registerWithFireResistant(String name, Function<Item.Properties, T> itemConstructor, int maxStackSize) {
        return DoggyItems.register(name, () -> (Item)itemConstructor.apply(DoggyItems.createInitialProp().m_41487_(maxStackSize).m_41486_()));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Function<Item.Properties, T> itemConstructor) {
        return DoggyItems.register(name, () -> (Item)itemConstructor.apply(DoggyItems.createInitialProp()));
    }

    private static RegistryObject<Item> register(String name) {
        return DoggyItems.registerWith(name, null);
    }

    private static RegistryObject<Item> registerWith(String name, @Nullable Function<Item.Properties, Item.Properties> extraPropFunc) {
        Item.Properties prop = DoggyItems.createInitialProp();
        return DoggyItems.register(name, () -> new Item(extraPropFunc != null ? (Item.Properties)extraPropFunc.apply(prop) : prop));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> sup) {
        return ITEMS.register(name, sup);
    }

    public static void registerItemColours(RegisterColorHandlersEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        Util.acceptOrElse(WOOL_COLLAR, item -> event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{item}), DoggyBlocks::logError);
        Util.acceptOrElse(CAPE_COLOURED, item -> event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{item}), DoggyBlocks::logError);
        Util.acceptOrElse(BOWTIE, item -> event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{item}), DoggyBlocks::logError);
        Util.acceptOrElse(WIG, item -> event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{item}), DoggyBlocks::logError);
        Util.acceptOrElse(DoggyBlocks.DOG_BATH, item -> itemColors.m_92689_((stack, tintIndex) -> 4159204, new ItemLike[]{item}), DoggyBlocks::logError);
    }
}

