/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.feature;

public class DogLevel {
    private int level;
    private int direLevel;

    public DogLevel(int level, int direLevel) {
        this.level = level;
        this.direLevel = direLevel;
    }

    public int getLevel(Type type) {
        return type == Type.DIRE ? this.direLevel : this.level;
    }

    public boolean canIncrease(Type type) {
        return type == Type.DIRE ? this.level >= 60 : true;
    }

    @Deprecated
    public void setLevel(Type type, int level) {
        if (type == Type.DIRE) {
            this.direLevel = level;
        } else {
            this.level = level;
        }
    }

    @Deprecated
    public void incrementLevel(Type type) {
        this.setLevel(type, this.getLevel(type) + 1);
    }

    public float getMaxHealth() {
        int hearts = 10 + (int)Math.ceil(0.16666667f * (float)this.level + 0.33333334f * (float)this.direLevel);
        return 2 * hearts;
    }

    public DogLevel copy() {
        return new DogLevel(this.level, this.direLevel);
    }

    public DogLevel combine(DogLevel levelIn) {
        int combinedLevel = this.getLevel(Type.NORMAL) + levelIn.getLevel(Type.NORMAL);
        combinedLevel /= 2;
        combinedLevel = Math.min(combinedLevel, 20);
        return new DogLevel(combinedLevel, 0);
    }

    public final boolean isDireDog() {
        return this.direLevel >= 30;
    }

    public static enum Type {
        NORMAL("normal_treat"),
        DIRE("dire_treat");

        String n;

        private Type(String n2) {
            this.n = n2;
        }

        public String getName() {
            return this.n;
        }
    }
}

