/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryType;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AccessoryInstance {
    public static final byte RENDER_TOP = 1;
    public static final byte RENDER_BOTTOM = -1;
    public static final byte RENDER_DEFAULT = 0;
    public static final Comparator<AccessoryInstance> RENDER_SORTER = Comparator.comparing(AccessoryInstance::getRenderIndex);
    @Deprecated
    private final Accessory accessory;

    public AccessoryInstance(Accessory typeIn) {
        this.accessory = typeIn;
    }

    public Accessory getAccessory() {
        return this.accessory;
    }

    public <T extends Accessory> boolean of(Supplier<T> accessoryIn) {
        return this.accessory.of(accessoryIn);
    }

    public <T extends Accessory> boolean of(T accessoryIn) {
        return this.accessory.of(accessoryIn);
    }

    public <T extends AccessoryType> boolean ofType(Supplier<T> accessoryTypeIn) {
        return this.ofType((AccessoryType)accessoryTypeIn.get());
    }

    public <T extends AccessoryType> boolean ofType(T accessoryTypeIn) {
        return accessoryTypeIn == this.accessory.getType();
    }

    public AccessoryInstance copy() {
        return new AccessoryInstance(this.accessory);
    }

    public ItemStack getReturnItem() {
        return this.getAccessory().getReturnItem(this);
    }

    public byte getRenderIndex() {
        return this.getAccessory().getRenderLayer();
    }

    public final void writeInstance(CompoundTag compound) {
        ResourceLocation rl = DoggyTalentsAPI.ACCESSORIES.get().getKey((Object)this.getAccessory());
        if (rl != null) {
            compound.m_128359_("type", rl.toString());
        }
        this.getAccessory().write(this, compound);
    }

    public static Optional<AccessoryInstance> readInstance(CompoundTag compound) {
        ResourceLocation rl = null;
        try {
            rl = ResourceLocation.m_135820_((String)compound.m_128461_("type"));
            if (DoggyTalentsAPI.ACCESSORIES.get().containsKey(rl)) {
                Accessory type = (Accessory)DoggyTalentsAPI.ACCESSORIES.get().getValue(rl);
                return Optional.of(type.read(compound));
            }
            DoggyTalentsAPI.LOGGER.warn("Failed to load accessory {}", (Object)compound);
        }
        catch (Exception e) {
            DoggyTalentsAPI.LOGGER.warn("Failed to load accessory {}", (Object)rl);
        }
        return Optional.empty();
    }

    public <T extends AccessoryInstance> T cast(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new RuntimeException("Could not cast " + this.getClass().getName() + " to " + type.getName());
    }

    public ResourceLocation getModelTexture(AbstractDog dog) {
        return this.getAccessory().getModelTexture();
    }
}

