/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Talent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TalentInstance
implements IDogAlteration {
    protected final Talent talent;
    protected int level;

    public TalentInstance(Talent talentIn) {
        this(talentIn, 1);
    }

    public TalentInstance(Talent talentIn, int levelIn) {
        this.talent = talentIn;
        this.level = levelIn;
    }

    public Talent getTalent() {
        return this.talent;
    }

    public final int level() {
        return this.level;
    }

    public final void setLevel(int levelIn) {
        this.level = levelIn;
    }

    public boolean of(Supplier<Talent> talentIn) {
        return this.of(talentIn.get());
    }

    public boolean of(Talent talentIn) {
        return talentIn == this.talent;
    }

    public TalentInstance copy() {
        return this.talent.getDefault(this.level);
    }

    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        compound.m_128405_("level", this.level());
    }

    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        this.setLevel(compound.m_128451_("level"));
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        buf.writeInt(this.level());
    }

    public void readFromBuf(FriendlyByteBuf buf) {
        this.setLevel(buf.readInt());
    }

    public final void writeInstance(AbstractDog dogIn, CompoundTag compound) {
        ResourceLocation rl = DoggyTalentsAPI.TALENTS.get().getKey((Object)this.talent);
        if (rl != null) {
            compound.m_128359_("type", rl.toString());
        }
        this.writeToNBT(dogIn, compound);
    }

    public static Optional<TalentInstance> readInstance(AbstractDog dogIn, CompoundTag compound) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)compound.m_128461_("type"));
        if (DoggyTalentsAPI.TALENTS.get().containsKey(rl)) {
            TalentInstance inst = ((Talent)DoggyTalentsAPI.TALENTS.get().getValue(rl)).getDefault();
            inst.readFromNBT(dogIn, compound);
            return Optional.of(inst);
        }
        DoggyTalentsAPI.LOGGER.warn("Failed to load talent {}", (Object)rl);
        return Optional.empty();
    }

    public <T extends TalentInstance> T cast(Class<T> type) {
        if (this.getClass().isAssignableFrom(type)) {
            return (T)this;
        }
        throw new RuntimeException("Could not cast " + this.getClass().getName() + " to " + type.getName());
    }

    public String toString() {
        return String.format("%s [talent: %s, level: %d]", this.getClass().getSimpleName(), DoggyTalentsAPI.TALENTS.get().getKey((Object)this.talent), this.level);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    public void set(AbstractDog dog, int levelBefore) {
    }

    public boolean hasRenderer() {
        return this.getTalent().hasRenderer();
    }
}

