/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import doggytalents.DoggyTalentsNext;
import doggytalents.client.CachedFileTexture;
import doggytalents.client.SkinRequest;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.texture.DogTextureServer;
import doggytalents.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DogTextureManager
extends SimplePreparableReloadListener<Preparations> {
    public static final DogTextureManager INSTANCE = new DogTextureManager();
    private static final Gson GSON = new Gson();
    private static final ResourceLocation OVERRIDE_RESOURCE_LOCATION = Util.getResource("textures/entity/dog/custom/overrides.json");
    private final Map<String, SkinRequest> hashToSkinRequest = Maps.newConcurrentMap();
    protected final Map<String, DogSkin> skinHashToLoc = Maps.newHashMap();
    protected final Map<DogSkin, String> locToSkinHash = Maps.newHashMap();
    protected final List<DogSkin> customSkinLoc = new ArrayList<DogSkin>(20);

    public SkinRequest getRequestStatus(String hash) {
        return this.hashToSkinRequest.getOrDefault(hash, SkinRequest.UNREQUESTED);
    }

    public void setRequestHandled(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.RECEIVED);
    }

    public void setRequestFailed(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.FAILED);
    }

    public void setRequested(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.REQUESTED);
    }

    public List<DogSkin> getAll() {
        return Collections.unmodifiableList(this.customSkinLoc);
    }

    public DogSkin getLocFromHashOrGet(String hash, Function<? super String, DogSkin> mappingFunction) {
        return this.skinHashToLoc.computeIfAbsent(hash, mappingFunction);
    }

    public String getTextureHash(DogSkin loc) {
        return this.locToSkinHash.getOrDefault(loc, "MISSING_MAPPING");
    }

    public DogSkin getSkinFromHash(String loc) {
        return this.skinHashToLoc.getOrDefault(loc, DogSkin.MISSING);
    }

    public File getClientFolder() {
        Minecraft mc = Minecraft.m_91087_();
        SkinManager skinManager = mc.m_91109_();
        return new File(skinManager.f_118808_.getParentFile(), "skins_dog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getResourceBytes(ResourceLocation loc) throws IOException {
        InputStream stream = null;
        try {
            stream = this.getResourceStream(loc);
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Nullable
    public InputStream getResourceStream(ResourceLocation loc) throws IOException {
        Minecraft mc = Minecraft.m_91087_();
        ResourceManager resourceManager = mc.m_91098_();
        Resource resource = (Resource)resourceManager.m_213713_(loc).get();
        return resource.m_215507_();
    }

    public ResourceLocation getTexture(Dog dog) {
        DogSkin skin = dog.getClientSkin();
        return skin.getPath();
    }

    public AbstractTexture getOrLoadTexture(File baseFolder, String hash) {
        Minecraft mc = Minecraft.m_91087_();
        TextureManager textureManager = mc.m_91097_();
        File cacheFile = DogTextureServer.INSTANCE.getCacheFile(baseFolder, hash);
        ResourceLocation loc = DogTextureServer.INSTANCE.getResourceLocation(hash);
        Object texture = textureManager.m_118506_(loc);
        if (texture == null && cacheFile.isFile() && cacheFile.exists()) {
            texture = new CachedFileTexture(loc, cacheFile);
            textureManager.m_118495_(loc, texture);
        }
        return texture;
    }

    public String saveTextureAndLoad(File baseFolder, byte[] data) throws IOException {
        Minecraft mc = Minecraft.m_91087_();
        TextureManager textureManager = mc.m_91097_();
        String hash = DogTextureServer.INSTANCE.getHash(data);
        File cacheFile = DogTextureServer.INSTANCE.getCacheFile(baseFolder, hash);
        ResourceLocation loc = DogTextureServer.INSTANCE.getResourceLocation(hash);
        AbstractTexture texture = textureManager.m_118506_(loc);
        if (texture == null) {
            DoggyTalentsNext.LOGGER.debug("Saved dog texture to local cache ({})", (Object)cacheFile);
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])data);
            DoggyTalentsNext.LOGGER.debug("Texture not current loaded trying to load");
            textureManager.m_118495_(loc, (AbstractTexture)new CachedFileTexture(loc, cacheFile));
        }
        return hash;
    }

    public DogSkin getCached(String hash) {
        return DogSkin.CLASSICAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadDogSkinResource(Preparations prep, Resource resource, ResourceLocation rl) {
        InputStream inputstream = null;
        try {
            inputstream = resource.m_215507_();
            String hash = DogTextureServer.INSTANCE.getHash(IOUtils.toByteArray((InputStream)inputstream));
            if (prep.skinHashToLoc.containsKey(hash)) {
                DoggyTalentsNext.LOGGER.warn("The loaded resource packs contained a duplicate custom dog skin ({} & {})", (Object)rl, (Object)this.skinHashToLoc.get(hash));
            } else {
                DoggyTalentsNext.LOGGER.info("Found custom dog skin at {} with hash {}", (Object)rl, (Object)hash);
                DogSkin dogSkin = new DogSkin(rl);
                prep.skinHashToLoc.put(hash, dogSkin);
                prep.locToSkinHash.put(dogSkin, hash);
                prep.customSkinLoc.add(dogSkin);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadDogSkinResourceWithMetadata(Preparations prep, Resource resource, DogSkin dogSkin) {
        InputStream inputstream = null;
        try {
            inputstream = resource.m_215507_();
            String hash = DogTextureServer.INSTANCE.getHash(IOUtils.toByteArray((InputStream)inputstream));
            if (prep.skinHashToLoc.containsKey(hash)) {
                DoggyTalentsNext.LOGGER.warn("The loaded resource packs contained a duplicate custom dog skin ({} & {})", (Object)dogSkin, (Object)this.skinHashToLoc.get(hash));
            } else {
                DoggyTalentsNext.LOGGER.info("Found custom dog skin at {} with hash {}", (Object)dogSkin, (Object)hash);
                prep.skinHashToLoc.put(hash, dogSkin);
                prep.locToSkinHash.put(dogSkin, hash);
                prep.customSkinLoc.add(dogSkin);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOverrideData(Preparations prep, List<Resource> resourcesList) {
        for (Resource iresource : resourcesList) {
            try {
                InputStream inputstream = iresource.m_215507_();
                DoggyTalentsNext.LOGGER.debug("Loading {}", (Object)iresource);
                try {
                    this.loadLocaleData(prep, inputstream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputstream);
                }
            }
            catch (Exception exception) {}
        }
    }

    private synchronized void loadLocaleData(Preparations prep, InputStream inputStreamIn) {
        JsonElement jsonelement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(inputStreamIn, StandardCharsets.UTF_8), JsonElement.class);
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonelement, (String)"strings");
        for (Map.Entry entry : jsonobject.entrySet()) {
            ResourceLocation texture;
            String hash = (String)entry.getKey();
            DogSkin previous = prep.skinHashToLoc.put(hash, new DogSkin(texture = new ResourceLocation(GsonHelper.m_13805_((JsonElement)((JsonElement)entry.getValue()), (String)hash))));
            if (previous != null) {
                // empty if block
            }
            DoggyTalentsNext.LOGGER.info("Loaded override for {} -> {}", (Object)hash, (Object)texture);
        }
    }

    protected Preparations prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Preparations prep = new Preparations();
        profiler.m_7242_();
        DogModelRegistry.init();
        if (this.getSkinFromSkinJsonAllPack(resourceManager, prep)) {
            profiler.m_7238_();
            profiler.m_7241_();
            return prep;
        }
        DoggyTalentsNext.LOGGER.warn("Could not parse or get resource from skin.json. Will be searching at textures/entity/dog/custom instead.");
        prep.skinHashToLoc.clear();
        prep.locToSkinHash.clear();
        prep.customSkinLoc.clear();
        Map resources = resourceManager.m_214159_("textures/entity/dog/custom", fileName -> true);
        for (Map.Entry i : resources.entrySet()) {
            try {
                Resource resource = (Resource)resourceManager.m_213713_((ResourceLocation)i.getKey()).get();
                if (resource == null) {
                    DoggyTalentsNext.LOGGER.warn("Could not get resource");
                    continue;
                }
                this.loadDogSkinResource(prep, (Resource)i.getValue(), (ResourceLocation)i.getKey());
            }
            catch (Exception exception) {
                DoggyTalentsNext.LOGGER.warn("Skipped custom dog skin file: {} ({})", i.getKey(), (Object)exception);
            }
        }
        try {
            ArrayList<Resource> override = new ArrayList<Resource>(resourceManager.m_214159_(OVERRIDE_RESOURCE_LOCATION.m_135815_(), x -> true).values());
            this.loadOverrideData(prep, override);
        }
        catch (RuntimeException runtimeexception) {
            DoggyTalentsNext.LOGGER.warn("Unable to parse dog skin override data: {}", (Throwable)runtimeexception);
        }
        profiler.m_7238_();
        profiler.m_7241_();
        return prep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getSkinFromSkinJsonAllPack(ResourceManager resMan, Preparations prep) {
        ResourceLocation SKIN_JSON_RES = Util.getResource("textures/entity/dog/skin.json");
        List jsonSkinPacks = resMan.m_7536_().collect(Collectors.toList());
        for (PackResources jsonSkinPack : jsonSkinPacks) {
            InputStream istream = null;
            try {
                IoSupplier packRes = jsonSkinPack.m_214146_(PackType.CLIENT_RESOURCES, SKIN_JSON_RES);
                if (packRes == null) continue;
                istream = (InputStream)packRes.m_247737_();
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8), JsonElement.class);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                this.getSkinFromSkinJson(resMan, prep, jsonObject);
                IOUtils.closeQuietly((InputStream)istream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(istream);
            }
        }
        prep.customSkinLoc.add(0, DogSkin.CLASSICAL);
        return true;
    }

    public void getSkinFromSkinJson(ResourceManager resMan, Preparations prep, JsonObject jsonObject) {
        JsonArray skinEntries = jsonObject.get("dog_skins").getAsJsonArray();
        for (JsonElement skinEntry : skinEntries) {
            DogSkin skin;
            JsonObject skinObject = skinEntry.getAsJsonObject();
            String name = skinObject.get("skin_name").getAsString();
            String id = skinObject.get("skin_id").getAsString();
            String use_model = skinObject.get("use_model").getAsString();
            ResourceLocation text_rl = Util.getResource("textures/entity/dog/custom/" + id + ".png");
            if (use_model == null || use_model.equals("default") || use_model.equals("")) {
                JsonElement earOptional;
                skin = new DogSkin(text_rl).setName(name);
                JsonElement tailOptional = skinObject.get("tail_id");
                if (tailOptional != null) {
                    skin.setTail(tailOptional.getAsByte());
                }
                if ((earOptional = skinObject.get("ear_id")) != null) {
                    skin.setEar(earOptional.getAsByte());
                }
            } else {
                DogModelRegistry.DogModelHolder dogModel = DogModelRegistry.getDogModelHolder(use_model);
                skin = dogModel == null ? new DogSkin(text_rl).setName(name) : new DogSkin(text_rl, dogModel).setName(name);
            }
            this.readSkinExtraInfo(skin, skinObject);
            Optional res = resMan.m_213713_(text_rl);
            if (!res.isPresent()) continue;
            this.loadDogSkinResourceWithMetadata(prep, (Resource)res.get(), skin);
        }
    }

    private void readSkinExtraInfo(DogSkin skin, JsonObject skinJsonObject) {
        JsonElement based_on;
        JsonElement author = skinJsonObject.get("author");
        if (author != null) {
            skin.setAuthor(author.getAsString());
        }
        if ((based_on = skinJsonObject.get("based_on")) != null) {
            skin.setBasedOn(based_on.getAsString());
        }
    }

    protected void apply(Preparations prep, ResourceManager resourceManager, ProfilerFiller profiler) {
        prep.apply(this);
    }

    public String m_7812_() {
        return "DogTextureManager";
    }

    protected static class Preparations {
        private final Map<String, DogSkin> skinHashToLoc = new HashMap<String, DogSkin>();
        private final Map<DogSkin, String> locToSkinHash = new HashMap<DogSkin, String>();
        private final List<DogSkin> customSkinLoc = new ArrayList<DogSkin>(20);

        protected Preparations() {
        }

        public void apply(DogTextureManager dogTextureManager) {
            dogTextureManager.skinHashToLoc.clear();
            dogTextureManager.customSkinLoc.clear();
            dogTextureManager.skinHashToLoc.putAll(this.skinHashToLoc);
            dogTextureManager.locToSkinHash.putAll(this.locToSkinHash);
            dogTextureManager.customSkinLoc.addAll(this.customSkinLoc);
        }
    }
}

