/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.google.common.collect.Maps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.dog.AmaterasuModel;
import doggytalents.client.entity.model.dog.DeathModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.IwankoModel;
import doggytalents.client.entity.model.dog.JackModel;
import doggytalents.client.entity.model.dog.JunoModel;
import doggytalents.client.entity.model.dog.LegoshiModel;
import doggytalents.client.entity.model.dog.LucarioModel;
import doggytalents.client.entity.model.dog.StBernardModel;
import doggytalents.client.entity.model.dog.kusa.ChiModel;
import doggytalents.client.entity.model.dog.kusa.HayabusaModel;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class DogModelRegistry {
    private static Map<String, DogModelHolder<? extends AbstractDog>> MODEL_MAP;

    public static <T extends AbstractDog> void register(String name, Function<EntityRendererProvider.Context, DogModel<T>> getter) {
        MODEL_MAP.putIfAbsent(name, new DogModelHolder<T>(getter));
    }

    public static DogModelHolder getDogModelHolder(String name) {
        return MODEL_MAP.get(name);
    }

    public static void resolve(EntityRendererProvider.Context ctx) {
        for (Map.Entry<String, DogModelHolder<? extends AbstractDog>> holder : MODEL_MAP.entrySet()) {
            holder.getValue().resolve(ctx);
        }
    }

    public static void init() {
        MODEL_MAP = Maps.newConcurrentMap();
        DogModelRegistry.register("default", ctx -> new DogModel(ctx.m_174023_(ClientSetup.DOG)));
        DogModelRegistry.register("iwanko", ctx -> new IwankoModel(ctx.m_174023_(ClientSetup.DOG_IWANKO)));
        DogModelRegistry.register("lucario", ctx -> new LucarioModel(ctx.m_174023_(ClientSetup.DOG_LUCARIO)));
        DogModelRegistry.register("death", ctx -> new DeathModel(ctx.m_174023_(ClientSetup.DOG_DEATH)));
        DogModelRegistry.register("legoshi", ctx -> new LegoshiModel(ctx.m_174023_(ClientSetup.DOG_LEGOSHI)));
        DogModelRegistry.register("jack", ctx -> new JackModel(ctx.m_174023_(ClientSetup.DOG_JACK)));
        DogModelRegistry.register("juno", ctx -> new JunoModel(ctx.m_174023_(ClientSetup.DOG_JUNO)));
        DogModelRegistry.register("st_bernard", ctx -> new StBernardModel(ctx.m_174023_(ClientSetup.DOG_ST_BERNARD)));
        DogModelRegistry.register("okami_amaterasu", ctx -> new AmaterasuModel(ctx.m_174023_(ClientSetup.OKAMI_AMATERASU)));
        DogModelRegistry.register("kusa_hayabusa", ctx -> new HayabusaModel(ctx.m_174023_(ClientSetup.KUSA_HAYABUSA)));
        DogModelRegistry.register("kusa_chi", ctx -> new ChiModel(ctx.m_174023_(ClientSetup.KUSA_CHI)));
        DogModelRegistry.register("kusa_ko", ctx -> new ChiModel(ctx.m_174023_(ClientSetup.KUSA_KO)));
        DogModelRegistry.register("kusa_rei", ctx -> new ChiModel(ctx.m_174023_(ClientSetup.KUSA_REI)));
        DogModelRegistry.register("kusa_shin", ctx -> new ChiModel(ctx.m_174023_(ClientSetup.KUSA_SHIN)));
        DogModelRegistry.register("kusa_take", ctx -> new ChiModel(ctx.m_174023_(ClientSetup.KUSA_TAKE)));
        DogModelRegistry.register("kusa_tei", ctx -> new ChiModel(ctx.m_174023_(ClientSetup.KUSA_TEI)));
        DogModelRegistry.register("kusa_ume", ctx -> new ChiModel(ctx.m_174023_(ClientSetup.KUSA_UME)));
    }

    public static class DogModelHolder<T extends AbstractDog> {
        private DogModel<T> value;
        private Function<EntityRendererProvider.Context, DogModel<T>> getter;

        public DogModelHolder(Function<EntityRendererProvider.Context, DogModel<T>> getter) {
            this.getter = getter;
        }

        public DogModel<T> getValue() {
            return this.value;
        }

        public void resolve(EntityRendererProvider.Context ctx) {
            this.value = this.getter.apply(ctx);
        }
    }
}

