/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.render.CollarRenderManager;
import doggytalents.client.entity.render.RenderUtil;
import doggytalents.client.entity.render.layer.BoneLayer;
import doggytalents.client.entity.render.layer.LayerFactory;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;

public class DogRenderer
extends MobRenderer<Dog, DogModel<Dog>> {
    private DogModel defaultModel;

    public DogRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.5f);
        DogModelRegistry.resolve(ctx);
        this.f_115290_ = DogModelRegistry.getDogModelHolder("default").getValue();
        this.defaultModel = (DogModel)this.f_115290_;
        this.m_115326_(new BoneLayer(this, ctx.m_234598_()));
        for (LayerFactory<Dog, DogModel<Dog>> layer : CollarRenderManager.getLayers()) {
            this.m_115326_(layer.createLayer((RenderLayerParent<Dog, DogModel<Dog>>)this, ctx));
        }
    }

    protected float getBob(Dog livingBase, float partialTicks) {
        return livingBase.getTailRotation();
    }

    public void render(Dog dog, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        DogSkin skin = dog.getClientSkin();
        this.f_115290_ = skin.useCustomModel() ? dog.getClientSkin().getCustomModel().getValue() : this.defaultModel;
        ((DogModel)this.f_115290_).realTail.f_104207_ = true;
        ((DogModel)this.f_115290_).realTail2.f_104207_ = false;
        ((DogModel)this.f_115290_).realTail3.f_104207_ = false;
        byte tailIndx = skin.getTail();
        if (tailIndx != 0) {
            switch (tailIndx) {
                case 1: {
                    ((DogModel)this.f_115290_).realTail.f_104207_ = false;
                    ((DogModel)this.f_115290_).realTail2.f_104207_ = true;
                    ((DogModel)this.f_115290_).realTail3.f_104207_ = false;
                    break;
                }
                case 2: {
                    ((DogModel)this.f_115290_).realTail.f_104207_ = false;
                    ((DogModel)this.f_115290_).realTail2.f_104207_ = false;
                    ((DogModel)this.f_115290_).realTail3.f_104207_ = true;
                }
            }
        }
        ((DogModel)this.f_115290_).earNormal.f_104207_ = true;
        ((DogModel)this.f_115290_).earBoni.f_104207_ = false;
        ((DogModel)this.f_115290_).earSmall.f_104207_ = false;
        byte earIndx = skin.getEar();
        if (earIndx != 0) {
            switch (earIndx) {
                case 1: {
                    ((DogModel)this.f_115290_).earNormal.f_104207_ = false;
                    ((DogModel)this.f_115290_).earBoni.f_104207_ = true;
                    ((DogModel)this.f_115290_).earSmall.f_104207_ = false;
                    break;
                }
                case 2: {
                    ((DogModel)this.f_115290_).earNormal.f_104207_ = false;
                    ((DogModel)this.f_115290_).earBoni.f_104207_ = false;
                    ((DogModel)this.f_115290_).earSmall.f_104207_ = true;
                }
            }
        }
        if (dog.isDogWet()) {
            float f = dog.getShadingWhileWet(partialTicks);
            ((DogModel)this.f_115290_).setColor(f, f, f);
        }
        super.m_7392_((Mob)dog, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (dog.isDogWet()) {
            ((DogModel)this.f_115290_).setColor(1.0f, 1.0f, 1.0f);
        }
        if (((DogModel)this.f_115290_).hasAdditonalRendering()) {
            ((DogModel)this.f_115290_).doAdditonalRendering(dog, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private Component getNameUnknown(Dog dogIn) {
        return Component.m_237115_((String)(dogIn.m_21805_() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed"));
    }

    public ResourceLocation getTextureLocation(Dog dogIn) {
        return DogTextureManager.INSTANCE.getTexture(dogIn);
    }

    protected void scale(Dog dogIn, PoseStack matrixStackIn, float partialTickTime) {
        float size = (float)dogIn.getDogSize() * 0.3f + 0.1f;
        matrixStackIn.m_85841_(size, size, size);
        this.f_114477_ = size * 0.5f;
    }

    protected void renderNameTag(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        boolean isDiffOwner;
        double d0 = this.f_114476_.m_114471_((Entity)dog);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean renderDiffOwnerName = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_DIFFOWNER_NAME_DIFFERENT) != false && dog != this.f_114476_.f_114359_;
        boolean bl = isDiffOwner = player == null || !player.m_20148_().equals(dog.m_21805_());
        if (ForgeHooksClient.isNameplateInRenderDistance((Entity)dog, (double)d0)) {
            this.renderMainName(dog, text, stack, buffer, packedLight, d0, renderDiffOwnerName && isDiffOwner);
        }
        if (d0 <= 4096.0) {
            this.renderExtraInfo(dog, text, stack, buffer, packedLight, d0, renderDiffOwnerName && isDiffOwner);
        }
    }

    private void renderMainName(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, double d0, boolean diffOwnerRender) {
        boolean flag = !dog.m_20163_();
        float f = dog.m_20206_() + 0.5f;
        boolean i = false;
        stack.m_85836_();
        stack.m_85837_(0.0, (double)f, 0.0);
        stack.m_252781_(this.f_114476_.m_253208_());
        stack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        if (diffOwnerRender) {
            f1 = 0.0f;
        }
        int j = (int)(f1 * 255.0f) << 24;
        Font font = this.m_114481_();
        float f2 = -font.m_92852_((FormattedText)text) / 2;
        text = this.modifyText(dog, text, diffOwnerRender);
        font.m_272077_(text, f2, (float)i, 0x20FFFFFF, false, matrix4f, buffer, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, packedLight);
        if (flag) {
            font.m_272077_(text, f2, (float)i, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        stack.m_85849_();
    }

    private void renderExtraInfo(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, double d0, boolean diffOwnerRender) {
        String tip = dog.getMode().getTip();
        int hunger = Mth.m_14167_((float)(dog.isDefeated() ? dog.getDogHunger() - (float)dog.getMaxIncapacitatedHunger() : dog.getDogHunger()));
        boolean flag1 = this.f_114476_.f_114358_.m_90592_().m_6144_() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        MutableComponent label = Component.m_237115_((String)tip);
        MutableComponent hunger_c1 = Component.m_237113_((String)("(" + hunger + ")"));
        if (dog.getDogHunger() <= 10.0f && flag1) {
            hunger_c1.m_130948_(Style.f_131099_.m_178520_(0xFF3636));
        }
        label.m_7220_((Component)hunger_c1);
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GENDER)).booleanValue()) {
            label.m_7220_((Component)Component.m_237115_((String)dog.getGender().getUnlocalisedTip()));
        }
        int TXTCLR_BKG = 1464486474;
        if (diffOwnerRender) {
            label = Component.m_237113_((String)label.getString()).m_130948_(Style.f_131099_.m_178520_(1464486474));
        }
        RenderUtil.renderLabelWithScale(dog, this, this.f_114476_, (Component)label, stack, buffer, packedLight, 0.01f, 0.12f, !diffOwnerRender);
        if (d0 <= 25.0 && this.f_114476_.f_114358_.m_90592_().m_6144_()) {
            Component ownerC0 = dog.getOwnersName().orElseGet(() -> this.getNameUnknown(dog));
            if (diffOwnerRender) {
                ownerC0 = Component.m_237113_((String)ownerC0.getString()).m_130948_(Style.f_131099_.m_178520_(1464486474));
            }
            RenderUtil.renderLabelWithScale(dog, this, this.f_114476_, ownerC0, stack, buffer, packedLight, 0.01f, -0.25f, !diffOwnerRender);
        }
    }

    private Component modifyText(Dog dog, Component text, boolean diffOwnerRender) {
        boolean flag1;
        int TXTCLR_HEALTH_70_100 = 720707;
        int TXTCLR_HEALTH_30_70 = 15727189;
        int TXTCLR_HEALTH_0_30 = 0xFF3636;
        int TXTCLR_BKG = 0x4A4A4A;
        if (diffOwnerRender) {
            text = Component.m_237113_((String)text.getString()).m_130948_(Style.f_131099_.m_178520_(0x4A4A4A));
            return text;
        }
        boolean bl = flag1 = this.f_114476_.f_114358_.m_90592_().m_6144_() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        if (flag1) {
            int noCharsInName = text.getString().length();
            float healthPercentage = dog.m_21223_() / dog.m_21233_();
            int noCharHighlighted = Mth.m_14167_((float)((float)noCharsInName * healthPercentage));
            String hlPart = text.getString().substring(0, noCharHighlighted);
            String nonHlPart = "";
            if (noCharHighlighted <= noCharsInName) {
                nonHlPart = text.getString().substring(noCharHighlighted, noCharsInName);
            }
            int color = 0xFF3636;
            if ((double)healthPercentage >= 0.7) {
                color = 720707;
            } else if ((double)healthPercentage >= 0.3) {
                color = 15727189;
            }
            MutableComponent newTxt = Component.m_237113_((String)hlPart).m_130948_(Style.f_131099_.m_178520_(color));
            MutableComponent restTxt = Component.m_237113_((String)nonHlPart).m_130948_(Style.f_131099_.m_178520_(0x4A4A4A));
            newTxt.m_7220_((Component)restTxt);
            text = newTxt;
        }
        return text;
    }
}

