/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.DoggyTalents;
import doggytalents.api.registry.Accessory;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogArmorModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.HelmetInteractHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class ArmorAccessoryRenderer
extends RenderLayer<Dog, DogModel<Dog>> {
    private DogArmorModel model;

    public ArmorAccessoryRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
        this.model = new DogArmorModel(ctx.m_174023_(ClientSetup.DOG_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemStack;
        if (!dog.m_21824_() || dog.m_20145_()) {
            return;
        }
        Optional inst = dog.getTalent((Supplier)DoggyTalents.DOGGY_ARMOR);
        if (!inst.isPresent()) {
            return;
        }
        ((DogModel)this.m_117386_()).m_102624_((EntityModel)this.model);
        this.model.prepareMobModel(dog, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.model.setVisible(false);
        if (dog.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ArmorItem) {
            itemStack = dog.m_6844_(EquipmentSlot.HEAD);
            this.model.head.f_104207_ = true;
            ArmorAccessoryRenderer.renderArmorCutout(this.model, ((Accessory)HelmetInteractHandler.getMappedResource(itemStack.m_41720_()).get()).getModelTexture(), poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, itemStack.m_41793_());
        }
        this.model.setVisible(false);
        if (dog.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem) {
            itemStack = dog.m_6844_(EquipmentSlot.CHEST);
            this.model.body.f_104207_ = true;
            this.model.mane.f_104207_ = true;
            this.model.tail.f_104207_ = true;
            ArmorAccessoryRenderer.renderArmorCutout(this.model, ((Accessory)HelmetInteractHandler.getMappedResource(itemStack.m_41720_()).get()).getModelTexture(), poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, itemStack.m_41793_());
        }
        this.model.setVisible(false);
        if (dog.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorItem) {
            itemStack = dog.m_6844_(EquipmentSlot.LEGS);
            this.model.leggingFrontLeft.f_104207_ = true;
            this.model.leggingFrontRight.f_104207_ = true;
            this.model.leggingHindLeft.f_104207_ = true;
            this.model.leggingHindRight.f_104207_ = true;
            ArmorAccessoryRenderer.renderArmorCutout(this.model, ((Accessory)HelmetInteractHandler.getMappedResource(itemStack.m_41720_()).get()).getModelTexture(), poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, itemStack.m_41793_());
        }
        this.model.setVisible(false);
        if (dog.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ArmorItem) {
            itemStack = dog.m_6844_(EquipmentSlot.FEET);
            this.model.bootFrontLeft.f_104207_ = true;
            this.model.bootFrontRight.f_104207_ = true;
            this.model.bootHindLeft.f_104207_ = true;
            this.model.bootHindRight.f_104207_ = true;
            ArmorAccessoryRenderer.renderArmorCutout(this.model, ((Accessory)HelmetInteractHandler.getMappedResource(itemStack.m_41720_()).get()).getModelTexture(), poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, itemStack.m_41793_());
        }
    }

    public void renderArmorPiece(PoseStack p_117119_, MultiBufferSource p_117120_, ItemStack p_117121_, EquipmentSlot p_117122_) {
    }

    public static <T extends LivingEntity> void renderArmorCutout(EntityModel<T> modelIn, ResourceLocation textureLocationIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entityIn, float red, float green, float blue, boolean enchanted) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110431_((ResourceLocation)textureLocationIn), (boolean)false, (boolean)enchanted);
        modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }
}

