/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.api.inferface.IColoredObject;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogFrontLegsSeperate;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DefaultAccessoryRenderer
extends RenderLayer<Dog, DogModel<Dog>> {
    private DogModel<Dog> defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
    private DogFrontLegsSeperate hindLegDiffTextModel;

    public DefaultAccessoryRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
        this.hindLegDiffTextModel = new DogFrontLegsSeperate(ctx.m_174023_(ClientSetup.DOG_FRONT_LEGS_SEPERATE));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!dog.m_21824_() || dog.m_20145_()) {
            return;
        }
        for (AccessoryInstance accessoryInst : dog.getClientSortedAccessories()) {
            Accessory accessory = accessoryInst.getAccessory();
            if (!this.isOverlay(accessory)) continue;
            if (accessory.hasHindLegDiffTex()) {
                this.renderHindLegDifferentAccessory(poseStack, buffer, packedLight, dog, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, accessoryInst);
                continue;
            }
            this.renderNormalAccessory(poseStack, buffer, packedLight, dog, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, accessoryInst);
        }
    }

    private void renderNormalAccessory(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, AccessoryInstance accessoryInst) {
        DogModel<Dog> parentModel = (DogModel<Dog>)this.m_117386_();
        DogModel<Dog> dogModel = parentModel.useDefaultModelForAccessories() ? this.defaultModel : parentModel;
        if (dogModel != parentModel) {
            ((DogModel)this.m_117386_()).m_102624_((EntityModel)dogModel);
            dogModel.prepareMobModel(dog, limbSwing, limbSwingAmount, partialTicks);
            dogModel.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        ResourceLocation texture_rl = accessoryInst.getModelTexture(dog);
        boolean isTranslucent = accessoryInst.getAccessory().renderTranslucent();
        if (texture_rl == null) {
            return;
        }
        boolean tailVisible0 = dogModel.tail.f_104207_;
        if (dog.getClientSkin().useCustomModel()) {
            dogModel.tail.f_104207_ = false;
        }
        if (accessoryInst instanceof IColoredObject) {
            IColoredObject coloredObject = (IColoredObject)((Object)accessoryInst);
            float[] color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                RenderLayer.m_117376_(dogModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (float)color[0], (float)color[1], (float)color[2]);
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderLayer.m_117376_(dogModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        dogModel.tail.f_104207_ = tailVisible0;
    }

    private void renderHindLegDifferentAccessory(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, AccessoryInstance accessoryInst) {
        float[] color;
        IColoredObject coloredObject;
        DogModel<Dog> parentModel = (DogModel<Dog>)this.m_117386_();
        DogModel<Dog> dogModel = parentModel.useDefaultModelForAccessories() ? this.defaultModel : parentModel;
        if (dogModel != parentModel) {
            ((DogModel)this.m_117386_()).m_102624_((EntityModel)dogModel);
            dogModel.prepareMobModel(dog, limbSwing, limbSwingAmount, partialTicks);
            dogModel.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        ResourceLocation texture_rl = accessoryInst.getModelTexture(dog);
        boolean isTranslucent = accessoryInst.getAccessory().renderTranslucent();
        if (texture_rl == null) {
            return;
        }
        boolean tailVisible0 = dogModel.tail.f_104207_;
        if (dog.getClientSkin().useCustomModel()) {
            dogModel.tail.f_104207_ = false;
        }
        boolean rightFrontLegVisible0 = dogModel.legFrontRight.f_104207_;
        boolean leftFrontLegVisible0 = dogModel.legFrontLeft.f_104207_;
        dogModel.legFrontLeft.f_104207_ = false;
        dogModel.legFrontRight.f_104207_ = false;
        if (accessoryInst instanceof IColoredObject) {
            coloredObject = (IColoredObject)((Object)accessoryInst);
            color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                RenderLayer.m_117376_(dogModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (float)color[0], (float)color[1], (float)color[2]);
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderLayer.m_117376_(dogModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        dogModel.tail.f_104207_ = tailVisible0;
        dogModel.legFrontRight.f_104207_ = rightFrontLegVisible0;
        dogModel.legFrontLeft.f_104207_ = leftFrontLegVisible0;
        this.hindLegDiffTextModel.syncFromDogModel(dogModel);
        if (accessoryInst instanceof IColoredObject) {
            coloredObject = (IColoredObject)((Object)accessoryInst);
            color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(this.hindLegDiffTextModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                RenderLayer.m_117376_((EntityModel)this.hindLegDiffTextModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (float)color[0], (float)color[1], (float)color[2]);
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(this.hindLegDiffTextModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderLayer.m_117376_((EntityModel)this.hindLegDiffTextModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean isOverlay(Accessory accessory) {
        Accessory.AccessoryRenderType type = accessory.getAccessoryRenderType();
        return type == Accessory.AccessoryRenderType.OVERLAY || type == Accessory.AccessoryRenderType.OVERLAY_AND_MODEL;
    }

    public static <T extends LivingEntity> void renderTranslucentModel(EntityModel<T> p_117377_, ResourceLocation p_117378_, PoseStack p_117379_, MultiBufferSource p_117380_, int p_117381_, T p_117382_, float p_117383_, float p_117384_, float p_117385_, float opascity) {
        VertexConsumer vertexconsumer = p_117380_.m_6299_(RenderType.m_110473_((ResourceLocation)p_117378_));
        p_117377_.m_7695_(p_117379_, vertexconsumer, p_117381_, LivingEntityRenderer.m_115338_(p_117382_, (float)0.0f), p_117383_, p_117384_, p_117385_, opascity);
    }
}

