/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.element.view.TalentView;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.api.registry.Talent;
import doggytalents.client.screen.AmnesiaBoneScreen.store.slice.ActiveTalentDescSlice;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogDeTrainData;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.network.PacketDistributor;

public class TalentInfoViewElement
extends AbstractElement {
    Dog dog;
    Talent talent;
    Font font;
    static final int PADDING_LEFT = 5;
    static final int PADDING_RIGHT = 30;
    static final int PADDING_TOP = 5;
    static final int LINE_SPACING = 3;

    public TalentInfoViewElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = this.getScreen().getMinecraft();
        this.font = mc.f_91062_;
    }

    @Override
    public AbstractElement init() {
        Talent talent;
        this.talent = talent = Store.get((Screen)this.getScreen()).getStateOrDefault(ActiveTalentDescSlice.class, ActiveTalentDescSlice.class, new ActiveTalentDescSlice(null)).activeTalent;
        if (this.talent == null) {
            return this;
        }
        this.addDetrainButton(this.dog);
        return this;
    }

    private void addDetrainButton(final Dog dog) {
        final int dogLevel = dog.getDogLevel(this.talent);
        var trainButton = new CustomButton(0, 0, 50, 20, (Component)Component.m_237115_((String)"doggui.detrain.talents.detrain"), b -> this.requestDeTrain()){

            public void m_87963_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                int costStrColor;
                Object costStr;
                super.m_87963_(stack, mouseX, mouseY, pTicks);
                int tX = this.m_252754_();
                int n = this.m_252907_() - 3;
                Objects.requireNonNull(TalentInfoViewElement.this.font);
                int tY = n - 9;
                int dogLevel2 = dog.getDogLevel(TalentInfoViewElement.this.talent);
                if (dogLevel2 <= 0) {
                    costStr = I18n.m_118938_((String)"doggui.detrain.talents.no_level", (Object[])new Object[0]);
                    costStrColor = -721152;
                } else {
                    costStr = I18n.m_118938_((String)"doggui.talents.cost", (Object[])new Object[0]) + TalentInfoViewElement.this.talent.getDeTrainXPCost(dogLevel2);
                    costStrColor = -1;
                }
                TalentInfoViewElement.this.font.m_92883_(stack, (String)costStr, (float)tX, (float)tY, costStrColor);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                this.f_93623_ = dogLevel2 > 0 && player != null && player.f_36078_ >= TalentInfoViewElement.this.talent.getDeTrainXPCost(dogLevel2);
            }

            public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                super.m_86412_(stack, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (this.f_93623_) {
                    return;
                }
                if (player != null && player.f_36078_ >= TalentInfoViewElement.this.talent.getDeTrainXPCost(dogLevel)) {
                    return;
                }
                MutableComponent c1 = Component.m_237115_((String)"doggui.detrain.talents.insufficent_xp");
                c1.m_6270_(Style.f_131099_.m_178520_(-5111808).m_131136_(Boolean.valueOf(true)));
                TalentInfoViewElement.this.getScreen().m_96597_(stack, List.of(c1), mouseX, mouseY);
            }
        };
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        trainButton.f_93623_ = dogLevel > 0 && player != null && player.f_36078_ >= this.talent.getDeTrainXPCost(dogLevel);
        int trainButtonX = this.getRealX() + this.getSizeX() - trainButton.m_5711_() - 35;
        int trainButtonY = this.getRealY() + this.getSizeY() - trainButton.m_93694_() - 20;
        trainButton.m_252865_(trainButtonX);
        trainButton.m_253211_(trainButtonY);
        this.addChildren((GuiEventListener)trainButton);
    }

    private void requestDeTrain() {
        int level = this.dog.getDogLevel(this.talent);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        int xp = player.f_36078_;
        if (level > 0 && xp >= this.talent.getDeTrainXPCost(level)) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogDeTrainData(this.dog.m_19879_(), this.talent));
        }
    }

    @Override
    public void renderElement(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.talent == null) {
            int mX = this.getSizeX() / 2;
            int mY = this.getSizeY() / 2;
            String txt = I18n.m_118938_((String)"doggui.talents.no_talents_selected", (Object[])new Object[0]);
            int tX = this.getRealX() + mX - this.font.m_92895_(txt) / 2;
            int n = this.getRealY() + mY;
            Objects.requireNonNull(this.font);
            int tY = n - 9 / 2;
            this.font.m_92883_(stack, txt, (float)tX, (float)tY, -1);
            return;
        }
        int startX = this.getRealX() + 5;
        int startY = this.getRealY() + 5;
        int pX = startX;
        int pY = startY;
        MutableComponent title = Component.m_237115_((String)this.talent.getTranslationKey()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(-721152));
        this.font.m_92889_(stack, (Component)title, (float)pX, (float)pY, -1);
        Objects.requireNonNull(this.font);
        pY += 6 + 9;
        MutableComponent desc = Component.m_237115_((String)this.talent.getInfoTranslationKey());
        List desc_lines = this.font.m_92923_((FormattedText)desc, this.getSizeX() - 35);
        for (FormattedCharSequence line : desc_lines) {
            this.font.m_92877_(stack, line, (float)pX, (float)pY, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + 3;
        }
        startX = this.getRealX() + 5;
        pY = this.getRealY() + this.getSizeY() - 45;
        String currentLevelStr = I18n.m_118938_((String)"doggui.pointsleft", (Object[])new Object[0]);
        String currentLevelStr1 = "" + this.dog.getSpendablePoints();
        this.font.m_92883_(stack, currentLevelStr, (float)startX, (float)pY, -1);
        Objects.requireNonNull(this.font);
        this.font.m_92883_(stack, currentLevelStr1, (float)startX, (float)(pY += 9 + 3), -1);
        startX = this.getRealX() + 80;
        pY = this.getRealY() + this.getSizeY() - 45;
        currentLevelStr = I18n.m_118938_((String)"doggui.talents.current_talent_level", (Object[])new Object[0]);
        currentLevelStr1 = this.dog.getDogLevel(this.talent) + "/" + this.talent.getMaxLevel();
        this.font.m_92883_(stack, currentLevelStr, (float)startX, (float)pY, -1);
        Objects.requireNonNull(this.font);
        this.font.m_92883_(stack, currentLevelStr1, (float)startX, (float)(pY += 9 + 3), -1);
    }
}

