/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Triple;

public class CanineTrackerScreen
extends Screen {
    private Rect2i rect;
    private Player player;
    private final ArrayList<String> dogNameList;
    private final ArrayList<UUID> dogIdList;
    private final ArrayList<String> dogNameFilterList;
    private final ArrayList<UUID> dogIdFilterList;
    private int hightlightDogName;
    private boolean showUuid = false;
    private String value = "";
    private final int HLC_HEEL_NO_SIT = 16716025;
    private Map<UUID, Integer> dogDistanceMap = Maps.newConcurrentMap();
    private Map<UUID, BlockPos> dogPosMap = Maps.newConcurrentMap();
    private int hightlightTextColor = 16716025;
    private final int MAX_BUFFER_SIZE = 64;
    private int mouseX0;
    private int mouseY0;

    public CanineTrackerScreen(Player player) {
        super((Component)Component.m_237115_((String)"doggytalents.screen.conducting_bone"));
        this.player = player;
        this.dogNameList = new ArrayList(4);
        this.dogIdList = new ArrayList(4);
        this.dogIdFilterList = new ArrayList(4);
        this.dogNameFilterList = new ArrayList(4);
        this.hightlightDogName = 0;
    }

    public static void open() {
        Minecraft mc = Minecraft.m_91087_();
        CanineTrackerScreen screen = new CanineTrackerScreen((Player)mc.f_91074_);
        mc.m_91152_((Screen)screen);
        screen.requestDogs();
    }

    public void m_7856_() {
        super.m_7856_();
        this.rect = new Rect2i(0, 0, 500, 500);
        CustomButton showUuid = new CustomButton(3, 3, 60, 20, (Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.m_93666_((Component)Component.m_237115_((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        CustomButton help = new CustomButton(3, 26, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                super.m_86412_(stack, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.radar.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.radar.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, CanineTrackerScreen.this.f_96547_));
                CanineTrackerScreen.this.m_96597_(stack, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)showUuid);
        this.m_142416_((GuiEventListener)help);
    }

    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.mouseX0 != mouseX || this.mouseY0 != mouseY) {
            this.onMouseMoved(mouseX, mouseY);
            this.mouseX0 = mouseX;
            this.mouseY0 = mouseY;
        }
        int half_width = this.f_96543_ >> 1;
        int half_height = this.f_96544_ >> 1;
        Gui.m_93172_((PoseStack)stack, (int)(half_width - 100), (int)(half_height - 100), (int)(half_width + 100), (int)(half_height + 100), (int)Integer.MIN_VALUE);
        Gui.m_93172_((PoseStack)stack, (int)(half_width - 100), (int)(half_height + 105), (int)(half_width + 100), (int)(half_height + 117), (int)Integer.MIN_VALUE);
        super.m_86412_(stack, mouseX, mouseY, partialTicks);
        int offset = 0;
        int textx = half_width - 100 + 2;
        int texty = half_height - 100 + 2;
        int textx1 = half_width + 100 - 35;
        int texty1 = half_height - 100 + 2;
        if (this.dogNameFilterList.size() <= 0) {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggytalents.screen.conducting_bone.no_dog_found", (Object[])new Object[0]), (float)textx, (float)(texty + offset), 16058890);
        }
        for (int i = 0; i < this.dogNameFilterList.size(); ++i) {
            int color = -1;
            if (i == this.hightlightDogName) {
                color = this.hightlightTextColor;
            }
            UUID id = this.dogIdFilterList.get(i);
            String text = this.dogNameFilterList.get(i) + (String)(this.showUuid ? " ( " + id + " ) " : "");
            this.f_96547_.m_92883_(stack, text, (float)textx, (float)(texty + offset), color);
            int dist = this.dogDistanceMap.get(id);
            String text1 = this.showUuid ? "" : (dist > 99999 ? "far" : "" + dist);
            this.f_96547_.m_92883_(stack, text1, (float)textx1, (float)(texty1 + offset), color);
            if ((offset += 10) > 190) break;
        }
        int txtorgx = half_width - 90;
        int txtorgy = half_height + 107;
        this.f_96547_.m_92883_(stack, this.value + "_", (float)txtorgx, (float)txtorgy, -1);
    }

    private int getHoveredIndex(double x, double y, int entry_size) {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return -1;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return -1;
        }
        int baseY = mY - 100;
        int indx = Mth.m_14107_((double)(y - (double)baseY)) / 10;
        if (indx >= entry_size) {
            return -1;
        }
        return indx;
    }

    private void onMouseMoved(double x, double y) {
        int newIndx = this.getHoveredIndex(x, y, this.dogIdFilterList.size());
        if (newIndx < 0) {
            return;
        }
        this.hightlightDogName = newIndx;
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        boolean ret = super.m_6375_(x, y, p_94697_);
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return ret;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return ret;
        }
        int indx = this.getHoveredIndex(x, y, this.dogIdFilterList.size());
        if (indx >= 0) {
            UUID uuid = this.dogIdFilterList.get(indx);
            String name = this.dogNameFilterList.get(indx);
            this.startLocateDog(uuid, name, this.dogPosMap.getOrDefault(uuid, BlockPos.f_121853_));
            Minecraft.m_91087_().m_91152_(null);
        }
        return ret;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 264) {
            this.hightlightDogName = Mth.m_14045_((int)(this.hightlightDogName + 1), (int)0, (int)(this.dogNameFilterList.size() - 1));
        } else if (keyCode == 265) {
            this.hightlightDogName = Mth.m_14045_((int)(this.hightlightDogName - 1), (int)0, (int)(this.dogNameFilterList.size() - 1));
        } else if (keyCode == 257) {
            if (this.dogIdFilterList.isEmpty()) {
                return false;
            }
            UUID uuid = this.dogIdFilterList.get(this.hightlightDogName);
            String name = this.dogNameFilterList.get(this.hightlightDogName);
            this.startLocateDog(uuid, name, this.dogPosMap.getOrDefault(uuid, BlockPos.f_121853_));
            this.f_96541_.m_91152_(null);
        } else if (keyCode == 259) {
            this.popCharInText();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char code, int p_231042_2_) {
        if (SharedConstants.m_136188_((char)code)) {
            this.insertText(Character.toString(code));
            return true;
        }
        return false;
    }

    private void updateFilter() {
        this.dogNameFilterList.clear();
        this.dogIdFilterList.clear();
        this.hightlightDogName = 0;
        if (this.value == "") {
            for (String string : this.dogNameList) {
                this.dogNameFilterList.add(string);
            }
            for (UUID uUID : this.dogIdList) {
                this.dogIdFilterList.add(uUID);
            }
        } else {
            for (int i = 0; i < this.dogIdList.size(); ++i) {
                if (this.dogNameList.get(i).length() < this.value.length() || !this.dogNameList.get(i).contains(this.value)) continue;
                this.dogIdFilterList.add(this.dogIdList.get(i));
                this.dogNameFilterList.add(this.dogNameList.get(i));
            }
        }
    }

    private void insertText(String x) {
        if (this.value.length() < 64) {
            this.value = this.value + x;
        }
        this.updateFilter();
    }

    private void popCharInText() {
        if (this.value.length() <= 0) {
            return;
        }
        this.value = this.value.substring(0, this.value.length() - 1);
        this.updateFilter();
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void requestDogs() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.RequestDogsData());
    }

    public void assignResponse(List<Triple<UUID, String, BlockPos>> dogLs) {
        for (Triple<UUID, String, BlockPos> entry : dogLs) {
            this.dogNameList.add((String)entry.getMiddle());
            this.dogNameFilterList.add((String)entry.getMiddle());
            this.dogIdList.add((UUID)entry.getLeft());
            this.dogIdFilterList.add((UUID)entry.getLeft());
            BlockPos pos = (BlockPos)entry.getRight();
            int distance = Mth.m_14167_((float)Mth.m_14116_((float)((float)this.player.m_20183_().m_123331_((Vec3i)pos))));
            this.dogDistanceMap.put((UUID)entry.getLeft(), distance);
            this.dogPosMap.put((UUID)entry.getLeft(), pos);
        }
    }

    private void startLocateDog(UUID uuid, String name, BlockPos pos) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.StartLocatingData(uuid, name, pos));
    }
}

