/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyAccessories;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.Talent;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogModeData;
import doggytalents.common.network.packet.data.DogNameData;
import doggytalents.common.network.packet.data.DogObeyData;
import doggytalents.common.network.packet.data.DogTalentData;
import doggytalents.common.network.packet.data.DogTextureData;
import doggytalents.common.network.packet.data.FriendlyFireData;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class DogInfoScreen
extends Screen {
    public final Dog dog;
    public final Player player;
    private int currentPage = 0;
    private int maxPages = 1;
    private List<AbstractWidget> talentWidgets = new ArrayList<AbstractWidget>(16);
    private Button leftBtn;
    private Button rightBtn;
    private List<Talent> talentList;
    private List<DogSkin> customSkinList;
    public int textureIndex;

    public DogInfoScreen(Dog dog, Player player) {
        super((Component)Component.m_237115_((String)"doggytalents.screen.dog.title"));
        this.dog = dog;
        this.player = player;
        this.talentList = DoggyTalentsAPI.TALENTS.get().getValues().stream().sorted(Comparator.comparing(t -> I18n.m_118938_((String)t.getTranslationKey(), (Object[])new Object[0]))).collect(Collectors.toList());
        this.customSkinList = DogTextureManager.INSTANCE.getAll();
        this.textureIndex = this.customSkinList.indexOf(DogTextureManager.INSTANCE.getSkinFromHash(dog.getSkinHash()));
        this.textureIndex = this.textureIndex >= 0 ? this.textureIndex : 0;
    }

    public static void open(Dog dog) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new DogInfoScreen(dog, (Player)mc.f_91074_));
    }

    public void m_7856_() {
        super.m_7856_();
        int topX = this.f_96543_ / 2;
        int topY = this.f_96544_ / 2;
        EditBox nameTextField = new EditBox(this.f_96547_, topX - 100, topY + 50, 200, 20, (Component)Component.m_237115_((String)"dogInfo.enterName"));
        nameTextField.m_94151_(text -> PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogNameData(this.dog.m_19879_(), (String)text)));
        nameTextField.m_93692_(false);
        nameTextField.m_94199_(32);
        if (this.dog.m_8077_()) {
            nameTextField.m_94144_(this.dog.m_7770_().getString());
        }
        this.m_142416_((GuiEventListener)nameTextField);
        if (this.dog.m_21830_((LivingEntity)this.player)) {
            Button obeyBtn = new Button.Builder((Component)Component.m_237113_((String)String.valueOf(this.dog.willObeyOthers())), btn -> {
                btn.m_93666_((Component)Component.m_237113_((String)String.valueOf(!this.dog.willObeyOthers())));
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogObeyData(this.dog.m_19879_(), !this.dog.willObeyOthers()));
            }).m_252794_(this.f_96543_ - 64, topY + 77).m_253046_(42, 20).m_253136_();
            this.m_142416_((GuiEventListener)obeyBtn);
        }
        CustomButton attackPlayerBtn = new CustomButton(this.f_96543_ - 64, topY - 5, 42, 20, (Component)Component.m_237113_((String)String.valueOf(this.dog.canOwnerAttack())), button -> {
            button.m_93666_((Component)Component.m_237113_((String)String.valueOf(!this.dog.canOwnerAttack())));
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new FriendlyFireData(this.dog.m_19879_(), !this.dog.canOwnerAttack()));
        });
        this.m_142416_((GuiEventListener)attackPlayerBtn);
        Button addBtn = new Button.Builder((Component)Component.m_237113_((String)"+"), btn -> {
            ++this.textureIndex;
            this.textureIndex %= this.customSkinList.size();
            DogSkin skin = this.customSkinList.get(this.textureIndex);
            this.setDogTexture(skin);
        }).m_252794_(this.f_96543_ - 42, topY + 30).m_253046_(20, 20).m_253136_();
        Button lessBtn = new Button.Builder((Component)Component.m_237113_((String)"-"), btn -> {
            this.textureIndex += this.customSkinList.size() - 1;
            this.textureIndex %= this.customSkinList.size();
            DogSkin rl = this.customSkinList.get(this.textureIndex);
            this.setDogTexture(rl);
        }).m_252794_(this.f_96543_ - 64, topY + 30).m_253046_(20, 20).m_253136_();
        this.m_142416_((GuiEventListener)addBtn);
        this.m_142416_((GuiEventListener)lessBtn);
        CustomButton modeBtn = new CustomButton(topX + 40, topY + 25, 60, 20, (Component)Component.m_237115_((String)this.dog.getMode().getUnlocalisedName()), button -> {
            EnumMode mode = this.dog.getMode().nextMode();
            if (mode == EnumMode.WANDERING && !this.dog.getBowlPos().isPresent()) {
                button.m_93666_((Component)Component.m_237115_((String)mode.getUnlocalisedName()).m_130940_(ChatFormatting.RED));
            } else {
                button.m_93666_((Component)Component.m_237115_((String)mode.getUnlocalisedName()));
            }
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogModeData(this.dog.m_19879_(), mode));
        }){

            public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                super.m_86412_(stack, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                String str = I18n.m_118938_((String)DogInfoScreen.this.dog.getMode().getUnlocalisedInfo(), (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, DogInfoScreen.this.f_96547_));
                if (DogInfoScreen.this.dog.getMode() == EnumMode.WANDERING) {
                    if (DogInfoScreen.this.dog.getBowlPos().isPresent()) {
                        double distance = DogInfoScreen.this.dog.m_20183_().m_123331_((Vec3i)DogInfoScreen.this.dog.getBowlPos().get());
                        if (distance > 256.0) {
                            list.add(Component.m_237110_((String)"dog.mode.docile.distance", (Object[])new Object[]{(int)Math.sqrt(distance)}).m_130940_(ChatFormatting.RED));
                        } else {
                            list.add(Component.m_237110_((String)"dog.mode.docile.bowl", (Object[])new Object[]{(int)Math.sqrt(distance)}).m_130940_(ChatFormatting.GREEN));
                        }
                    } else {
                        list.add(Component.m_237115_((String)"dog.mode.docile.nobowl").m_130940_(ChatFormatting.RED));
                    }
                }
                DogInfoScreen.this.m_96597_(stack, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)modeBtn);
        int size = DoggyTalentsAPI.TALENTS.get().getKeys().size();
        int perPage = Math.max(Mth.m_14107_((double)((double)(this.f_96544_ - 10) / 21.0)) - 2, 1);
        this.currentPage = 0;
        this.recalculatePage(perPage);
        if (perPage < size) {
            this.leftBtn = new Button.Builder((Component)Component.m_237113_((String)"<"), btn -> {
                this.currentPage = Math.max(0, this.currentPage - 1);
                btn.f_93623_ = this.currentPage > 0;
                this.rightBtn.f_93623_ = true;
                this.recalculatePage(perPage);
            }).m_252794_(25, perPage * 21 + 10).m_253046_(20, 20).m_253136_();
            this.leftBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"doggui.prevpage").m_130940_(ChatFormatting.ITALIC)));
            this.leftBtn.f_93623_ = false;
            this.rightBtn = new Button.Builder((Component)Component.m_237113_((String)">"), btn -> {
                this.currentPage = Math.min(this.maxPages - 1, this.currentPage + 1);
                btn.f_93623_ = this.currentPage < this.maxPages - 1;
                this.leftBtn.f_93623_ = true;
                this.recalculatePage(perPage);
            }).m_252794_(48, perPage * 21 + 10).m_253046_(20, 20).m_253136_();
            this.rightBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"doggui.nextpage").m_130940_(ChatFormatting.ITALIC)));
            this.m_142416_((GuiEventListener)this.leftBtn);
            this.m_142416_((GuiEventListener)this.rightBtn);
        }
    }

    private void setDogTexture(DogSkin dogSkin) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTextureData(this.dog.m_19879_(), DogTextureManager.INSTANCE.getTextureHash(dogSkin)));
    }

    private void recalculatePage(int perPage) {
        int index;
        this.talentWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.talentWidgets.clear();
        this.maxPages = Mth.m_14165_((double)((double)this.talentList.size() / (double)perPage));
        for (int i = 0; i < perPage && (index = this.currentPage * perPage + i) < this.talentList.size(); ++i) {
            Talent talent = this.talentList.get(index);
            TalentButton button = new TalentButton(25, 10 + i * 21, 20, 20, (Component)Component.m_237113_((String)"+"), talent, btn -> {
                int level = this.dog.getDogLevel(talent);
                if (level < talent.getMaxLevel() && this.dog.canSpendPoints(talent.getLevelCost(level + 1))) {
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTalentData(this.dog.m_19879_(), talent));
                }
            }){

                public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                    super.m_86412_(stack, mouseX, mouseY, pTicks);
                    if (!this.f_93622_) {
                        return;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(Component.m_237115_((String)this.talent.getTranslationKey()).m_130940_(ChatFormatting.GREEN));
                    if (this.f_93623_) {
                        list.add(Component.m_237113_((String)("Level: " + DogInfoScreen.this.dog.getDogLevel(this.talent))));
                        list.add(Component.m_237113_((String)"--------------------------------").m_130940_(ChatFormatting.GRAY));
                        list.addAll(ScreenUtil.splitInto(I18n.m_118938_((String)this.talent.getInfoTranslationKey(), (Object[])new Object[0]), 200, DogInfoScreen.this.f_96547_));
                    } else {
                        list.add(Component.m_237113_((String)"Talent disabled").m_130940_(ChatFormatting.RED));
                    }
                    DogInfoScreen.this.m_96597_(stack, list, mouseX, mouseY);
                }
            };
            button.f_93623_ = ConfigHandler.TALENT.getFlag(talent);
            this.talentWidgets.add((AbstractWidget)button);
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int topX = this.f_96543_ / 2;
        int topY = this.f_96544_ / 2;
        this.m_7333_(stack);
        String health = Util.format1DP(this.dog.m_21223_());
        String healthMax = Util.format1DP(this.dog.m_21233_());
        String speedValue = Util.format2DP(this.dog.m_21051_(Attributes.f_22279_).m_22135_());
        String armorValue = Util.format2DP(this.dog.m_21051_(Attributes.f_22284_).m_22135_());
        String ageValue = Util.format2DP(this.dog.m_146764_());
        String ageRel = I18n.m_118938_((String)(this.dog.m_6162_() ? "doggui.age.baby" : "doggui.age.adult"), (Object[])new Object[0]);
        String ageString = ageValue + " " + ageRel;
        String tamedString = "";
        if (this.dog.m_21824_()) {
            if (this.dog.m_21830_((LivingEntity)this.player)) {
                tamedString = I18n.m_118938_((String)"doggui.owner.you", (Object[])new Object[0]);
            } else if (this.dog.getOwnersName().isPresent()) {
                tamedString = this.dog.getOwnersName().get().getString();
            }
        }
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.speed", (Object[])new Object[0]) + " " + speedValue, (float)(this.f_96543_ - 160), (float)(topY - 100), 0xFFFFFF);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.owner", (Object[])new Object[0]) + " " + tamedString, (float)(this.f_96543_ - 160), (float)(topY - 90), 0xFFFFFF);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.age", (Object[])new Object[0]) + " " + ageString, (float)(this.f_96543_ - 160), (float)(topY - 80), 0xFFFFFF);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.armor", (Object[])new Object[0]) + " " + armorValue, (float)(this.f_96543_ - 160), (float)(topY - 70), 0xFFFFFF);
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GENDER)).booleanValue()) {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.gender", (Object[])new Object[0]) + " " + I18n.m_118938_((String)this.dog.getGender().getUnlocalisedName(), (Object[])new Object[0]), (float)(this.f_96543_ - 160), (float)(topY - 60), 0xFFFFFF);
        }
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.newname", (Object[])new Object[0]), (float)(topX - 100), (float)(topY + 38), 0x404040);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.level", (Object[])new Object[0]) + " " + this.dog.getDogLevel().getLevel(DogLevel.Type.NORMAL), (float)(topX - 65), (float)(topY + 75), 16716025);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.leveldire", (Object[])new Object[0]) + " " + this.dog.getDogLevel().getLevel(DogLevel.Type.DIRE), (float)topX, (float)(topY + 75), 16716025);
        if (this.dog.getAccessory((Accessory)DoggyAccessories.GOLDEN_COLLAR.get()).isPresent()) {
            this.f_96547_.m_92883_(stack, ChatFormatting.GOLD + "Unlimited Points", (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        } else {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.pointsleft", (Object[])new Object[0]) + " " + this.dog.getSpendablePoints(), (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        }
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.textureindex", (Object[])new Object[0]), (float)(this.f_96543_ - 80), (float)(topY + 20), 0xFFFFFF);
        this.f_96547_.m_92883_(stack, this.dog.getSkinHash().substring(0, Math.min(this.dog.getSkinHash().length(), 10)), (float)(this.f_96543_ - 73), (float)(topY + 54), 0xFFFFFF);
        if (this.dog.m_21830_((LivingEntity)this.player)) {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.obeyothers", (Object[])new Object[0]), (float)(this.f_96543_ - 76), (float)(topY + 67), 0xFFFFFF);
        }
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.friendlyfire", (Object[])new Object[0]), (float)(this.f_96543_ - 76), (float)(topY - 15), 0xFFFFFF);
        this.f_169369_.forEach(widget -> {
            if (widget instanceof TalentButton) {
                TalentButton talBut = (TalentButton)((Object)widget);
                this.f_96547_.m_92883_(stack, I18n.m_118938_((String)talBut.talent.getTranslationKey(), (Object[])new Object[0]), (float)(talBut.m_252754_() + 25), (float)(talBut.m_252907_() + 7), 0xFFFFFF);
            }
        });
        super.m_86412_(stack, mouseX, mouseY, partialTicks);
        if (!this.dog.isDoingFine()) {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public boolean m_7043_() {
        return false;
    }

    private static class TalentButton
    extends Button {
        protected Talent talent;

        private TalentButton(int x, int y, int widthIn, int heightIn, Component buttonText, Talent talent, Consumer<TalentButton> onPress) {
            super(x, y, widthIn, heightIn, buttonText, button -> onPress.accept((TalentButton)button), c -> Component.m_237113_((String)""));
            this.talent = talent;
        }
    }
}

