/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByGroupData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class HeelByGroupScreen
extends Screen {
    private Rect2i rect;
    private Player player;
    private List<DogGroupsManager.DogGroup> dogGroupList;
    private List<DogGroupsManager.DogGroup> dogGroupFilterList;
    private int hightlightDogGroup;
    private boolean showUuid = false;
    private String value = "";
    private boolean heelAndSit = false;
    private final int HLC_HEEL_NO_SIT = 16716025;
    private final int HLC_HEEL_AND_SIT = 0xFF6F00;
    private int hightlightTextColor = 16716025;
    private int mouseX0 = -1;
    private int mouseY0 = -1;
    private final int MAX_BUFFER_SIZE = 16;

    public HeelByGroupScreen(Player player) {
        super((Component)Component.m_237115_((String)"doggytalents.screen.heel_by_group"));
        this.player = player;
        this.dogGroupList = new ArrayList<DogGroupsManager.DogGroup>();
        this.dogGroupFilterList = new ArrayList<DogGroupsManager.DogGroup>();
        this.hightlightDogGroup = 0;
    }

    public static void open() {
        Minecraft mc = Minecraft.m_91087_();
        HeelByGroupScreen screen = new HeelByGroupScreen((Player)mc.f_91074_);
        mc.m_91152_((Screen)screen);
        screen.requestGroups();
    }

    public void m_7856_() {
        super.m_7856_();
        this.rect = new Rect2i(0, 0, 500, 500);
        CustomButton help = new CustomButton(3, 26, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                super.m_86412_(stack, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.heel_by_group.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.heel_by_group.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, HeelByGroupScreen.this.f_96547_));
                HeelByGroupScreen.this.m_96597_(stack, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)help);
    }

    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int half_width = this.f_96543_ >> 1;
        int half_height = this.f_96544_ >> 1;
        if (this.mouseX0 != mouseX || this.mouseY0 != mouseY) {
            if (this.mouseX0 < 0 || this.mouseY0 < 0) {
                int dx = Math.abs(mouseX - half_width);
                int dy = Math.abs(mouseY - half_height);
                if (dx > 10 || dy > 10) {
                    this.onMouseMoved(mouseX, mouseY);
                    this.mouseX0 = mouseX;
                    this.mouseY0 = mouseY;
                }
            } else {
                this.onMouseMoved(mouseX, mouseY);
                this.mouseX0 = mouseX;
                this.mouseY0 = mouseY;
            }
        }
        Gui.m_93172_((PoseStack)stack, (int)(half_width - 100), (int)(half_height - 100), (int)(half_width + 100), (int)(half_height + 100), (int)Integer.MIN_VALUE);
        Gui.m_93172_((PoseStack)stack, (int)(half_width - 100), (int)(half_height + 105), (int)(half_width + 100), (int)(half_height + 117), (int)Integer.MIN_VALUE);
        super.m_86412_(stack, mouseX, mouseY, partialTicks);
        int offset = 0;
        int textx = half_width - 100 + 2;
        int texty = half_height - 100 + 2;
        if (this.dogGroupFilterList.size() <= 0) {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggytalents.screen.heel_by_group.no_group_found", (Object[])new Object[0]), (float)textx, (float)(texty + offset), 16058890);
        }
        for (int i = 0; i < this.dogGroupFilterList.size(); ++i) {
            int color = -1;
            DogGroupsManager.DogGroup group = this.dogGroupFilterList.get(i);
            if (i == this.hightlightDogGroup) {
                color = this.hightlightTextColor;
            }
            HeelByGroupScreen.m_93172_((PoseStack)stack, (int)textx, (int)(texty - 1 + offset), (int)(textx + 9), (int)(texty - 1 + offset + 9), (int)group.color);
            String text = group.name;
            this.f_96547_.m_92883_(stack, text, (float)(textx + 10), (float)(texty + offset), color);
            if ((offset += 10) > 190) break;
        }
        int txtorgx = half_width - 90;
        int txtorgy = half_height + 107;
        this.f_96547_.m_92883_(stack, this.value + "_", (float)txtorgx, (float)txtorgy, -1);
    }

    private int getHoveredIndex(double x, double y, int entry_size) {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return -1;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return -1;
        }
        int baseY = mY - 100;
        int indx = Mth.m_14107_((double)(y - (double)baseY)) / 10;
        if (indx >= entry_size) {
            return -1;
        }
        return indx;
    }

    private void onMouseMoved(double x, double y) {
        int newIndx = this.getHoveredIndex(x, y, this.dogGroupFilterList.size());
        if (newIndx < 0) {
            return;
        }
        this.hightlightDogGroup = newIndx;
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        boolean ret = super.m_6375_(x, y, p_94697_);
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return ret;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return ret;
        }
        int indx = this.getHoveredIndex(x, y, this.dogGroupFilterList.size());
        if (indx >= 0) {
            this.requestHeelByGroup(this.dogGroupFilterList.get(indx), this.heelAndSit);
            Minecraft.m_91087_().m_91152_(null);
        }
        return ret;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 264) {
            this.hightlightDogGroup = Mth.m_14045_((int)(this.hightlightDogGroup + 1), (int)0, (int)(this.dogGroupFilterList.size() - 1));
        } else if (keyCode == 265) {
            this.hightlightDogGroup = Mth.m_14045_((int)(this.hightlightDogGroup - 1), (int)0, (int)(this.dogGroupFilterList.size() - 1));
        } else if (keyCode == 257) {
            if (this.dogGroupFilterList.isEmpty()) {
                return false;
            }
            this.requestHeelByGroup(this.dogGroupFilterList.get(this.hightlightDogGroup), this.heelAndSit);
            this.f_96541_.m_91152_(null);
        } else if (keyCode == 259) {
            this.popCharInText();
        } else if (keyCode == 340) {
            this.hightlightTextColor = 0xFF6F00;
            this.heelAndSit = true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.hightlightTextColor = 16716025;
            this.heelAndSit = false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char code, int p_231042_2_) {
        if (SharedConstants.m_136188_((char)code)) {
            this.insertText(Character.toString(code));
            return true;
        }
        return false;
    }

    private void updateFilter() {
        this.dogGroupFilterList.clear();
        this.hightlightDogGroup = 0;
        if (this.value == "") {
            for (DogGroupsManager.DogGroup i : this.dogGroupList) {
                this.dogGroupFilterList.add(i);
            }
        } else {
            for (int i = 0; i < this.dogGroupList.size(); ++i) {
                if (this.dogGroupList.get((int)i).name.length() < this.value.length() || !this.dogGroupList.get((int)i).name.contains(this.value)) continue;
                this.dogGroupFilterList.add(this.dogGroupList.get(i));
            }
        }
    }

    private void insertText(String x) {
        if (this.value.length() < 16) {
            this.value = this.value + x;
        }
        this.updateFilter();
    }

    private void popCharInText() {
        if (this.value.length() <= 0) {
            return;
        }
        this.value = this.value.substring(0, this.value.length() - 1);
        this.updateFilter();
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void requestGroups() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByGroupData.REQUEST_GROUP_LIST());
    }

    private void requestHeelByGroup(DogGroupsManager.DogGroup group, boolean heelAndSit) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByGroupData.REQUEST_HEEL(group, heelAndSit));
    }

    public void assignResponse(List<DogGroupsManager.DogGroup> groups) {
        for (DogGroupsManager.DogGroup group : groups) {
            this.dogGroupList.add(group);
            this.dogGroupFilterList.add(group);
        }
    }
}

