/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByNameData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class HeelByNameScreen
extends Screen {
    private Rect2i rect;
    private Player player;
    private List<String> dogNameList;
    private List<Integer> dogIdList;
    private List<String> dogNameFilterList;
    private List<Integer> dogIdFilterList;
    private int hightlightDogName;
    private boolean showUuid = false;
    private String value = "";
    private boolean heelAndSit = false;
    private boolean softHeel = false;
    private final int HLC_HEEL_NO_SIT = 16716025;
    private final int HLC_HEEL_AND_SIT = 0xFF6F00;
    private int hightlightTextColor = 16716025;
    private int mouseX0 = -1;
    private int mouseY0 = -1;
    private final int MAX_BUFFER_SIZE = 64;

    public HeelByNameScreen(Player player, boolean softHeel) {
        super((Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name"));
        this.player = player;
        this.dogNameList = new ArrayList<String>(4);
        this.dogIdList = new ArrayList<Integer>(4);
        this.dogIdFilterList = new ArrayList<Integer>(4);
        this.dogNameFilterList = new ArrayList<String>(4);
        this.hightlightDogName = 0;
        this.softHeel = softHeel;
        List<Dog> dogsList = Minecraft.m_91087_().f_91073_.m_6443_(Dog.class, this.player.m_20191_().m_82377_(100.0, 50.0, 100.0), d -> d.m_21830_((LivingEntity)player));
        dogsList = FrequentHeelStore.get(this).sortDogList(dogsList);
        for (Dog d2 : dogsList) {
            this.dogNameList.add(d2.m_7755_().getString());
            this.dogNameFilterList.add(d2.m_7755_().getString());
            this.dogIdList.add(d2.m_19879_());
            this.dogIdFilterList.add(d2.m_19879_());
        }
    }

    public static void open() {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (stack == null) {
            return;
        }
        if (!(stack.m_41720_() instanceof WhistleItem)) {
            return;
        }
        boolean softHeel = false;
        if (stack.m_41782_()) {
            softHeel = stack.m_41783_().m_128471_("soft_heel");
        }
        mc.m_91152_((Screen)new HeelByNameScreen((Player)mc.f_91074_, softHeel));
    }

    public void m_7856_() {
        super.m_7856_();
        this.rect = new Rect2i(0, 0, 500, 500);
        CustomButton showUuid = new CustomButton(3, 3, 60, 20, (Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.m_93666_((Component)Component.m_237115_((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        CustomButton help = new CustomButton(3, 26, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                super.m_86412_(stack, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.whistler.heel_by_name.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, HeelByNameScreen.this.f_96547_));
                HeelByNameScreen.this.m_96597_(stack, list, mouseX, mouseY);
            }
        };
        Objects.requireNonNull(this.f_96547_);
        CustomButton softHeel = new CustomButton(3, 52 + 9 + 2, 60, 20, (Component)Component.m_237113_((String)("" + this.softHeel)), b -> {
            this.softHeel = !this.softHeel;
            b.m_93666_((Component)Component.m_237113_((String)("" + this.softHeel)));
        }){

            public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                super.m_86412_(stack, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, HeelByNameScreen.this.f_96547_));
                HeelByNameScreen.this.m_96597_(stack, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)showUuid);
        this.m_142416_((GuiEventListener)help);
        this.m_142416_((GuiEventListener)softHeel);
    }

    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        String soft_heel = I18n.m_118938_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel", (Object[])new Object[0]);
        this.f_96547_.m_92883_(stack, soft_heel, 3.0f, 52.0f, -1);
        int half_width = this.f_96543_ >> 1;
        int half_height = this.f_96544_ >> 1;
        if (this.mouseX0 != mouseX || this.mouseY0 != mouseY) {
            if (this.mouseX0 < 0 || this.mouseY0 < 0) {
                int dx = Math.abs(mouseX - half_width);
                int dy = Math.abs(mouseY - half_height);
                if (dx > 10 || dy > 10) {
                    this.onMouseMoved(mouseX, mouseY);
                    this.mouseX0 = mouseX;
                    this.mouseY0 = mouseY;
                }
            } else {
                this.onMouseMoved(mouseX, mouseY);
                this.mouseX0 = mouseX;
                this.mouseY0 = mouseY;
            }
        }
        Gui.m_93172_((PoseStack)stack, (int)(half_width - 100), (int)(half_height - 100), (int)(half_width + 100), (int)(half_height + 100), (int)Integer.MIN_VALUE);
        Gui.m_93172_((PoseStack)stack, (int)(half_width - 100), (int)(half_height + 105), (int)(half_width + 100), (int)(half_height + 117), (int)Integer.MIN_VALUE);
        super.m_86412_(stack, mouseX, mouseY, partialTicks);
        int offset = 0;
        int textx = half_width - 100 + 2;
        int texty = half_height - 100 + 2;
        if (this.dogNameFilterList.size() <= 0) {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggytalents.screen.whistler.heel_by_name.no_dog_found", (Object[])new Object[0]), (float)textx, (float)(texty + offset), 16058890);
        }
        for (int i = 0; i < this.dogNameFilterList.size(); ++i) {
            String uuid;
            Entity dog;
            int color = -1;
            if (i == this.hightlightDogName) {
                color = this.hightlightTextColor;
            }
            Object text = this.dogNameFilterList.get(i);
            if (this.showUuid && (dog = this.f_96541_.f_91073_.m_6815_(this.dogIdFilterList.get(i).intValue())) != null && (uuid = dog.m_20149_()) != null) {
                text = this.dogNameFilterList.get(i) + " ( " + uuid + " ) ";
            }
            this.f_96547_.m_92883_(stack, (String)text, (float)textx, (float)(texty + offset), color);
            if ((offset += 10) > 190) break;
        }
        int txtorgx = half_width - 90;
        int txtorgy = half_height + 107;
        this.f_96547_.m_92883_(stack, this.value + "_", (float)txtorgx, (float)txtorgy, -1);
    }

    private int getHoveredIndex(double x, double y, int entry_size) {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return -1;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return -1;
        }
        int baseY = mY - 100;
        int indx = Mth.m_14107_((double)(y - (double)baseY)) / 10;
        if (indx >= entry_size) {
            return -1;
        }
        return indx;
    }

    private void onMouseMoved(double x, double y) {
        int newIndx = this.getHoveredIndex(x, y, this.dogIdFilterList.size());
        if (newIndx < 0) {
            return;
        }
        this.hightlightDogName = newIndx;
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        boolean ret = super.m_6375_(x, y, p_94697_);
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return ret;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return ret;
        }
        int indx = this.getHoveredIndex(x, y, this.dogIdFilterList.size());
        if (indx >= 0) {
            this.requestHeel(this.dogIdFilterList.get(indx));
            Minecraft.m_91087_().m_91152_(null);
        }
        return ret;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 264) {
            this.hightlightDogName = Mth.m_14045_((int)(this.hightlightDogName + 1), (int)0, (int)(this.dogNameFilterList.size() - 1));
        } else if (keyCode == 265) {
            this.hightlightDogName = Mth.m_14045_((int)(this.hightlightDogName - 1), (int)0, (int)(this.dogNameFilterList.size() - 1));
        } else if (keyCode == 257) {
            if (this.dogIdFilterList.isEmpty()) {
                return false;
            }
            this.requestHeel(this.dogIdFilterList.get(this.hightlightDogName));
            this.f_96541_.m_91152_(null);
        } else if (keyCode == 259) {
            this.popCharInText();
        } else if (keyCode == 340) {
            this.hightlightTextColor = 0xFF6F00;
            this.heelAndSit = true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.hightlightTextColor = 16716025;
            this.heelAndSit = false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char code, int p_231042_2_) {
        if (SharedConstants.m_136188_((char)code)) {
            this.insertText(Character.toString(code));
            return true;
        }
        return false;
    }

    private void updateFilter() {
        this.dogNameFilterList.clear();
        this.dogIdFilterList.clear();
        this.hightlightDogName = 0;
        if (this.value == "") {
            for (String string : this.dogNameList) {
                this.dogNameFilterList.add(string);
            }
            for (Integer n : this.dogIdList) {
                this.dogIdFilterList.add(n);
            }
        } else {
            for (int i = 0; i < this.dogIdList.size(); ++i) {
                if (this.dogNameList.get(i).length() < this.value.length() || !this.dogNameList.get(i).contains(this.value)) continue;
                this.dogIdFilterList.add(this.dogIdList.get(i));
                this.dogNameFilterList.add(this.dogNameList.get(i));
            }
        }
    }

    private void insertText(String x) {
        if (this.value.length() < 64) {
            this.value = this.value + x;
        }
        this.updateFilter();
    }

    private void popCharInText() {
        if (this.value.length() <= 0) {
            return;
        }
        this.value = this.value.substring(0, this.value.length() - 1);
        this.updateFilter();
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void requestHeel(int id) {
        FrequentHeelStore.get(this).pushDogToFrequentStack(id);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByNameData(id, this.heelAndSit, this.softHeel));
    }

    private static class FrequentHeelStore {
        private static FrequentHeelStore INSTANCE;
        private ArrayList<UUID> dogFrequentStack = new ArrayList();
        private Screen screen;
        private ToIntFunction<Dog> GET_FREQ_COUNT = d -> this.getFrequentWeightFor((Dog)d);
        private static final int STORE_CAP = 32;

        private FrequentHeelStore(Screen screen) {
            this.screen = screen;
        }

        public void pushDogToFrequentStack(int id) {
            Entity dog = this.screen.getMinecraft().f_91073_.m_6815_(id);
            if (dog == null) {
                return;
            }
            String uuid_str = dog.m_20149_();
            if (uuid_str == null) {
                return;
            }
            UUID uuid = null;
            try {
                uuid = UUID.fromString(uuid_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uuid == null) {
                return;
            }
            int indx = this.dogFrequentStack.indexOf(uuid);
            if (indx > 0) {
                if (indx >= this.dogFrequentStack.size() - 1) {
                    return;
                }
                this.dogFrequentStack.remove(uuid);
            }
            this.dogFrequentStack.add(uuid);
            if (this.dogFrequentStack.size() > 32) {
                this.dogFrequentStack.remove(0);
            }
        }

        public int getFrequentWeightFor(Dog dog) {
            String uuid_str = dog.m_20149_();
            if (uuid_str == null) {
                return 0;
            }
            UUID uuid = null;
            try {
                uuid = UUID.fromString(uuid_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uuid == null) {
                return 0;
            }
            int indx = this.dogFrequentStack.indexOf(uuid);
            return Math.max(0, indx + 1);
        }

        public List<Dog> sortDogList(List<Dog> dogList) {
            return dogList.stream().sorted(Comparator.comparingInt(this.GET_FREQ_COUNT).reversed()).collect(Collectors.toList());
        }

        public static FrequentHeelStore get(Screen screen) {
            if (INSTANCE == null) {
                INSTANCE = new FrequentHeelStore(screen);
            }
            if (FrequentHeelStore.INSTANCE.screen != screen) {
                FrequentHeelStore.INSTANCE.screen = screen;
            }
            return INSTANCE;
        }
    }
}

