/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyItems;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.WhisltleEditHotKeyData;
import doggytalents.common.network.packet.data.WhistleRequestModeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class WhistleScreen
extends Screen {
    private List<WhistleItem.WhistleMode> modeFilterList;
    private int selectedId;
    private String value = "";
    private final int HLC_SELECTED = 16716025;
    private int hightlightTextColor = 16716025;
    private final int MAX_BUFFER_SIZE = 64;
    private int mouseX0;
    private int mouseY0;
    private boolean settingKeysMode = false;
    private int pKey = 0;
    private int[] hotkeysModeArr = new int[]{-1, -1, -1, -1};

    public WhistleScreen() {
        super((Component)Component.m_237115_((String)"doggytalents.screen.whistler.title"));
        this.modeFilterList = new ArrayList<WhistleItem.WhistleMode>();
        for (WhistleItem.WhistleMode i : WhistleItem.WhistleMode.VALUES) {
            this.modeFilterList.add(i);
        }
        this.selectedId = 0;
    }

    public static void open() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new WhistleScreen());
    }

    public void m_7856_() {
        super.m_7856_();
        CustomButton help = new CustomButton(3, 3, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                super.m_86412_(stack, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.whistler.screen.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.whistler.screen.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, WhistleScreen.this.f_96547_));
                WhistleScreen.this.m_96597_(stack, list, mouseX, mouseY);
            }
        };
        CustomButton setKey = new CustomButton(3, 23, 60, 20, (Component)Component.m_237115_((String)"doggytalents.screen.whistler.screen.set_hotkey"), b -> {
            if (this.settingKeysMode) {
                this.settingKeysMode = false;
                b.m_93666_((Component)Component.m_237115_((String)"doggytalents.screen.whistler.screen.set_hotkey"));
            } else {
                this.settingKeysMode = true;
                b.m_93666_((Component)Component.m_237115_((String)"doggytalents.screen.whistler.screen.use_whistle"));
            }
        }){

            public void m_86412_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
                super.m_86412_(stack, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.whistler.screen.set_hotkey").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.whistler.screen.set_hotkey.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, WhistleScreen.this.f_96547_));
                WhistleScreen.this.m_96597_(stack, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)help);
        this.m_142416_((GuiEventListener)setKey);
    }

    public void m_86412_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.mouseX0 != mouseX || this.mouseY0 != mouseY) {
            this.onMouseMoved(mouseX, mouseY);
            this.mouseX0 = mouseX;
            this.mouseY0 = mouseY;
        }
        int half_width = this.f_96543_ >> 1;
        int half_height = this.f_96544_ >> 1;
        Gui.m_93172_((PoseStack)stack, (int)(half_width - 100), (int)(half_height - 100), (int)(half_width + 100), (int)(half_height + 100), (int)Integer.MIN_VALUE);
        Gui.m_93172_((PoseStack)stack, (int)(half_width - 100), (int)(half_height + 105), (int)(half_width + 100), (int)(half_height + 117), (int)Integer.MIN_VALUE);
        super.m_86412_(stack, mouseX, mouseY, partialTicks);
        if (this.settingKeysMode) {
            this.renderModeListSetHotkey(stack, mouseX, mouseY, partialTicks);
        } else {
            this.renderModeListWhistleUse(stack, mouseX, mouseY, partialTicks);
        }
        int txtorgx = half_width - 90;
        int txtorgy = half_height + 107;
        this.f_96547_.m_92883_(stack, this.value + "_", (float)txtorgx, (float)txtorgy, -1);
    }

    public void renderModeListWhistleUse(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int half_width = this.f_96543_ >> 1;
        int half_height = this.f_96544_ >> 1;
        int offset = 0;
        int textx = half_width - 100 + 2;
        int texty = half_height - 100 + 2;
        for (int i = 0; i < this.modeFilterList.size(); ++i) {
            int color = -1;
            if (i == this.selectedId) {
                color = this.hightlightTextColor;
            }
            MutableComponent text = Component.m_237115_((String)this.modeFilterList.get(i).getUnlocalisedTitle());
            text.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_178520_(color));
            this.f_96547_.m_92889_(stack, (Component)text, (float)textx, (float)(texty + offset), color);
            if ((offset += 10) > 190) break;
        }
    }

    public void renderModeListSetHotkey(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.updateCurrentHotKeys();
        this.pKey = this.findEmptyHotkey();
        int half_width = this.f_96543_ >> 1;
        int half_height = this.f_96544_ >> 1;
        int offset = 0;
        int textx = half_width - 100 + 2;
        int texty = half_height - 100 + 2;
        for (int i = 0; i < this.modeFilterList.size(); ++i) {
            MutableComponent text;
            int color = -1;
            if (i == this.selectedId) {
                color = this.hightlightTextColor;
            }
            int mode_id = this.modeFilterList.get(i).getIndex();
            int hotkey_indx = this.findHotkeyForMode(mode_id);
            int prefix_color = 0xFF6F00;
            if (i == this.selectedId) {
                boolean remove = false;
                prefix_color = 720707;
                if (hotkey_indx >= 0) {
                    prefix_color = 0xFF3636;
                    remove = true;
                }
                text = Component.m_237113_((String)(remove ? "- " : this.pKey + " "));
            } else if (hotkey_indx >= 0) {
                prefix_color = 0xFF6F00;
                text = Component.m_237113_((String)(hotkey_indx + " "));
            } else {
                text = Component.m_237113_((String)"  ");
            }
            text.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(prefix_color));
            MutableComponent title = Component.m_237115_((String)this.modeFilterList.get(i).getUnlocalisedTitle());
            title.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_178520_(color));
            text.m_7220_((Component)title);
            this.f_96547_.m_92889_(stack, (Component)text, (float)textx, (float)(texty + offset), color);
            if ((offset += 10) > 190) break;
        }
    }

    private void updateCurrentHotKeys() {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            this.hotkeysModeArr[i] = -1;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack == null) {
            return;
        }
        if (stack.m_41720_() != DoggyItems.WHISTLE.get()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        int[] list = tag.m_128465_("hotkey_modes");
        if (list == null) {
            return;
        }
        for (int i = 0; i < this.hotkeysModeArr.length && i < list.length; ++i) {
            this.hotkeysModeArr[i] = list[i];
        }
    }

    private int findEmptyHotkey() {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            if (this.hotkeysModeArr[i] >= 0) continue;
            return i;
        }
        return 3;
    }

    private int findHotkeyForMode(int mode_id) {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            if (this.hotkeysModeArr[i] != mode_id) continue;
            return i;
        }
        return -1;
    }

    private void sendHotKeyEdits(int hotkey_id, int mode_id) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhisltleEditHotKeyData(hotkey_id, mode_id));
    }

    private int getHoveredIndex(double x, double y, int entry_size) {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return -1;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return -1;
        }
        int baseY = mY - 100;
        int indx = Mth.m_14107_((double)(y - (double)baseY)) / 10;
        if (indx >= entry_size) {
            return -1;
        }
        return indx;
    }

    private void onMouseMoved(double x, double y) {
        int newIndx = this.getHoveredIndex(x, y, this.modeFilterList.size());
        if (newIndx < 0) {
            return;
        }
        this.selectedId = newIndx;
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        boolean ret = super.m_6375_(x, y, p_94697_);
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return ret;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return ret;
        }
        int indx = this.getHoveredIndex(x, y, this.modeFilterList.size());
        if (indx >= 0) {
            this.proccessSelectIndx(indx);
        }
        return ret;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 264) {
            this.selectedId = Mth.m_14045_((int)(this.selectedId + 1), (int)0, (int)(this.modeFilterList.size() - 1));
        } else if (keyCode == 265) {
            this.selectedId = Mth.m_14045_((int)(this.selectedId - 1), (int)0, (int)(this.modeFilterList.size() - 1));
        } else if (keyCode == 257) {
            if (this.modeFilterList.isEmpty()) {
                return false;
            }
            this.proccessSelectIndx(this.selectedId);
        } else if (keyCode == 259) {
            this.popCharInText();
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void proccessSelectIndx(int indx) {
        if (this.settingKeysMode) {
            int new_mode_id = this.modeFilterList.get(indx).getIndex();
            int send_key = this.pKey;
            int occupied_key = this.findHotkeyForMode(new_mode_id);
            if (occupied_key >= 0) {
                new_mode_id = -1;
                send_key = occupied_key;
            }
            this.sendHotKeyEdits(send_key, new_mode_id);
        } else {
            this.requestMode(this.modeFilterList.get(indx).getIndex());
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public boolean m_5534_(char code, int p_231042_2_) {
        if (SharedConstants.m_136188_((char)code)) {
            this.insertText(Character.toString(code));
            return true;
        }
        return false;
    }

    private void updateFilter() {
        this.modeFilterList.clear();
        this.selectedId = 0;
        if (this.value == "") {
            for (WhistleItem.WhistleMode i : WhistleItem.WhistleMode.VALUES) {
                this.modeFilterList.add(i);
            }
        } else {
            for (WhistleItem.WhistleMode i : WhistleItem.WhistleMode.VALUES) {
                String text = I18n.m_118938_((String)i.getUnlocalisedTitle(), (Object[])new Object[0]);
                if (text.length() < this.value.length() || !text.contains(this.value)) continue;
                this.modeFilterList.add(i);
            }
        }
    }

    private void insertText(String x) {
        if (this.value.length() < 64) {
            this.value = this.value + x;
        }
        this.updateFilter();
    }

    private void popCharInText() {
        if (this.value.length() <= 0) {
            return;
        }
        this.value = this.value.substring(0, this.value.length() - 1);
        this.updateFilter();
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void requestMode(int id) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhistleRequestModeData(id));
    }
}

