/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework;

import com.google.common.collect.Maps;
import doggytalents.client.screen.framework.AbstractSlice;
import doggytalents.client.screen.framework.CleanableSlice;
import doggytalents.client.screen.framework.StoreConnectedScreen;
import doggytalents.client.screen.framework.ToolTipOverlayManager;
import doggytalents.client.screen.framework.UIAction;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;

public class Store {
    private static Store INSTANCE;
    private final Screen screen;
    private final Map<Class<? extends AbstractSlice>, StoreValue> applicationStates = Maps.newConcurrentMap();

    private Store(Screen screen) {
        this.screen = screen;
        this.registerSlices();
        this.init();
    }

    private <T extends AbstractSlice> void registerSlice(Class<T> slice) {
        try {
            AbstractSlice worker = (AbstractSlice)slice.getConstructor(new Class[0]).newInstance(new Object[0]);
            StoreValue storeValue = new StoreValue(worker, worker.getInitalState());
            this.applicationStates.computeIfAbsent(slice, $ -> storeValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerSlices() {
        if (!(this.screen instanceof StoreConnectedScreen)) {
            return;
        }
        StoreConnectedScreen storeScr = (StoreConnectedScreen)this.screen;
        for (Class<? extends AbstractSlice> slice : storeScr.getSlices()) {
            this.registerSlice(slice);
        }
    }

    private void init() {
        for (Map.Entry<Class<? extends AbstractSlice>, StoreValue> x : this.applicationStates.entrySet()) {
            Object initState;
            x.getValue().state = initState = x.getValue().worker.getInitalState();
        }
    }

    public <T extends AbstractSlice> void dispatch(Class<T> slice, UIAction action, int widthAfter, int heightAfter) {
        StoreValue storeValue = this.applicationStates.get(slice);
        if (storeValue == null) {
            return;
        }
        storeValue.state = storeValue.worker.reducer(storeValue.state, action);
        this.screen.m_6575_(this.screen.getMinecraft(), widthAfter, heightAfter);
    }

    public <T extends AbstractSlice> void dispatch(Class<T> slice, UIAction action) {
        this.dispatch(slice, action, this.screen.f_96543_, this.screen.f_96544_);
    }

    public <T extends AbstractSlice> void dispatchAll(UIAction action, int widthAfter, int heightAfter) {
        for (Map.Entry<Class<? extends AbstractSlice>, StoreValue> entry : this.applicationStates.entrySet()) {
            StoreValue storeValue = entry.getValue();
            if (storeValue == null) {
                return;
            }
            storeValue.state = storeValue.worker.reducer(storeValue.state, action);
        }
        this.screen.m_6575_(this.screen.getMinecraft(), widthAfter, heightAfter);
    }

    public <T extends AbstractSlice> void dispatchAll(UIAction action) {
        this.dispatchAll(action, this.screen.f_96543_, this.screen.f_96544_);
    }

    public <T, S extends AbstractSlice> T getStateOrDefault(Class<S> slice, Class<T> cast, T defaultState) {
        StoreValue storeValue = this.applicationStates.get(slice);
        if (storeValue == null) {
            return defaultState;
        }
        if (cast.isInstance(storeValue.state)) {
            return cast.cast(storeValue.state);
        }
        return defaultState;
    }

    public static Store get(Screen screen) {
        if (INSTANCE == null) {
            INSTANCE = new Store(screen);
        } else if (screen != Store.INSTANCE.screen) {
            INSTANCE = new Store(screen);
        }
        return INSTANCE;
    }

    private static void cleanUpStaticCache() {
        if (INSTANCE == null) {
            return;
        }
        for (Map.Entry<Class<? extends AbstractSlice>, StoreValue> entry : Store.INSTANCE.applicationStates.entrySet()) {
            AbstractSlice slice = entry.getValue().worker;
            if (!(slice instanceof CleanableSlice)) continue;
            CleanableSlice cSlice = (CleanableSlice)slice;
            cSlice.cleanUpSlice();
        }
    }

    public static void finish() {
        Store.cleanUpStaticCache();
        INSTANCE = null;
        ToolTipOverlayManager.finish();
    }

    private static class StoreValue {
        public AbstractSlice worker;
        public Object state;

        public StoreValue(AbstractSlice worker, Object state) {
            this.worker = worker;
            this.state = state;
        }
    }
}

