/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.framework.types.TextType;
import doggytalents.client.screen.framework.widget.FlatButton;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class MultiLineFlatButton
extends FlatButton {
    private final int LINE_SPACING = 2;
    private final int PADDING_LEFT = 6;
    private List<Component> lines;
    private TextType.Align align = TextType.Align.MIDDLE;

    public MultiLineFlatButton(int x, int y, int width, int height, List<Component> lines, FlatButton.OnPress onPress) {
        super(x, y, width, height, (Component)Component.m_237119_(), onPress);
        this.lines = lines == null ? List.of() : lines;
    }

    public MultiLineFlatButton setTextAlign(TextType.Align align) {
        this.align = align;
        return this;
    }

    @Override
    public void m_87963_(PoseStack stack, int mouseX, int mouseY, float pTicks) {
        if (!this.f_93623_) {
            return;
        }
        int cl = this.f_93622_ ? -2090967715 : 1214143837;
        MultiLineFlatButton.m_93172_((PoseStack)stack, (int)this.m_252754_(), (int)this.m_252907_(), (int)(this.m_252754_() + this.f_93618_), (int)(this.m_252907_() + this.f_93619_), (int)cl);
        if (this.align == TextType.Align.LEFT) {
            this.drawLeft(stack);
        } else if (this.align == TextType.Align.MIDDLE) {
            this.drawCentered(stack);
        }
    }

    private void drawCentered(PoseStack stack) {
        int mX = this.m_252754_() + this.f_93618_ / 2;
        int mY = this.m_252907_() + this.f_93619_ / 2;
        int lines_cnt = this.lines.size();
        Objects.requireNonNull(this.font);
        int text_height = lines_cnt * 9 + (lines_cnt - 1) * 2;
        int pTY = mY - text_height / 2;
        for (Component line : this.lines) {
            int pTX = mX - this.font.m_92852_((FormattedText)line) / 2;
            this.font.m_92889_(stack, line, (float)pTX, (float)pTY, -1);
            Objects.requireNonNull(this.font);
            pTY += 9 + 2;
        }
    }

    private void drawLeft(PoseStack stack) {
        int mX = this.m_252754_() + this.f_93618_ / 2;
        int mY = this.m_252907_() + this.f_93619_ / 2;
        int lines_cnt = this.lines.size();
        Objects.requireNonNull(this.font);
        int text_height = lines_cnt * 9 + (lines_cnt - 1) * 2;
        int pTX = this.m_252754_() + 6;
        int pTY = mY - text_height / 2;
        for (Component line : this.lines) {
            this.font.m_92889_(stack, line, (float)pTX, (float)pTY, -1);
            Objects.requireNonNull(this.font);
            pTY += 9 + 2;
        }
    }

    private void drawRight(PoseStack stack) {
    }
}

