/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class DogBedTileEntity
extends PlacedTileEntity {
    private ICasingMaterial casingType = null;
    private IBeddingMaterial beddingType = null;
    public static ModelProperty<ICasingMaterial> CASING = new ModelProperty();
    public static ModelProperty<IBeddingMaterial> BEDDING = new ModelProperty();
    public static ModelProperty<Direction> FACING = new ModelProperty();
    @Deprecated
    @Nullable
    private Dog dog;
    @Nullable
    private UUID dogUUID;
    @Nullable
    private Component name;
    @Nullable
    private Component ownerName;

    public DogBedTileEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)DoggyTileEntityTypes.DOG_BED.get(), pos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.casingType = NBTUtil.getRegistryValue(compound, "casingId", DoggyTalentsAPI.CASING_MATERIAL.get());
        this.beddingType = NBTUtil.getRegistryValue(compound, "beddingId", DoggyTalentsAPI.BEDDING_MATERIAL.get());
        this.dogUUID = NBTUtil.getUniqueId(compound, "ownerId");
        this.name = NBTUtil.getTextComponent(compound, "name");
        this.ownerName = NBTUtil.getTextComponent(compound, "ownerName");
        this.requestModelDataUpdate();
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        NBTUtil.putRegistryValue(compound, "casingId", DoggyTalentsAPI.CASING_MATERIAL.get().getKey((Object)this.casingType));
        NBTUtil.putRegistryValue(compound, "beddingId", DoggyTalentsAPI.BEDDING_MATERIAL.get().getKey((Object)this.beddingType));
        NBTUtil.putUniqueId(compound, "ownerId", this.dogUUID);
        NBTUtil.putTextComponent(compound, "name", this.name);
        NBTUtil.putTextComponent(compound, "ownerName", this.ownerName);
    }

    public void setCasing(ICasingMaterial casingType) {
        this.casingType = casingType;
        this.m_6596_();
        this.requestModelDataUpdate();
    }

    public void setBedding(IBeddingMaterial beddingType) {
        this.beddingType = beddingType;
        this.m_6596_();
        this.requestModelDataUpdate();
    }

    public ICasingMaterial getCasing() {
        return this.casingType;
    }

    public IBeddingMaterial getBedding() {
        return this.beddingType;
    }

    public ModelData getModelData() {
        return ModelData.builder().with(CASING, (Object)this.casingType).with(BEDDING, (Object)this.beddingType).with(FACING, (Object)Direction.NORTH).build();
    }

    public void setOwner(@Nullable Dog owner) {
        this.setOwner(owner == null ? null : owner.m_20148_());
        this.dog = owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.dog = null;
        this.dogUUID = owner;
        this.m_6596_();
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.dogUUID;
    }

    @Nullable
    public Dog getOwner() {
        return WorldUtil.getCachedEntity(this.f_58857_, Dog.class, this.dog, this.dogUUID);
    }

    @Nullable
    public Component getBedName() {
        return this.name;
    }

    @Nullable
    public Component getOwnerName() {
        Component text;
        if (this.dogUUID == null || this.f_58857_ == null) {
            return null;
        }
        DogLocationData locData = DogLocationStorage.get(this.f_58857_).getData(this.dogUUID);
        if (locData != null && (text = locData.getName(this.f_58857_)) != null) {
            this.ownerName = text;
        }
        return this.ownerName;
    }

    public boolean shouldDisplayName(LivingEntity camera) {
        return true;
    }

    public void setBedName(@Nullable Component nameIn) {
        this.name = nameIn;
        this.m_6596_();
    }
}

