/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.feature.FoodHandler;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.util.InventoryUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class FoodBowlTileEntity
extends PlacedTileEntity
implements MenuProvider {
    private final ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            FoodBowlTileEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return FoodHandler.isFood(stack).isPresent();
        }
    };
    private final LazyOptional<ItemStackHandler> itemStackHandler = LazyOptional.of(() -> this.inventory);
    public int timeoutCounter;

    public FoodBowlTileEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)DoggyTileEntityTypes.FOOD_BOWL.get(), pos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128391_(this.inventory.serializeNBT());
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (!(blockEntity instanceof FoodBowlTileEntity)) {
            return;
        }
        FoodBowlTileEntity bowl = (FoodBowlTileEntity)blockEntity;
        if (++bowl.timeoutCounter < 5) {
            return;
        }
        List dogList = bowl.f_58857_.m_45976_(Dog.class, new AABB(pos).m_82377_(5.0, 5.0, 5.0));
        for (Dog dog : dogList) {
            if (!dog.isDoingFine()) continue;
            UUID placerId = bowl.getPlacerId();
            if (placerId != null && placerId.equals(dog.m_21805_()) && !dog.getBowlPos().isPresent()) {
                dog.setBowlPos(bowl.f_58858_);
            }
            if (!(dog.getDogHunger() < dog.getMaxHunger() / 2.0f)) continue;
            InventoryUtil.feedDogFrom(dog, null, (IItemHandlerModifiable)bowl.inventory);
        }
        bowl.timeoutCounter = 0;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemStackHandler;
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.doggytalents.food_bowl");
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerIn) {
        return new FoodBowlContainer(windowId, this.f_58857_, this.f_58858_, playerInventory, playerIn);
    }
}

