/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.common.data.DisplayInfoBuilder;
import doggytalents.common.util.Util;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DTAdvancementProvider
extends ForgeAdvancementProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public DTAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new DoggyAdvancementsSubProvider()));
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    public static class DoggyAdvancementsSubProvider
    implements ForgeAdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider registries, Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
            Advancement advancement = Advancement.Builder.m_138353_().m_138358_(DisplayInfoBuilder.create().icon((Supplier<? extends ItemLike>)DoggyItems.TRAINING_TREAT).frame(FrameType.TASK).translate("dog.root").background("stone.png").noToast().noAnnouncement().build()).m_138386_("tame_dog", (CriterionTriggerInstance)TameAnimalTrigger.TriggerInstance.m_68848_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)DoggyEntityTypes.DOG.get()).m_36662_())).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, Util.getResourcePath("default/tame_dog"));
            Advancement advancement1 = Advancement.Builder.m_138353_().m_138398_(advancement).m_138358_(DisplayInfoBuilder.create().icon((ItemLike)Items.f_42422_).frame(FrameType.TASK).translate("dog.level_talent").build()).m_138386_("level_talent", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50652_})).m_138389_(consumer, Util.getResourcePath("default/level_talent"));
            Advancement advancement2 = Advancement.Builder.m_138353_().m_138398_(advancement1).m_138358_(DisplayInfoBuilder.create().icon((Supplier<? extends ItemLike>)DoggyItems.TANTAN_CAPE).frame(FrameType.TASK).translate("dog.accessorise").build()).m_138386_("accessorise", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42427_})).m_138389_(consumer, Util.getResourcePath("default/accessorise"));
            Advancement advancement3 = Advancement.Builder.m_138353_().m_138398_(advancement2).m_138358_(DisplayInfoBuilder.create().icon((Supplier<? extends ItemLike>)DoggyItems.RADIO_COLLAR).frame(FrameType.TASK).translate("dog.radio_collar").build()).m_138386_("iron", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42416_})).m_138389_(consumer, Util.getResourcePath("default/radio_collar"));
        }
    }
}

