/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggySerializers;
import doggytalents.DoggyTags;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.enu.WetSource;
import doggytalents.api.feature.DataKey;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.feature.InteractHandler;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.screen.DogInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.artifacts.DoggyArtifact;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.DogMiningCautiousManager;
import doggytalents.common.entity.DogOwnerDistanceManager;
import doggytalents.common.entity.ai.BerserkerModeGoal;
import doggytalents.common.entity.ai.DogAvoidPushWhenIdleGoal;
import doggytalents.common.entity.ai.DogBegGoal;
import doggytalents.common.entity.ai.DogBreedGoal;
import doggytalents.common.entity.ai.DogEatFromChestDogGoal;
import doggytalents.common.entity.ai.DogFindWaterGoal;
import doggytalents.common.entity.ai.DogFloatGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoalDefeated;
import doggytalents.common.entity.ai.DogGoAwayFromFireGoal;
import doggytalents.common.entity.ai.DogGoRestOnBedGoalDefeated;
import doggytalents.common.entity.ai.DogHungryGoal;
import doggytalents.common.entity.ai.DogLowHealthGoal;
import doggytalents.common.entity.ai.DogMeleeAttackGoal;
import doggytalents.common.entity.ai.DogNearestToOwnerAttackableTargetGoal;
import doggytalents.common.entity.ai.DogOwnerHurtByTargetGoal;
import doggytalents.common.entity.ai.DogOwnerHurtTargetGoal;
import doggytalents.common.entity.ai.DogRandomStrollGoal;
import doggytalents.common.entity.ai.DogSitWhenOrderedGoal;
import doggytalents.common.entity.ai.DogWanderGoal;
import doggytalents.common.entity.ai.GuardModeGoal;
import doggytalents.common.entity.ai.nav.DogMoveControl;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.entity.ai.triggerable.DogTriggerableGoal;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.serializers.DimensionDependantArg;
import doggytalents.common.entity.stats.StatsTracker;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.network.packet.data.DogMountData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.BackwardsComp;
import doggytalents.common.util.Cache;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;

public class Dog
extends AbstractDog {
    private static final EntityDataAccessor<Optional<Component>> LAST_KNOWN_NAME = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135032_);
    private static final EntityDataAccessor<Byte> DOG_FLAGS = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> HUNGER_INT = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> CUSTOM_SKIN = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Byte> SIZE = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<ItemStack> BONE_VARIANT = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final Cache<EntityDataAccessor<List<AccessoryInstance>>> ACCESSORIES = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.ACCESSORY_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<List<TalentInstance>>> TALENTS = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.TALENT_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DogLevel>> DOG_LEVEL = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.DOG_LEVEL_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<EnumGender>> GENDER = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.GENDER_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<EnumMode>> MODE = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.MODE_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DimensionDependantArg<Optional<BlockPos>>>> DOG_BED_LOCATION = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.BED_LOC_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DimensionDependantArg<Optional<BlockPos>>>> DOG_BOWL_LOCATION = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.BED_LOC_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DogIncapacitatedMananger.IncapacitatedSyncState>> DOG_INCAP_SYNC_STATE = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.INCAP_SYNC_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<List<DoggyArtifactItem>>> ARTIFACTS = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.ARTIFACTS_SERIALIZER.get())));
    private final Cache<Integer> spendablePoints = Cache.make(this::getSpendablePointsInternal);
    private final List<IDogAlteration> alterations = new ArrayList<IDogAlteration>(4);
    private final List<IDogFoodHandler> foodHandlers = new ArrayList<IDogFoodHandler>(4);
    public final Map<Integer, Object> objects = new HashMap<Integer, Object>();
    private DogSkin clientSkin = DogSkin.CLASSICAL;
    private ArrayList<AccessoryInstance> clientAccessories = new ArrayList();
    public final StatsTracker statsTracker = new StatsTracker();
    public final DogOwnerDistanceManager dogOwnerDistanceManager = new DogOwnerDistanceManager(this);
    public final DogMiningCautiousManager dogMiningCautiousManager = new DogMiningCautiousManager(this);
    public final DogGroupsManager dogGroupsManager = new DogGroupsManager();
    public final DogIncapacitatedMananger incapacitatedMananger = new DogIncapacitatedMananger(this);
    protected final PathNavigation defaultNavigation;
    protected final MoveControl defaultMoveControl;
    protected TriggerableAction stashedAction;
    protected TriggerableAction activeAction;
    protected int delayedActionStart = 0;
    private int hungerTick;
    private int prevHungerTick;
    private int hungerSaturation;
    private int hungerSaturationHealingTick;
    private int healingTick;
    private int prevHealingTick;
    private float headRotationCourse;
    private float headRotationCourseOld;
    private WetSource wetSource;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private boolean wasInLava = false;
    private boolean shakeFire = false;
    private float radPerHealthDecrease;
    private float maxHealth0;
    protected boolean dogJumping;
    protected float jumpPower;
    protected boolean isDogSwimming;
    protected boolean isLowHunger;
    protected boolean isZeroHunger;
    protected int hungerDamageTick;
    private static final UUID HUNGER_MOVEMENT = UUID.fromString("50671f49-1dfd-4397-242b-78bb6b178115");

    public static final void initDataParameters() {
        ACCESSORIES.get();
        TALENTS.get();
        DOG_LEVEL.get();
        GENDER.get();
        MODE.get();
        DOG_BED_LOCATION.get();
        DOG_BOWL_LOCATION.get();
        DOG_INCAP_SYNC_STATE.get();
        ARTIFACTS.get();
    }

    public Dog(EntityType<? extends Dog> type, Level worldIn) {
        super(type, worldIn);
        this.m_7105_(false);
        this.setGender(EnumGender.random(this.m_217043_()));
        this.setLowHealthStrategy(LowHealthStrategy.STICK_TO_OWNER);
        this.f_21344_ = new DogPathNavigation(this, worldIn);
        this.f_21342_ = new DogMoveControl(this);
        this.defaultNavigation = this.f_21344_;
        this.defaultMoveControl = this.f_21342_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACCESSORIES.get(), new ArrayList());
        this.f_19804_.m_135372_(TALENTS.get(), new ArrayList());
        this.f_19804_.m_135372_(LAST_KNOWN_NAME, Optional.empty());
        this.f_19804_.m_135372_(DOG_FLAGS, (Object)0);
        this.f_19804_.m_135372_(GENDER.get(), (Object)EnumGender.UNISEX);
        this.f_19804_.m_135372_(MODE.get(), (Object)EnumMode.DOCILE);
        this.f_19804_.m_135372_(HUNGER_INT, (Object)Float.valueOf(60.0f));
        this.f_19804_.m_135372_(CUSTOM_SKIN, (Object)"");
        this.f_19804_.m_135372_(DOG_LEVEL.get(), (Object)new DogLevel(0, 0));
        this.f_19804_.m_135372_(DOG_INCAP_SYNC_STATE.get(), (Object)DogIncapacitatedMananger.IncapacitatedSyncState.NONE);
        this.f_19804_.m_135372_(SIZE, (Object)3);
        this.f_19804_.m_135372_(BONE_VARIANT, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ARTIFACTS.get(), new ArrayList(3));
        this.f_19804_.m_135372_(DOG_BED_LOCATION.get(), new DimensionDependantArg(() -> EntityDataSerializers.f_135039_));
        this.f_19804_.m_135372_(DOG_BOWL_LOCATION.get(), new DimensionDependantArg(() -> EntityDataSerializers.f_135039_));
    }

    protected void m_8099_() {
        int p = 1;
        this.f_21345_.m_25352_(p, (Goal)new DogFloatGoal(this));
        this.f_21345_.m_25352_(p, (Goal)new DogFindWaterGoal(this));
        this.f_21345_.m_25352_(p, (Goal)new DogAvoidPushWhenIdleGoal(this));
        this.f_21345_.m_25352_(++p, (Goal)new DogGoAwayFromFireGoal(this));
        this.f_21345_.m_25352_(++p, (Goal)new DogSitWhenOrderedGoal(this));
        this.f_21345_.m_25352_(++p, (Goal)new DogHungryGoal(this, 1.0, 2.0f));
        this.f_21345_.m_25352_(++p, (Goal)new DogLowHealthGoal.StickToOwner(this));
        this.f_21345_.m_25352_(p, (Goal)new DogLowHealthGoal.RunAway(this));
        this.f_21345_.m_25352_(++p, (Goal)new DogEatFromChestDogGoal(this, 1.0));
        this.f_21345_.m_25352_(p, (Goal)new DogTriggerableGoal(this, false));
        this.f_21345_.m_25352_(++p, (Goal)new GuardModeGoal.Minor(this));
        this.f_21345_.m_25352_(p, (Goal)new GuardModeGoal.Major(this));
        this.f_21345_.m_25352_(++p, (Goal)new DogMeleeAttackGoal(this, 1.0, true, 20, 40));
        this.f_21345_.m_25352_(p, (Goal)new DogWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(p, (Goal)new DogGoRestOnBedGoalDefeated(this));
        this.f_21345_.m_25352_(++p, (Goal)new DogTriggerableGoal(this, true));
        this.f_21345_.m_25352_(p, (Goal)new DogFollowOwnerGoalDefeated(this));
        this.f_21345_.m_25352_(p, (Goal)new DogFollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(++p, (Goal)new DogBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(++p, (Goal)new DogRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(++p, (Goal)new DogBegGoal(this, 8.0f));
        this.f_21345_.m_25352_(++p, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(p, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DogOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DogOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, new DogNearestToOwnerAttackableTargetGoal<AbstractSkeleton>(this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(6, (Goal)new BerserkerModeGoal(this));
        this.f_21346_.m_25352_(6, (Goal)new GuardModeGoal(this));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        if (this.isDefeated()) {
            return this.f_19796_.m_188503_(2) == 0 ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    @Override
    public float m_6121_() {
        return 0.4f;
    }

    public boolean isDogWet() {
        return this.wetSource != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float partialTicks) {
        return Math.min(0.5f + Mth.m_14179_((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) / 2.0f * 0.5f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float partialTicks, float offset) {
        float f = (Mth.m_14179_((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    public void m_7822_(byte id) {
        if (id == 8) {
            this.startShaking();
        } else if (id == 56) {
            this.finishShaking();
        } else {
            super.m_7822_(id);
        }
    }

    public float getTailRotation() {
        return this.m_21824_() ? 1.73f - this.radPerHealthDecrease * (this.m_21233_() - this.m_21223_()) : 0.62831855f;
    }

    @Override
    public float getWagAngle(float limbSwing, float limbSwingAmount, float partialTickTime) {
        return Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.8f;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public double m_6049_() {
        return this.m_20202_() instanceof Player ? 0.5 : 0.0;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            boolean inWater;
            this.headRotationCourseOld = this.headRotationCourse;
            this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
            if (this.m_21233_() != this.maxHealth0) {
                this.maxHealth0 = this.m_21233_();
                this.radPerHealthDecrease = 1.5707964f / this.maxHealth0;
            }
            boolean inRain = (inWater = this.m_20069_()) ? false : this.m_20070_();
            boolean inBubbleColumn = this.m_20072_();
            if (inWater || inRain || inBubbleColumn) {
                if (this.wetSource == null) {
                    this.wetSource = WetSource.of(inWater, inBubbleColumn, inRain);
                }
                if (this.isShaking && !this.f_19853_.f_46443_) {
                    this.finishShaking();
                    this.f_19853_.m_7605_((Entity)this, (byte)56);
                }
            } else if ((this.wetSource != null || this.isShaking) && this.isShaking) {
                if (this.timeWolfIsShaking == 0.0f && !this.shakeFire) {
                    this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
                this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
                this.timeWolfIsShaking += 0.05f;
                if (this.prevTimeWolfIsShaking >= 2.0f) {
                    if (this.wetSource != null) {
                        for (IDogAlteration alter2 : this.alterations) {
                            alter2.onShakingDry(this, this.wetSource);
                        }
                    }
                    this.wetSource = null;
                    this.finishShaking();
                }
                if (this.timeWolfIsShaking > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3d = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        if (this.shakeFire) {
                            byte r = (byte)this.m_217043_().m_188503_(3);
                            if (r == 0) {
                                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                                continue;
                            }
                            if (r == 1) {
                                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                                continue;
                            }
                            if (r != 2) continue;
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                            continue;
                        }
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                    }
                }
                if ((double)this.timeWolfIsShaking > 0.8 && this.shakeFire && this.f_19796_.m_188503_(6) == 0) {
                    this.m_5496_(SoundEvents.f_11937_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
            }
            if (!this.f_19853_.f_46443_ && this.f_19797_ % 40 == 0) {
                DogLocationStorage.get(this.f_19853_).getOrCreateData(this).update(this);
                LivingEntity owner = this.m_269323_();
                if (owner != null) {
                    this.setOwnersName(owner.m_7755_());
                }
            }
        }
        this.m_274367_(this.m_20160_() ? 1.0f : 0.6f);
        this.alterations.forEach(alter -> alter.tick(this));
        if (this.f_19853_.f_46443_) {
            this.proccessCustomModelSkin();
        }
    }

    private void proccessCustomModelSkin() {
        DogSkin skin = this.getClientSkin();
        if (!skin.useCustomModel()) {
            return;
        }
        DogModel<Dog> model = skin.getCustomModel().getValue();
        if (model.tickClient()) {
            model.doTickClient(this);
        }
    }

    public void m_8107_() {
        ResourceKey dimKey;
        Optional<BlockPos> bowlPos;
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.delayedActionStart > 0) {
            --this.delayedActionStart;
        }
        if (!this.f_19853_.f_46443_ && this.wetSource != null && !this.isShaking && !this.m_21691_() && this.m_20096_()) {
            this.startShakingAndBroadcast(false);
        }
        if (!this.f_19853_.f_46443_ && this.m_5825_()) {
            if (this.m_20077_()) {
                this.wasInLava = true;
            }
            if (this.wasInLava && !this.m_20077_() && !this.isShaking && !this.m_21691_() && this.m_20096_()) {
                this.startShakingAndBroadcast(true);
                this.wasInLava = false;
            }
        }
        if (!this.f_19853_.f_46443_ && !this.isDefeated()) {
            InteractionResultHolder<Integer> result;
            if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_HUNGER)).booleanValue()) {
                this.prevHungerTick = this.hungerTick++;
                if (this.m_20160_() || !this.m_21825_()) {
                    // empty if block
                }
                for (IDogAlteration alter2 : this.alterations) {
                    result = alter2.hungerTick(this, this.hungerTick - this.prevHungerTick);
                    if (!result.m_19089_().m_19080_()) continue;
                    this.hungerTick = (Integer)result.m_19095_() + this.prevHungerTick;
                }
                int tickPerDec = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.TICK_PER_HUNGER_DEC);
                if (this.hungerTick > tickPerDec) {
                    if (this.hungerSaturation > 0) {
                        --this.hungerSaturation;
                    } else {
                        this.setDogHunger(this.getDogHunger() - 1.0f);
                    }
                    this.hungerTick -= tickPerDec;
                }
                if (this.isZeroHunger) {
                    this.handleZeroHunger();
                }
            }
            if (this.hungerSaturation > 0 && this.m_21223_() < this.m_21233_() && --this.hungerSaturationHealingTick <= 0) {
                this.hungerSaturationHealingTick = 10;
                this.m_5634_(1.0f);
                this.hungerSaturation -= 3;
            }
            this.prevHealingTick = this.healingTick;
            this.healingTick += 8;
            if (this.m_21825_()) {
                this.healingTick += 4;
            }
            for (IDogAlteration alter2 : this.alterations) {
                result = alter2.healingTick(this, this.healingTick - this.prevHealingTick);
                if (!result.m_19089_().m_19080_()) continue;
                this.healingTick = (Integer)result.m_19095_() + this.prevHealingTick;
            }
            if (this.healingTick >= 6000) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(1.0f);
                }
                this.healingTick = 0;
            }
            this.dogOwnerDistanceManager.tick();
            this.dogMiningCautiousManager.tick();
        }
        if (this.f_19853_.f_46443_ && this.getDogLevel().isDireDog() && ((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.DIRE_PARTICLES)).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (this.f_19797_ % 50 == 0 && (bowlPos = this.getBowlPos((ResourceKey<Level>)(dimKey = this.f_19853_.m_46472_()))).isPresent() && this.f_19853_.m_46805_(bowlPos.get()) && !this.f_19853_.m_8055_(bowlPos.get()).m_60713_((Block)DoggyBlocks.FOOD_BOWL.get())) {
            this.setBowlPos((ResourceKey<Level>)dimKey, Optional.empty());
        }
        this.alterations.forEach(alter -> alter.livingTick(this));
        this.incapacitatedMananger.tick();
    }

    public TriggerableAction getTriggerableAction() {
        return this.activeAction;
    }

    public boolean triggerAction(TriggerableAction action) {
        if (this.activeAction == action) {
            return false;
        }
        if (action == null) {
            if (this.activeAction != null) {
                this.activeAction.onStop();
            }
            this.activeAction = null;
            if (this.stashedAction != null) {
                this.activeAction = this.stashedAction;
                this.stashedAction = null;
            }
            return false;
        }
        if (this.activeAction != null) {
            if (!this.activeAction.isTrivial()) {
                return false;
            }
            if (action.isTrivial()) {
                return false;
            }
        }
        if (this.m_21827_()) {
            if (this.forceSit()) {
                return false;
            }
            if (!action.canOverrideSit()) {
                return false;
            }
        }
        this.m_21839_(false);
        if (this.activeAction != null) {
            if (this.activeAction.canPause()) {
                if (this.stashedAction != null) {
                    this.stashedAction.onStop();
                }
                this.activeAction.setState(TriggerableAction.ActionState.PAUSED);
                this.stashedAction = this.activeAction;
            } else {
                this.activeAction.onStop();
            }
        }
        this.activeAction = action;
        return true;
    }

    public boolean isBusy() {
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.m_21825_() && this.forceSit()) {
            return true;
        }
        return this.activeAction != null;
    }

    public boolean readyForNonTrivialAction() {
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.m_21825_() && this.forceSit()) {
            return false;
        }
        if (this.activeAction == null) {
            return true;
        }
        return this.activeAction.isTrivial();
    }

    public TriggerableAction getStashedTriggerableAction() {
        return this.stashedAction;
    }

    public void clearTriggerableAction() {
        if (this.stashedAction != null) {
            this.stashedAction.onStop();
            this.stashedAction = null;
        }
        this.triggerAction(null);
    }

    public void setStashedTriggerableAction(TriggerableAction action) {
        if (action == this.stashedAction) {
            return;
        }
        if (this.stashedAction != null) {
            this.stashedAction.onStop();
        }
        this.stashedAction = action;
    }

    public boolean hasDelayedActionStart() {
        return this.delayedActionStart > 0;
    }

    public boolean triggerActionDelayed(int delay, TriggerableAction action) {
        boolean triggered = this.triggerAction(action);
        if (triggered) {
            this.delayedActionStart = delay;
        }
        return triggered;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Optional<IDogFoodHandler> foodHandler;
        ItemStack stack = player.m_21120_(hand);
        if (this.isDefeated()) {
            return this.incapacitatedMananger.interact(stack, player, hand);
        }
        if (this.m_21824_()) {
            if (stack.m_41720_() == Items.f_42398_) {
                if (this.f_19853_.f_46443_) {
                    boolean useLegacyDogGui = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.USE_LEGACY_DOGGUI);
                    if (this.canInteract((LivingEntity)player)) {
                        if (!useLegacyDogGui) {
                            DogNewInfoScreen.open(this);
                        } else {
                            DogInfoScreen.open(this);
                        }
                    } else if (!useLegacyDogGui) {
                        DogCannotInteractWithScreen.open(this);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == Items.f_42500_ || stack.m_41720_() == DoggyItems.TRAINING_TREAT.get()) {
            if (!this.f_19853_.f_46443_) {
                this.m_142075_(player, hand, stack);
                if (stack.m_41720_() == DoggyItems.TRAINING_TREAT.get() || this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    this.m_21153_(20.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if ((foodHandler = FoodHandler.getMatch(this, stack, (Entity)player)).isPresent()) {
            return foodHandler.get().consume(this, stack, (Entity)player);
        }
        InteractionResult interactResult = InteractHandler.getMatch(this, stack, player, hand);
        if (interactResult != InteractionResult.PASS) {
            return interactResult;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.processInteract(this, this.f_19853_, player, hand);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        InteractionResult actionresulttype = super.m_6071_(player, hand);
        if ((!actionresulttype.m_19077_() || this.m_6162_()) && this.canInteract((LivingEntity)player)) {
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (this.f_19853_.f_46443_) {
            this.displayToastIfNoPermission(player);
        }
        return actionresulttype;
    }

    private void displayToastIfNoPermission(Player player) {
        if (this.canInteract((LivingEntity)player)) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"doggui.invalid_dog.no_permission.title").m_130940_(ChatFormatting.RED), true);
    }

    public boolean m_275843_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBeRiddenInWater(this);
            if (result.m_19080_()) {
                return false;
            }
            if (result != InteractionResult.FAIL) continue;
            return true;
        }
        return super.m_275843_();
    }

    public void m_8127_() {
        if (!this.f_19853_.f_46443_) {
            Entity e0 = this.m_20202_();
            super.m_8127_();
            Entity e1 = this.m_20202_();
            if (e0 != e1 && e0 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)e0;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.m_19879_(), false));
            }
        } else {
            super.m_8127_();
        }
    }

    public boolean m_20329_(Entity entity) {
        if (!this.f_19853_.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.m_19879_(), true));
        }
        return super.m_20329_(entity);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canTrample(this, state, pos, fallDistance);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.onLivingFall(this, distance, damageMultiplier);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        int i = this.m_5639_(distance, damageMultiplier);
        if (i > 0) {
            if (this.m_20160_()) {
                for (Entity e : this.m_20197_()) {
                    e.m_6469_(this.m_269291_().m_268989_(), (float)i);
                }
            }
            this.m_5496_(i > 4 ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_(), 1.0f, 1.0f);
            this.m_21229_();
            this.m_6469_(this.m_269291_().m_268989_(), i);
            return true;
        }
        return false;
    }

    public int m_6056_() {
        return 3;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        MobEffectInstance effectInst = this.m_21124_(MobEffects.f_19603_);
        float f = effectInst == null ? 0.0f : (float)(effectInst.m_19564_() + 1);
        distance -= f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.calculateFallDistance(this, distance);
            if (!result.m_19089_().m_19080_()) continue;
            distance = ((Float)result.m_19095_()).floatValue();
            break;
        }
        return Mth.m_14167_((float)((distance - 3.0f - f) * damageMultiplier));
    }

    public boolean m_6040_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBreatheUnderwater(this);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_6040_();
    }

    protected int m_7302_(int air) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.decreaseAirSupply(this, air);
            if (!result.m_19089_().m_19080_()) continue;
            return (Integer)result.m_19095_();
        }
        return super.m_7302_(air);
    }

    protected int m_7305_(int currentAir) {
        currentAir += 4;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.determineNextAir(this, currentAir);
            if (!result.m_19089_().m_19080_()) continue;
            currentAir = (Integer)result.m_19095_();
            break;
        }
        return Math.min(currentAir, this.m_6062_());
    }

    public boolean m_6779_(LivingEntity target) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canAttack((AbstractDog)this, target);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof Creeper) {
            return false;
        }
        return super.m_6779_(target);
    }

    public boolean m_6549_(EntityType<?> entityType) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canAttack((AbstractDog)this, entityType);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (entityType == EntityType.f_20558_) {
            return false;
        }
        return super.m_6549_(entityType);
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldAttackEntity(this, target, owner);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof Creeper || target instanceof Ghast) {
            return false;
        }
        if (target instanceof Wolf) {
            Wolf wolfentity = (Wolf)target;
            return !wolfentity.m_21824_() || wolfentity.m_269323_() != owner;
        }
        if (target instanceof Dog) {
            Dog dogEntity = (Dog)target;
            return !dogEntity.m_21824_() || dogEntity.m_269323_() != owner;
        }
        if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
            return false;
        }
        if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity owner;
        boolean flag;
        Entity attacker = source.m_7639_();
        if (this.isDefeated() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            Mob mob;
            LivingEntity target;
            this.setDogHunger(0.0f);
            this.incapacitatedMananger.onHurt();
            if (attacker instanceof Mob && (target = (mob = (Mob)attacker).m_5448_()) == this) {
                mob.m_6710_(null);
            }
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.gettingAttackedFrom(this, source, amount);
            if (result.m_19089_() == InteractionResult.FAIL) {
                return false;
            }
            amount = ((Float)result.m_19095_()).floatValue();
        }
        if (this.m_6673_(source)) {
            return false;
        }
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && attacker instanceof Player) {
            return false;
        }
        if (!this.canOwnerAttack() && (flag = this.checkIfAttackedFromOwnerOrTeam(owner = this.m_269323_(), attacker))) {
            return false;
        }
        this.m_21839_(false);
        if (attacker != null && !(attacker instanceof Player) && !(attacker instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean checkIfAttackedFromOwnerOrTeam(LivingEntity owner, Entity attacker) {
        if (owner == null || attacker == null) {
            return false;
        }
        if (owner == attacker) {
            return true;
        }
        return attacker.m_7307_((Entity)owner);
    }

    public boolean m_7327_(Entity target) {
        boolean flag;
        AttributeInstance attackDamageInst = this.m_21051_(Attributes.f_22281_);
        AttributeInstance critDamageInst = this.m_21051_((Attribute)DoggyAttributes.CRIT_CHANCE.get());
        Set critModifiers = null;
        if (critDamageInst != null && critDamageInst.m_22135_() > this.m_217043_().m_188500_()) {
            AttributeInstance critBonusInst = this.m_21051_((Attribute)DoggyAttributes.CRIT_BONUS.get());
            Set set = critModifiers = critBonusInst == null ? null : critBonusInst.m_22122_();
            if (critModifiers != null && attackDamageInst != null) {
                critModifiers.forEach(arg_0 -> ((AttributeInstance)attackDamageInst).m_22118_(arg_0));
            }
        }
        int damage = (int)(attackDamageInst == null ? 0.0 : attackDamageInst.m_22135_());
        ItemStack stack = this.m_21205_();
        if (target instanceof LivingEntity && stack != null) {
            damage = (int)((float)damage + EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)target).m_6336_()));
        }
        if (critModifiers != null && attackDamageInst != null) {
            critModifiers.forEach(arg_0 -> ((AttributeInstance)attackDamageInst).m_22130_(arg_0));
        }
        if (!(flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)damage))) {
            return false;
        }
        this.m_19970_((LivingEntity)this, target);
        this.statsTracker.increaseDamageDealt(damage);
        if (critModifiers != null) {
            ParticlePackets.CritEmitterPacket.sendCritEmitterPacketToNearClients(target);
            this.m_5496_(SoundEvents.f_12313_, 0.5f, 1.0f);
        }
        for (IDogAlteration alter : this.alterations) {
            alter.doAdditionalAttackEffects(this, target);
        }
        return true;
    }

    public void m_19970_(LivingEntity dog, Entity target) {
        int i = EnchantmentHelper.m_44914_((LivingEntity)this);
        if (i > 0) {
            target.m_20254_(i * 4);
        }
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        if ((knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)this)) > 0.0f && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
        }
        super.m_19970_(dog, target);
    }

    public void m_5993_(Entity killed, int scoreValue, DamageSource damageSource) {
        super.m_5993_(killed, scoreValue, damageSource);
        this.statsTracker.incrementKillCount(killed);
    }

    public boolean m_21275_(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBlockDamageSource(this, source);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_21275_(source);
    }

    public boolean m_142066_() {
        return !this.isDefeated() && super.m_142066_();
    }

    public void m_20254_(int second) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.setFire(this, second);
            if (!result.m_19089_().m_19080_()) continue;
            second = (Integer)result.m_19095_();
        }
        super.m_20254_(second);
    }

    public boolean m_5825_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isImmuneToFire(this);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_5825_();
    }

    public boolean m_6673_(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isInvulnerableTo(this, source);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_6673_(source);
    }

    public boolean m_20147_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isInvulnerable(this);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_20147_();
    }

    public boolean m_7301_(MobEffectInstance effectIn) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isPotionApplicable(this, effectIn);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_7301_(effectIn);
    }

    public boolean m_6573_(Player player) {
        return this.canInteract((LivingEntity)player) && super.m_6573_(player);
    }

    public void m_20084_(UUID uniqueIdIn) {
        UUID oldUniqueId = this.m_20148_();
        if (uniqueIdIn.equals(oldUniqueId)) {
            return;
        }
        super.m_20084_(uniqueIdIn);
        if (!this.isAddedToWorld()) {
            return;
        }
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            DogLocationStorage.get(this.f_19853_).remove(oldUniqueId);
            DogLocationStorage.get(this.f_19853_).getOrCreateData(this).update(this);
        }
    }

    public void m_21828_(Player player) {
        super.m_21828_(player);
        this.setOwnersName(player.m_7755_());
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public void m_21816_(@Nullable UUID uuid) {
        super.m_21816_(uuid);
        if (uuid == null) {
            this.setOwnersName((Component)null);
        }
    }

    public boolean m_7313_(Entity entityIn) {
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && entityIn instanceof Player) {
            return true;
        }
        if (!this.canOwnerAttack() && this.checkIfAttackedFromOwnerOrTeam(this.m_269323_(), entityIn)) {
            return true;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldSkipAttackFrom(this, entityIn);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)DoggyItems.DOGGY_CHARM.get());
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(DoggyTags.BREEDING_ITEMS);
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (this.isDefeated()) {
            return false;
        }
        if (otherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(otherAnimal instanceof Dog)) {
            return false;
        }
        Dog entitydog = (Dog)otherAnimal;
        if (!entitydog.m_21824_()) {
            return false;
        }
        if (entitydog.m_21825_()) {
            return false;
        }
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GENDER)).booleanValue() && !this.getGender().canMateWith(entitydog.getGender())) {
            return false;
        }
        return !entitydog.isDefeated() && this.m_27593_() && entitydog.m_27593_();
    }

    public AgeableMob m_142606_(ServerLevel worldIn, AgeableMob partner) {
        Dog child = (Dog)((EntityType)DoggyEntityTypes.DOG.get()).m_20615_((Level)worldIn);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            child.m_21816_(uuid);
            child.m_7105_(true);
        }
        if (partner instanceof Dog && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PUPS_GET_PARENT_LEVELS)).booleanValue()) {
            child.setLevel(this.getDogLevel().combine(((Dog)partner).getDogLevel()));
        }
        return child;
    }

    public boolean m_6052_() {
        return this.m_8077_() || super.m_6052_();
    }

    public float m_6134_() {
        if (this.m_6162_()) {
            return 0.5f;
        }
        return (float)this.getDogSize() * 0.3f + 0.1f;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.alterations == null) {
            return super.getCapability(cap, side);
        }
        for (IDogAlteration alter : this.alterations) {
            LazyOptional<T> result = alter.getCapability(this, cap, side);
            if (result == null) continue;
            return result;
        }
        return super.getCapability(cap, side);
    }

    public Entity changeDimension(ServerLevel worldIn, ITeleporter teleporter) {
        boolean flag = (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.ALL_DOG_BLOCK_PORTAL);
        if (flag) {
            return null;
        }
        Entity transportedEntity = super.changeDimension(worldIn, teleporter);
        if (transportedEntity instanceof Dog) {
            DogLocationStorage.get(this.f_19853_).getOrCreateData(this).update((Dog)transportedEntity);
        }
        return transportedEntity;
    }

    public void onRemovedFromWorld() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            DogLocationData data;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_6084_() && (data = DogLocationStorage.get((Level)serverLevel).getData(this)) != null) {
                data.update(this);
            }
        }
        super.onRemovedFromWorld();
        for (IDogAlteration x : this.alterations) {
            x.remove(this);
        }
    }

    public void onAddedToWorld() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            DogLocationData data;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_6084_() && (data = DogLocationStorage.get((Level)serverLevel).getOrCreateData(this)) != null) {
                data.update(this);
            }
        }
        super.onAddedToWorld();
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        if (!(removalReason != Entity.RemovalReason.DISCARDED && removalReason != Entity.RemovalReason.KILLED || this.f_19853_ == null || this.f_19853_.f_46443_)) {
            DogLocationStorage.get(this.f_19853_).remove(this);
            if (this.m_21805_() != null) {
                DogRespawnStorage.get(this.f_19853_).putData(this);
            }
        }
    }

    protected void m_6153_() {
        if (this.f_20919_ != 19 || this.f_19853_ == null || !this.f_19853_.f_46443_) {
            // empty if block
        }
        super.m_6153_();
    }

    private void startShaking() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingAndBroadcast(boolean shakeFire) {
        if (this.isShaking) {
            return;
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (shakeFire) {
            this.startShakingLava();
            ParticlePackets.DogStartShakingLavaPacket.sendDogStartShakingLavaPacketToNearByClients(this);
            return;
        }
        this.startShaking();
        this.f_19853_.m_7605_((Entity)this, (byte)8);
    }

    private void finishShaking() {
        this.isShaking = false;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingLava() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = true;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public boolean isShakingLava() {
        return this.isShaking && this.shakeFire;
    }

    public void m_6667_(DamageSource cause) {
        if (this.checkAndHandleIncapacitated(cause)) {
            return;
        }
        this.wetSource = null;
        this.finishShaking();
        this.alterations.forEach(alter -> alter.onDeath(this, cause));
        super.m_6667_(cause);
    }

    private boolean checkAndHandleIncapacitated(DamageSource cause) {
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.IMMORTAL_DOGS)).booleanValue()) {
            return false;
        }
        if (cause.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (this.m_21805_() == null) {
            return false;
        }
        this.handleIncapacitated(cause);
        return true;
    }

    private void handleIncapacitated(DamageSource source) {
        this.m_21153_(1.0f);
        this.setMode(EnumMode.INCAPACITATED);
        this.setDogHunger(0.0f);
        this.incapacitatedMananger.onBeingDefeated();
        this.m_19877_();
        this.createIncapSyncState(source);
        LivingEntity owner = this.m_269323_();
        if (owner != null) {
            this.sendIncapacitatedMsg(owner, source);
        }
        this.removeAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT);
    }

    private void sendIncapacitatedMsg(LivingEntity owner, DamageSource source) {
        MutableComponent msg = source.m_6157_((LivingEntity)this).m_6881_();
        String genderStr = Component.m_237115_((String)this.getGender().getUnlocalisedSubject()).getString();
        String msg005 = ". " + genderStr.substring(0, 1).toUpperCase() + genderStr.substring(1) + " ";
        MutableComponent msg01 = Component.m_237110_((String)"dog.mode.incapacitated.msg.partition1", (Object[])new Object[]{Component.m_237113_((String)msg005), Component.m_237115_((String)EnumMode.INCAPACITATED.getUnlocalisedName()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(14025732))});
        msg.m_7220_((Component)msg01);
        owner.m_213846_((Component)msg);
    }

    private void createIncapSyncState(DamageSource source) {
        DogIncapacitatedMananger.DefeatedType type = source.m_269533_(DamageTypeTags.f_268745_) ? DogIncapacitatedMananger.DefeatedType.BURN : (source.m_276093_(DamageTypes.f_268515_) ? DogIncapacitatedMananger.DefeatedType.POISON : DogIncapacitatedMananger.DefeatedType.BLOOD);
        this.setIncapSyncState(new DogIncapacitatedMananger.IncapacitatedSyncState(type));
    }

    public void m_5907_() {
        super.m_5907_();
        this.alterations.forEach(alter -> alter.dropInventory(this));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.alterations.forEach(alter -> alter.invalidateCapabilities(this));
    }

    public void m_7380_(CompoundTag compound) {
        DimensionDependantArg bowlsData;
        super.m_7380_(compound);
        ListTag talentList = new ListTag();
        List<TalentInstance> talents = this.getTalentMap();
        for (int i = 0; i < talents.size(); ++i) {
            CompoundTag talentTag = new CompoundTag();
            talents.get(i).writeInstance(this, talentTag);
            talentList.add((Object)talentTag);
        }
        compound.m_128365_("talents", (Tag)talentList);
        ListTag accessoryList = new ListTag();
        List<AccessoryInstance> accessories = this.getAccessories();
        for (int i = 0; i < accessories.size(); ++i) {
            CompoundTag accessoryTag = new CompoundTag();
            accessories.get(i).writeInstance(accessoryTag);
            accessoryList.add((Object)accessoryTag);
        }
        compound.m_128365_("accessories", (Tag)accessoryList);
        ListTag artifactsListTag = new ListTag();
        List<DoggyArtifactItem> artifacts = this.getArtifactsList();
        for (DoggyArtifactItem x : artifacts) {
            CompoundTag artifactTag = DoggyArtifactItem.writeCompound(x);
            if (artifactTag == null) continue;
            artifactsListTag.add((Object)artifactTag);
        }
        compound.m_128365_("doggy_artifacts", (Tag)artifactsListTag);
        compound.m_128359_("mode", this.getMode().getSaveName());
        compound.m_128359_("dogGender", this.getGender().getSaveName());
        compound.m_128350_("dogHunger", this.getDogHunger());
        this.getOwnersName().ifPresent(comp -> NBTUtil.putTextComponent(compound, "lastKnownOwnerName", comp));
        compound.m_128359_("customSkinHash", this.getSkinHash());
        compound.m_128379_("willObey", this.willObeyOthers());
        compound.m_128379_("friendlyFire", this.canOwnerAttack());
        compound.m_128379_("regardTeamPlayers", this.regardTeamPlayers());
        compound.m_128379_("forceSit", this.forceSit());
        compound.m_128344_("lowHealthStrategy", this.getLowHealthStrategy().getId());
        compound.m_128379_("crossOriginTp", this.crossOriginTp());
        compound.m_128405_("dogSize", this.getDogSize());
        compound.m_128405_("level_normal", this.getDogLevel().getLevel(DogLevel.Type.NORMAL));
        compound.m_128405_("level_dire", this.getDogLevel().getLevel(DogLevel.Type.DIRE));
        NBTUtil.writeItemStack(compound, "fetchItem", this.getBoneVariant());
        DimensionDependantArg bedsData = (DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get());
        if (!bedsData.isEmpty()) {
            ListTag bedsList = new ListTag();
            for (Map.Entry entry : bedsData.entrySet()) {
                CompoundTag bedNBT = new CompoundTag();
                NBTUtil.putResourceLocation(bedNBT, "dim", ((ResourceKey)entry.getKey()).m_135782_());
                NBTUtil.putBlockPos(bedNBT, "pos", (Optional)entry.getValue());
                bedsList.add((Object)bedNBT);
            }
            compound.m_128365_("beds", (Tag)bedsList);
        }
        if (!(bowlsData = (DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).isEmpty()) {
            ListTag bowlsList = new ListTag();
            for (Map.Entry entry : bowlsData.entrySet()) {
                CompoundTag bowlsNBT = new CompoundTag();
                NBTUtil.putResourceLocation(bowlsNBT, "dim", entry.getKey().m_135782_());
                NBTUtil.putBlockPos(bowlsNBT, "pos", (Optional)entry.getValue());
                bowlsList.add((Object)bowlsNBT);
            }
            compound.m_128365_("bowls", (Tag)bowlsList);
        }
        this.statsTracker.writeAdditional(compound);
        this.dogOwnerDistanceManager.save(compound);
        this.alterations.forEach(alter -> alter.onWrite(this, compound));
        this.dogGroupsManager.save(compound);
        if (this.isDefeated()) {
            this.incapacitatedMananger.save(compound);
        }
        compound.m_128473_("HandItems");
        compound.m_128473_("ArmorItems");
    }

    /*
     * Exception decompiling
     */
    public void m_20258_(CompoundTag compound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$TooOptimisticMatchException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.getString(SwitchStringRewriter.java:404)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.access$600(SwitchStringRewriter.java:53)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$SwitchStringMatchResultCollector.collectMatches(SwitchStringRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.KleeneN.match(KleeneN.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchSequence.match(MatchSequence.java:26)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:23)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewriteComplex(SwitchStringRewriter.java:201)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewrite(SwitchStringRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:881)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ArrayList<TalentInstance> newTlInstLs = new ArrayList<TalentInstance>();
        if (compound.m_128425_("talents", 9)) {
            ListTag talentList = compound.m_128437_("talents", 10);
            for (int i = 0; i < talentList.size(); ++i) {
                TalentInstance.readInstance(this, talentList.m_128728_(i)).ifPresent(newTlInstLs::add);
            }
        } else {
            BackwardsComp.readTalentMapping(compound, newTlInstLs);
        }
        this.f_19804_.m_135381_(TALENTS.get(), newTlInstLs);
        ArrayList<AccessoryInstance> newAccInstLs = new ArrayList<AccessoryInstance>();
        if (compound.m_128425_("accessories", 9)) {
            ListTag accessoryList = compound.m_128437_("accessories", 10);
            for (int i = 0; i < accessoryList.size(); ++i) {
                AccessoryInstance.readInstance(accessoryList.m_128728_(i)).ifPresent(newAccInstLs::add);
            }
        } else {
            BackwardsComp.readAccessories(compound, newAccInstLs);
        }
        this.f_19804_.m_135381_(ACCESSORIES.get(), newAccInstLs);
        ArrayList<DoggyArtifactItem> artifactsList = new ArrayList<DoggyArtifactItem>(3);
        if (compound.m_128425_("doggy_artifacts", 9)) {
            ListTag artifactsListTag = compound.m_128437_("doggy_artifacts", 10);
            for (int i = 0; i < artifactsListTag.size(); ++i) {
                DoggyArtifactItem artifactItem = DoggyArtifactItem.readCompound(artifactsListTag.m_128728_(i));
                if (artifactItem == null) continue;
                artifactsList.add(artifactItem);
            }
        }
        this.f_19804_.m_135381_(ARTIFACTS.get(), artifactsList);
        try {
            this.recalculateAlterations();
            this.spendablePoints.markForRefresh();
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to init alteration: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.setGender(EnumGender.bySaveName(compound.m_128461_("dogGender")));
            if (compound.m_128425_("mode", 8)) {
                this.setMode(EnumMode.bySaveName(compound.m_128461_("mode")));
            } else {
                BackwardsComp.readMode(compound, this::setMode);
            }
            if (compound.m_128425_("customSkinHash", 8)) {
                this.setSkinHash(compound.m_128461_("customSkinHash"));
            } else {
                BackwardsComp.readDogTexture(compound, this::setSkinHash);
            }
            if (compound.m_128425_("fetchItem", 10)) {
                this.setBoneVariant(NBTUtil.readItemStack(compound, "fetchItem"));
            } else {
                BackwardsComp.readHasBone(compound, this::setBoneVariant);
            }
            this.setHungerDirectly(compound.m_128457_("dogHunger"));
            this.setOwnersName(NBTUtil.getTextComponent(compound, "lastKnownOwnerName"));
            this.setWillObeyOthers(compound.m_128471_("willObey"));
            this.setCanPlayersAttack(compound.m_128471_("friendlyFire"));
            this.setRegardTeamPlayers(compound.m_128471_("regardTeamPlayers"));
            this.setForceSit(compound.m_128471_("forceSit"));
            this.setCrossOriginTp(compound.m_128471_("crossOriginTp"));
            byte low_health_strategy_id = compound.m_128445_("lowHealthStrategy");
            this.setLowHealthStrategy(LowHealthStrategy.fromId(low_health_strategy_id));
            if (compound.m_128425_("dogSize", 99)) {
                this.setDogSize(compound.m_128451_("dogSize"));
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            int level_normal = 0;
            int level_dire = 0;
            if (compound.m_128425_("level_normal", 99)) {
                level_normal = compound.m_128451_("level_normal");
            }
            if (compound.m_128425_("level_dire", 99)) {
                level_dire = compound.m_128451_("level_dire");
            }
            this.f_19804_.m_135381_(DOG_LEVEL.get(), (Object)new DogLevel(level_normal, level_dire));
            float h = this.getDogLevel().getMaxHealth();
            this.m_21051_(Attributes.f_22276_).m_22100_((double)h);
            this.m_21153_(h);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        DimensionDependantArg<Optional<BlockPos>> bedsData = ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).copyEmpty();
        try {
            if (compound.m_128425_("beds", 9)) {
                ListTag bedsList = compound.m_128437_("beds", 10);
                for (int i = 0; i < bedsList.size(); ++i) {
                    CompoundTag bedNBT = bedsList.m_128728_(i);
                    ResourceLocation loc = NBTUtil.getResourceLocation(bedNBT, "dim");
                    ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bedNBT, "pos");
                    bedsData.put((ResourceKey<Level>)type, pos);
                }
            } else {
                BackwardsComp.readBedLocations(compound, bedsData);
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load beds: " + e.getMessage());
            e.printStackTrace();
        }
        this.f_19804_.m_135381_(DOG_BED_LOCATION.get(), bedsData);
        DimensionDependantArg<Optional<BlockPos>> bowlsData = ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).copyEmpty();
        try {
            if (compound.m_128425_("bowls", 9)) {
                ListTag bowlsList = compound.m_128437_("bowls", 10);
                for (int i = 0; i < bowlsList.size(); ++i) {
                    CompoundTag bowlsNBT = bowlsList.m_128728_(i);
                    ResourceLocation loc = NBTUtil.getResourceLocation(bowlsNBT, "dim");
                    ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bowlsNBT, "pos");
                    bowlsData.put((ResourceKey<Level>)type, pos);
                }
            } else {
                BackwardsComp.readBowlLocations(compound, bowlsData);
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load bowls: " + e.getMessage());
            e.printStackTrace();
        }
        this.f_19804_.m_135381_(DOG_BOWL_LOCATION.get(), bowlsData);
        try {
            this.statsTracker.readAdditional(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load stats tracker: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.dogOwnerDistanceManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load owner distance manager: " + e.getMessage());
            e.printStackTrace();
        }
        this.alterations.forEach(alter -> {
            try {
                alter.onRead(this, compound);
            }
            catch (Exception e) {
                DoggyTalentsNext.LOGGER.error("Failed to load alteration: " + e.getMessage());
                e.printStackTrace();
            }
        });
        try {
            this.dogGroupsManager.load(compound);
            if (this.isDefeated()) {
                this.incapacitatedMananger.load(compound);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TALENTS.get().equals(key) || ACCESSORIES.get().equals(key) || ARTIFACTS.get().equals(key)) {
            this.recalculateAlterations();
        }
        if (TALENTS.get().equals(key)) {
            this.spendablePoints.markForRefresh();
        }
        if (DOG_LEVEL.get().equals(key)) {
            this.spendablePoints.markForRefresh();
        }
        if (ACCESSORIES.get().equals(key) && this.f_19853_.f_46443_) {
            this.clientAccessories = new ArrayList<AccessoryInstance>(this.getAccessories());
            this.clientAccessories.sort(AccessoryInstance.RENDER_SORTER);
        }
        if (SIZE.equals(key)) {
            this.m_6210_();
        }
        if (this.f_19853_.f_46443_ && CUSTOM_SKIN.equals(key)) {
            this.setClientSkin(DogTextureManager.INSTANCE.getLocFromHashOrGet((String)this.f_19804_.m_135370_(CUSTOM_SKIN), DogTextureManager.INSTANCE::getCached));
        }
    }

    public void recalculateAlterations() {
        for (IDogAlteration iDogAlteration : this.alterations) {
            iDogAlteration.remove(this);
        }
        this.alterations.clear();
        this.foodHandlers.clear();
        for (AccessoryInstance accessoryInstance : this.getAccessories()) {
            if (accessoryInstance instanceof IDogAlteration) {
                this.alterations.add((IDogAlteration)((Object)accessoryInstance));
            }
            if (!(accessoryInstance instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)accessoryInstance));
        }
        List<TalentInstance> talents = this.getTalentMap();
        this.alterations.addAll(talents);
        for (TalentInstance inst : talents) {
            if (!(inst instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst));
        }
        List<DoggyArtifactItem> list = this.getArtifactsList();
        for (DoggyArtifactItem artifactItem : list) {
            DoggyArtifact artifact = artifactItem.createArtifact();
            this.alterations.add(artifact);
        }
        for (IDogAlteration inst : this.alterations) {
            inst.init(this);
        }
    }

    @Override
    public boolean canInteract(LivingEntity livingEntity) {
        if (!this.isDoingFine()) {
            return false;
        }
        return this.willObeyOthers() || this.m_21830_(livingEntity);
    }

    @Override
    public List<AccessoryInstance> getAccessories() {
        return (List)this.f_19804_.m_135370_(ACCESSORIES.get());
    }

    @Override
    public boolean addAccessory(@Nonnull AccessoryInstance accessoryInst) {
        List<AccessoryInstance> accessories = this.getAccessories();
        AccessoryType type = accessoryInst.getAccessory().getType();
        List filtered = accessories.stream().filter(inst -> type == inst.getAccessory().getType()).collect(Collectors.toList());
        if (filtered.size() >= type.numberToPutOn()) {
            return false;
        }
        accessories.add(accessoryInst);
        this.markDataParameterDirty(ACCESSORIES.get());
        return true;
    }

    @Override
    public List<AccessoryInstance> removeAccessories() {
        ArrayList<AccessoryInstance> removed = new ArrayList<AccessoryInstance>(this.getAccessories());
        this.getAccessories().clear();
        this.markDataParameterDirty(ACCESSORIES.get());
        return removed;
    }

    public Optional<AccessoryInstance> getAccessory(AccessoryType typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory().getType() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<AccessoryInstance> getAccessory(Accessory typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<Component> getOwnersName() {
        return (Optional)this.f_19804_.m_135370_(LAST_KNOWN_NAME);
    }

    public void setOwnersName(@Nullable Component comp) {
        this.setOwnersName(Optional.ofNullable(comp));
    }

    public void setOwnersName(Optional<Component> collar) {
        this.f_19804_.m_135381_(LAST_KNOWN_NAME, collar);
    }

    public EnumGender getGender() {
        return (EnumGender)((Object)this.f_19804_.m_135370_(GENDER.get()));
    }

    public void setGender(EnumGender collar) {
        this.f_19804_.m_135381_(GENDER.get(), (Object)collar);
    }

    @Override
    public EnumMode getMode() {
        return (EnumMode)((Object)this.f_19804_.m_135370_(MODE.get()));
    }

    public boolean isMode(EnumMode ... modes) {
        EnumMode mode = this.getMode();
        for (EnumMode test : modes) {
            if (mode != test) continue;
            return true;
        }
        return false;
    }

    public void setMode(EnumMode collar) {
        this.f_19804_.m_135381_(MODE.get(), (Object)collar);
    }

    public Optional<BlockPos> getBedPos() {
        return this.getBedPos((ResourceKey<Level>)this.f_19853_.m_46472_());
    }

    public Optional<BlockPos> getBedPos(ResourceKey<Level> registryKey) {
        return ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).getOrDefault(registryKey, Optional.empty());
    }

    public void setBedPos(@Nullable BlockPos pos) {
        this.setBedPos((ResourceKey<Level>)this.f_19853_.m_46472_(), pos);
    }

    public void setBedPos(ResourceKey<Level> registryKey, @Nullable BlockPos pos) {
        this.setBedPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBedPos(ResourceKey<Level> registryKey, Optional<BlockPos> pos) {
        this.f_19804_.m_135381_(DOG_BED_LOCATION.get(), ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).copy().set(registryKey, pos));
    }

    public Optional<BlockPos> getBowlPos() {
        return this.getBowlPos((ResourceKey<Level>)this.f_19853_.m_46472_());
    }

    public Optional<BlockPos> getBowlPos(ResourceKey<Level> registryKey) {
        return ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).getOrDefault(registryKey, Optional.empty());
    }

    public void setBowlPos(@Nullable BlockPos pos) {
        this.setBowlPos((ResourceKey<Level>)this.f_19853_.m_46472_(), pos);
    }

    public void setBowlPos(ResourceKey<Level> registryKey, @Nullable BlockPos pos) {
        this.setBowlPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBowlPos(ResourceKey<Level> registryKey, Optional<BlockPos> pos) {
        this.f_19804_.m_135381_(DOG_BOWL_LOCATION.get(), ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).copy().set(registryKey, pos));
    }

    @Override
    public float getMaxHunger() {
        float maxHunger = 120.0f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.getMaxHunger(this, maxHunger);
            if (!result.m_19089_().m_19080_()) continue;
            maxHunger = ((Float)result.m_19095_()).floatValue();
        }
        return maxHunger;
    }

    @Override
    public float getDogHunger() {
        return ((Float)this.f_19804_.m_135370_(HUNGER_INT)).floatValue();
    }

    @Override
    public void addHunger(float add) {
        float h0 = this.getDogHunger();
        float h1 = h0 + add;
        int h2 = (int)(h1 - this.getMaxHunger());
        if (h2 > 0) {
            this.hungerSaturation = h2;
        }
        this.setDogHunger(h0 + add);
    }

    @Override
    public void setDogHunger(float hunger) {
        float diff = hunger - this.getDogHunger();
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.setDogHunger(this, hunger, diff);
            if (!result.m_19089_().m_19080_()) continue;
            hunger = ((Float)result.m_19095_()).floatValue();
            diff = hunger - this.getDogHunger();
        }
        this.setHungerDirectly(Mth.m_14036_((float)hunger, (float)0.0f, (float)this.getMaxHunger()));
    }

    private void setHungerDirectly(float hunger) {
        this.f_19804_.m_135381_(HUNGER_INT, (Object)Float.valueOf(hunger));
        this.updateLowHunger();
    }

    public boolean hasCustomSkin() {
        return !Strings.isNullOrEmpty((String)this.getSkinHash());
    }

    public String getSkinHash() {
        return (String)this.f_19804_.m_135370_(CUSTOM_SKIN);
    }

    public void setSkinHash(String hash) {
        if (hash == null) {
            hash = "";
        }
        this.f_19804_.m_135381_(CUSTOM_SKIN, (Object)hash);
    }

    @Override
    public DogLevel getDogLevel() {
        return (DogLevel)this.f_19804_.m_135370_(DOG_LEVEL.get());
    }

    public void setLevel(DogLevel level) {
        this.f_19804_.m_135381_(DOG_LEVEL.get(), (Object)level);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState getIncapSyncState() {
        return (DogIncapacitatedMananger.IncapacitatedSyncState)this.f_19804_.m_135370_(DOG_INCAP_SYNC_STATE.get());
    }

    public void setIncapSyncState(DogIncapacitatedMananger.IncapacitatedSyncState state) {
        this.f_19804_.m_135381_(DOG_INCAP_SYNC_STATE.get(), (Object)state);
    }

    @Override
    public void increaseLevel(DogLevel.Type typeIn) {
        this.getDogLevel().incrementLevel(typeIn);
        this.markDataParameterDirty(DOG_LEVEL.get());
    }

    @Override
    public void setDogSize(int value) {
        this.f_19804_.m_135381_(SIZE, (Object)((byte)Math.min(5, Math.max(1, value))));
    }

    @Override
    public int getDogSize() {
        return ((Byte)this.f_19804_.m_135370_(SIZE)).byteValue();
    }

    public void setBoneVariant(ItemStack stack) {
        this.f_19804_.m_135381_(BONE_VARIANT, (Object)stack);
    }

    public ItemStack getBoneVariant() {
        return (ItemStack)this.f_19804_.m_135370_(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        Item item = ((ItemStack)this.f_19804_.m_135370_(BONE_VARIANT)).m_41720_();
        return item instanceof IThrowableItem ? (IThrowableItem)item : null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().m_41619_();
    }

    private boolean getDogFlag(int bit) {
        return ((Byte)this.f_19804_.m_135370_(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bits, boolean flag) {
        byte c = (Byte)this.f_19804_.m_135370_(DOG_FLAGS);
        this.f_19804_.m_135381_(DOG_FLAGS, (Object)((byte)(flag ? c | bits : c & ~bits)));
    }

    public void setBegging(boolean begging) {
        this.setDogFlag(1, begging);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setDogFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canOwnerAttack() {
        return this.getDogFlag(4);
    }

    public void setForceSit(boolean val) {
        this.setDogFlag(8, val);
    }

    public boolean forceSit() {
        return this.getDogFlag(8);
    }

    public LowHealthStrategy getLowHealthStrategy() {
        int msb = this.getDogFlag(32) ? 1 : 0;
        int lsb = this.getDogFlag(16) ? 1 : 0;
        return LowHealthStrategy.fromId(msb * 2 + lsb);
    }

    public void setLowHealthStrategy(LowHealthStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(32, msb);
        this.setDogFlag(16, lsb);
    }

    public void setRegardTeamPlayers(boolean val) {
        this.setDogFlag(128, val);
    }

    public boolean regardTeamPlayers() {
        return this.getDogFlag(128);
    }

    public boolean crossOriginTp() {
        return this.getDogFlag(64);
    }

    public void setCrossOriginTp(boolean val) {
        this.setDogFlag(64, val);
    }

    public List<TalentInstance> getTalentMap() {
        return (List)this.f_19804_.m_135370_(TALENTS.get());
    }

    public void setTalentMap(List<TalentInstance> map) {
        this.f_19804_.m_135381_(TALENTS.get(), map);
    }

    public InteractionResult setTalentLevel(Talent talent, int level) {
        if (0 > level || level > talent.getMaxLevel()) {
            return InteractionResult.FAIL;
        }
        List<TalentInstance> activeTalents = this.getTalentMap();
        TalentInstance inst = null;
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talent)) continue;
            inst = activeInst;
            break;
        }
        if (inst == null) {
            if (level == 0) {
                return InteractionResult.PASS;
            }
            inst = talent.getDefault(level);
            activeTalents.add(inst);
            inst.init(this);
        } else {
            int previousLevel = inst.level();
            if (previousLevel == level) {
                return InteractionResult.PASS;
            }
            inst.setLevel(level);
            inst.set(this, previousLevel);
            if (level <= 0) {
                inst.remove(this);
                activeTalents.remove(inst);
            }
        }
        this.markDataParameterDirty(TALENTS.get());
        return InteractionResult.SUCCESS;
    }

    public List<DoggyArtifactItem> getArtifactsList() {
        List array = (List)this.f_19804_.m_135370_(ARTIFACTS.get());
        return array;
    }

    public boolean addArtifact(DoggyArtifactItem artifact) {
        if (artifact == null) {
            return false;
        }
        List array = (List)this.f_19804_.m_135370_(ARTIFACTS.get());
        if (array.size() >= 3) {
            return false;
        }
        if (array.contains((Object)artifact)) {
            return false;
        }
        array.add(artifact);
        this.markDataParameterDirty(ARTIFACTS.get());
        return true;
    }

    public ItemStack removeArtifact(int indx) {
        List array = (List)this.f_19804_.m_135370_(ARTIFACTS.get());
        if (indx < 0 || indx >= array.size()) {
            return null;
        }
        DoggyArtifactItem removedArtifact = (DoggyArtifactItem)((Object)array.remove(indx));
        this.markDataParameterDirty(ARTIFACTS.get());
        return new ItemStack((ItemLike)removedArtifact);
    }

    public <T> void markDataParameterDirty(EntityDataAccessor<T> key) {
        this.markDataParameterDirty(key, true);
    }

    public <T> void markDataParameterDirty(EntityDataAccessor<T> key, boolean notify) {
        if (notify) {
            this.m_7350_(key);
        }
        SynchedEntityData.DataItem dataentry = this.f_19804_.m_135379_(key);
        dataentry.m_135401_(true);
        this.f_19804_.f_135348_ = true;
    }

    @Override
    public void markAccessoriesDirty() {
        this.markDataParameterDirty(ACCESSORIES.get());
    }

    public void markArtifactsDirty() {
        this.markDataParameterDirty(ARTIFACTS.get());
    }

    @Override
    public Optional<TalentInstance> getTalent(Talent talentIn) {
        List<TalentInstance> activeTalents = this.getTalentMap();
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talentIn)) continue;
            return Optional.of(activeInst);
        }
        return Optional.empty();
    }

    @Override
    public int getDogLevel(Talent talentIn) {
        return this.getTalent(talentIn).map(TalentInstance::level).orElse(0);
    }

    @Override
    public <T> void setData(DataKey<T> key, T value) {
        if (key.isFinal() && this.hasData(key)) {
            throw new RuntimeException("Key is final but was tried to be set again.");
        }
        this.objects.put(key.getIndex(), value);
    }

    @Override
    public <T> void setDataIfEmpty(DataKey<T> key, T value) {
        if (!this.hasData(key)) {
            this.objects.put(key.getIndex(), value);
        }
    }

    @Override
    public <T> T getData(DataKey<T> key) {
        return (T)this.objects.get(key.getIndex());
    }

    @Override
    public <T> T getDataOrGet(DataKey<T> key, Supplier<T> other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other.get();
    }

    @Override
    public <T> T getDataOrDefault(DataKey<T> key, T other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other;
    }

    @Override
    public <T> boolean hasData(DataKey<T> key) {
        return this.objects.containsKey(key.getIndex());
    }

    @Override
    public void untame() {
        this.f_21344_.m_26573_();
        this.clearTriggerableAction();
        this.f_21345_.m_25386_().map(goal -> {
            goal.m_8041_();
            return goal;
        });
        this.m_21839_(false);
        this.m_21153_(8.0f);
        this.m_6593_(null);
        this.getTalentMap().clear();
        this.markDataParameterDirty(TALENTS.get());
        this.m_7105_(false);
        this.m_21816_(null);
        this.setWillObeyOthers(false);
        this.setCanPlayersAttack(true);
        this.setMode(EnumMode.DOCILE);
    }

    public void migrateOwner(UUID newOwnerUUID) {
        this.f_21344_.m_26573_();
        this.clearTriggerableAction();
        this.f_21345_.m_25386_().forEach(goal -> goal.m_8041_());
        this.setMode(EnumMode.DOCILE);
        this.m_21816_(newOwnerUUID);
    }

    public boolean canSpendPoints(int amount) {
        return this.getSpendablePoints() >= amount || this.getAccessory((Accessory)DoggyAccessories.GOLDEN_COLLAR.get()).isPresent();
    }

    private final int getSpendablePointsInternal() {
        int totalPoints = 15 + this.getDogLevel().getLevel(DogLevel.Type.NORMAL) + this.getDogLevel().getLevel(DogLevel.Type.DIRE);
        for (TalentInstance entry : this.getTalentMap()) {
            totalPoints -= entry.getTalent().getCummulativeCost(entry.level());
        }
        return totalPoints;
    }

    public int getSpendablePoints() {
        return this.spendablePoints.get();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public LivingEntity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (LivingEntity)this.m_20197_().get(0);
    }

    public boolean m_6087_() {
        return super.m_6087_();
    }

    public boolean m_6094_() {
        return !this.m_20160_() && super.m_6094_();
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public void setJumpPower(int jumpPowerIn) {
        this.jumpPower = 1.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void m_7023_(Vec3 positionIn) {
        super.m_7023_(positionIn);
        this.addMovementStat(this.m_20185_() - this.f_19854_, this.m_20186_() - this.f_19855_, this.m_20189_() - this.f_19856_);
    }

    protected void m_274498_(LivingEntity rider, Vec3 rideVec) {
        if (this.isDefeated()) {
            return;
        }
        this.m_146922_(rider.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(rider.m_146909_() * 0.5f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20885_ = this.f_20883_ = this.m_146908_();
        this.checkAndJumpWhenBeingRidden(rider);
        if (this.m_6147_()) {
            this.f_19789_ = 0.0f;
        }
        this.addMovementStat(this.m_20185_() - this.f_19854_, this.m_20186_() - this.f_19855_, this.m_20189_() - this.f_19856_);
    }

    private void checkAndJumpWhenBeingRidden(LivingEntity rider) {
        float forward = rider.f_20902_;
        if (this.jumpPower > 0.0f) {
            if (this.m_20069_() && this.canSwimUnderwater()) {
                this.doDogRideFloat();
            } else if (!this.isDogJumping() && this.m_20096_()) {
                this.doDogRideJump(forward);
            }
        }
        if (this.m_20096_()) {
            this.jumpPower = 0.0f;
            this.setDogJumping(false);
        } else {
            this.jumpPower = 0.0f;
        }
    }

    protected Vec3 m_274312_(LivingEntity rider, Vec3 rideVec) {
        float straf = rider.f_20900_ * 0.7f;
        float forward = rider.f_20902_;
        double downward = rideVec.f_82480_;
        if (this.m_20069_() && forward > 0.0f && this.canSwimUnderwater()) {
            float l = forward;
            downward = -l * Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            forward = l * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
        }
        if (forward <= 0.0f) {
            forward *= 0.5f;
        }
        return new Vec3((double)straf, downward, (double)forward);
    }

    protected float m_245547_(LivingEntity rider) {
        return (float)this.m_21051_(Attributes.f_22279_).m_22135_() * 0.5f;
    }

    private void doDogRideFloat() {
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_, 0.1, vec3d.f_82481_);
        this.jumpPower = 0.0f;
    }

    private void doDogRideJump(double forward) {
        double jumpValue = this.m_21051_((Attribute)DoggyAttributes.JUMP_POWER.get()).m_22135_() * (double)this.m_20098_() * (double)this.jumpPower;
        if (this.m_21023_(MobEffects.f_19603_)) {
            jumpValue += (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f);
        }
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_, jumpValue, vec3d.f_82481_);
        this.setDogJumping(true);
        this.f_19812_ = true;
        if (forward > 0.0) {
            float amount = 0.4f;
            float compX = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float compZ = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * compX * this.jumpPower), 0.0, (double)(0.4f * compZ * this.jumpPower)));
        }
        this.jumpPower = 0.0f;
    }

    public void addMovementStat(double xD, double yD, double zD) {
        int j;
        if (this.m_20160_()) {
            j = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
            this.statsTracker.increaseDistanceRidden(j);
        }
        if (!this.m_20159_()) {
            if (this.m_204029_(FluidTags.f_13131_)) {
                j = Math.round(Mth.m_14116_((float)((float)(xD * xD + yD * yD + zD * zD))) * 100.0f);
                if (j > 0) {
                    this.statsTracker.increaseDistanceOnWater(j);
                }
            } else if (this.m_20069_()) {
                int k = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (k > 0) {
                    this.statsTracker.increaseDistanceInWater(k);
                }
            } else if (this.m_20096_()) {
                int l = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (l > 0) {
                    if (this.m_20142_()) {
                        this.statsTracker.increaseDistanceSprint(l);
                    } else if (this.m_6047_()) {
                        this.statsTracker.increaseDistanceSneaking(l);
                    } else {
                        this.statsTracker.increaseDistanceWalk(l);
                    }
                }
            } else {
                int n = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
            }
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canResistPushFromFluidType(type);
            if (!result.m_19080_()) continue;
            return false;
        }
        return super.isPushedByFluid(type);
    }

    public MutableComponent getTranslationKey(Function<EnumGender, String> function) {
        return Component.m_237115_((String)((String)function.apply((Object)((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GENDER) != false ? this.getGender() : EnumGender.UNISEX))));
    }

    @Override
    public boolean isLying() {
        boolean ownerSleeping;
        LivingEntity owner = this.m_269323_();
        boolean bl = ownerSleeping = owner != null && owner.m_5803_();
        if (ownerSleeping) {
            return true;
        }
        if (this.isDefeated()) {
            boolean onBed;
            BlockState blockBelow = this.f_19853_.m_8055_(this.m_20183_());
            boolean bl2 = onBed = blockBelow.m_60713_((Block)DoggyBlocks.DOG_BED.get()) || blockBelow.m_204336_(BlockTags.f_13038_);
            if (onBed) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IDogFoodHandler> getFoodHandlers() {
        return this.foodHandlers;
    }

    @Override
    public void resetNavigation() {
        this.setNavigation(this.defaultNavigation);
    }

    @Override
    public void resetMoveControl() {
        this.setMoveControl(this.defaultMoveControl);
    }

    public List<IDogAlteration> getAlterations() {
        return this.alterations;
    }

    @Override
    public boolean canSwimUnderwater() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canSwimUnderwater(this);
            if (!result.m_19080_()) continue;
            return true;
        }
        return false;
    }

    public void m_238392_(EquipmentSlot p_238393_, ItemStack p_238394_, ItemStack p_238395_) {
    }

    public boolean isLowAirSupply() {
        return (double)this.m_20146_() < (double)this.m_6062_() * 0.3;
    }

    @Override
    public boolean isDogLowHealth() {
        return this.m_21223_() < 6.0f;
    }

    public void setDogSwimming(boolean s) {
        this.isDogSwimming = s;
    }

    public boolean isDogSwimming() {
        return this.isDogSwimming;
    }

    private void hungerHighToLow() {
        if (!this.isDefeated()) {
            this.setAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT, (d, u) -> new AttributeModifier(u, "Hunger Slowness", (double)-0.35f, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private void hungerLowToHigh() {
        this.removeAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT);
    }

    public boolean isLowHunger() {
        return this.isLowHunger;
    }

    public void updateLowHunger() {
        if (this.isLowHunger) {
            if (this.getDogHunger() > 10.0f) {
                this.isLowHunger = false;
                this.hungerLowToHigh();
            }
        } else if (this.getDogHunger() <= 10.0f) {
            this.isLowHunger = true;
            this.hungerHighToLow();
        }
        this.isZeroHunger = this.getDogHunger() == 0.0f;
    }

    protected void handleZeroHunger() {
        ++this.hungerDamageTick;
        int hurt_interval = -1;
        boolean hurt_last_health = false;
        switch (this.f_19853_.m_46791_()) {
            case EASY: {
                hurt_interval = 125;
                break;
            }
            case NORMAL: {
                hurt_interval = 100;
                break;
            }
            case HARD: {
                hurt_interval = 75;
                hurt_last_health = true;
                break;
            }
            default: {
                hurt_interval = -1;
            }
        }
        if (hurt_interval >= 0 && ++this.hungerDamageTick >= hurt_interval && (hurt_last_health || this.m_21223_() > 1.0f)) {
            this.m_6469_(this.m_269291_().m_269064_(), 0.5f);
            this.hungerDamageTick = 0;
        }
    }

    protected void m_8022_() {
        boolean incapBlockedMove = this.isDefeated() && !this.incapacitatedMananger.canMove();
        boolean notControlledByPlayer = !(this.m_6688_() instanceof ServerPlayer);
        boolean notRidingBoat = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, notControlledByPlayer && !incapBlockedMove);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, notControlledByPlayer && notRidingBoat);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, notControlledByPlayer);
    }

    protected void m_7324_(Entity pushTarget) {
        Player player;
        Dog dog;
        boolean pushEachOther = (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PREVENT_DOGS_PUSHING_EACH_OTHER);
        if (pushEachOther && pushTarget instanceof Dog && !(dog = (Dog)pushTarget).m_21573_().m_26571_() && !dog.m_20096_()) {
            return;
        }
        if (pushEachOther && pushTarget instanceof Player && !(player = (Player)pushTarget).m_6144_() && this.isDoingFine()) {
            return;
        }
        super.m_7324_(pushTarget);
    }

    public boolean m_7337_(Entity otherEntity) {
        Dog dog;
        boolean pushEachOther = (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PREVENT_DOGS_PUSHING_EACH_OTHER);
        if (pushEachOther && otherEntity instanceof Dog && !(dog = (Dog)otherEntity).m_21573_().m_26571_() && !dog.m_20096_()) {
            return false;
        }
        return super.m_7337_(otherEntity);
    }

    public float getTimeDogIsShaking() {
        return this.timeWolfIsShaking;
    }

    public float getUrgentSpeedModifier() {
        if (this.m_21133_(Attributes.f_22279_) <= 0.3) {
            return 1.5f;
        }
        return 1.0f;
    }

    public int getMaxIncapacitatedHunger() {
        return 64;
    }

    public StatsTracker getStatTracker() {
        return this.statsTracker;
    }

    public DogGroupsManager getGroups() {
        return this.dogGroupsManager;
    }

    public boolean isMiningCautious() {
        return this.dogMiningCautiousManager.isMiningCautious();
    }

    public DogSkin getClientSkin() {
        return this.clientSkin;
    }

    public void setClientSkin(DogSkin skin) {
        this.clientSkin = skin == null ? DogSkin.CLASSICAL : skin;
    }

    public List<AccessoryInstance> getClientSortedAccessories() {
        return this.clientAccessories;
    }

    public static enum LowHealthStrategy {
        NONE(0),
        RUN_AWAY(1),
        STICK_TO_OWNER(2);

        public static final LowHealthStrategy[] VALUES;
        private final byte id;

        private LowHealthStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.low_health_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.low_health_strategy." + this.getId() + ".help";
        }

        public static LowHealthStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public LowHealthStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public LowHealthStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (LowHealthStrategy[])Arrays.stream(LowHealthStrategy.values()).sorted(Comparator.comparingInt(LowHealthStrategy::getId)).toArray(LowHealthStrategy[]::new);
        }
    }
}

