/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.api.feature.EnumMode;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class DogIncapacitatedMananger {
    private final Dog dog;
    private int recoveryMultiplier = 1;
    private static final UUID INCAP_MOVEMENT = UUID.fromString("9576c796-c7c7-4995-90d5-f60eafc58805");
    private boolean appliedIncapChanges = false;
    private static final int MAX_BANDAID_COUNT = 8;
    private int bandagesCount = 0;
    private int bandageCooldown = 0;

    public DogIncapacitatedMananger(Dog dog) {
        this.dog = dog;
    }

    public void onBeingDefeated() {
        this.recoveryMultiplier = 1;
    }

    public void tick() {
        if (!this.dog.isDefeated()) {
            if (this.appliedIncapChanges) {
                this.appliedIncapChanges = false;
                this.dog.removeAttributeModifier(Attributes.f_22279_, INCAP_MOVEMENT);
                this.bandagesCount = 0;
                this.recoveryMultiplier = 1;
            }
            return;
        }
        if (this.dog.f_19853_.f_46443_) {
            this.incapacitatedClientTick();
        } else {
            this.incapacitatedTick();
        }
    }

    public InteractionResult interact(ItemStack stack, Player player, InteractionHand hand) {
        UUID owner_uuid = this.dog.m_21805_();
        if (stack.m_41720_() == DoggyItems.BANDAID.get()) {
            if (!this.dog.f_19853_.f_46443_ && this.bandageCooldown <= 0 && this.bandagesCount < 8) {
                this.bandageCooldown = 10;
                player.m_36335_().m_41524_((Item)DoggyItems.BANDAID.get(), 11);
                ++this.bandagesCount;
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == Items.f_42747_) {
            if (!this.dog.f_19853_.f_46443_) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                List<Dog> defeatedDogs = DogUtil.getOtherIncapacitatedDogNearby(this.dog);
                for (Dog d : defeatedDogs) {
                    d.setDogHunger(this.dog.getMaxIncapacitatedHunger());
                    d.m_21219_();
                    d.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
                    d.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                    d.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
                }
                this.dog.f_19853_.m_7605_((Entity)this.dog, (byte)35);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == Items.f_42502_ && this.recoveryMultiplier < 2) {
            if (this.dog.f_19853_ instanceof ServerLevel) {
                ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(this.dog, new ItemStack((ItemLike)Items.f_42502_));
            }
            this.dog.consumeItemFromStack((Entity)player, stack);
            this.dog.m_5496_(SoundEvents.f_11912_, this.dog.m_6121_(), (this.dog.m_217043_().m_188501_() - this.dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
            this.recoveryMultiplier *= 2;
        } else {
            if (!(stack.m_41720_() != Items.f_42500_ || this.dog.level().f_46443_ || this.dog.m_20159_() || player.m_20160_())) {
                if (this.dog.m_269323_() == player) {
                    this.dog.m_20329_((Entity)player);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41720_() == Items.f_42398_) {
                boolean useLegacyDogGui;
                if (this.dog.f_19853_.f_46443_ && !(useLegacyDogGui = ((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.USE_LEGACY_DOGGUI)).booleanValue())) {
                    DogCannotInteractWithScreen.open(this.dog);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.dog.m_20159_()) {
                if (!this.dog.f_19853_.f_46443_) {
                    this.dog.m_8127_();
                }
                return InteractionResult.SUCCESS;
            }
            if (owner_uuid != null && owner_uuid.equals(player.m_20148_())) {
                this.dog.m_21839_(!this.dog.m_21827_());
                this.dog.m_21573_().m_26573_();
                return InteractionResult.SUCCESS;
            }
            if (this.dog.f_19853_.f_46443_) {
                this.displayToastIncapacitated(player);
            }
        }
        return InteractionResult.FAIL;
    }

    public void onHurt() {
        this.dropBandages();
        this.bandagesCount = 0;
        IncapacitatedSyncState incap_state = this.dog.getIncapSyncState();
        IncapacitatedSyncState new_incap_state = incap_state.updateBandaid(this.bandagesCount);
        if (new_incap_state != incap_state) {
            this.dog.setIncapSyncState(new_incap_state);
        }
    }

    private void dropBandages() {
        float keep_precentage = 0.8f - (float)this.dog.m_217043_().m_188503_(4) * 0.1f;
        int keep_amount = Mth.m_14143_((float)(keep_precentage * (float)this.bandagesCount));
        for (int i = 0; i < keep_amount; ++i) {
            Containers.m_18992_((Level)this.dog.f_19853_, (double)this.dog.m_20185_(), (double)this.dog.m_20186_(), (double)this.dog.m_20189_(), (ItemStack)new ItemStack((ItemLike)DoggyItems.BANDAID.get(), 1));
        }
        this.bandageCooldown = 200;
    }

    private void displayToastIncapacitated(Player player) {
        player.m_5661_((Component)Component.m_237115_((String)"doggui.invalid_dog.incapacitated.title").m_130940_(ChatFormatting.RED), true);
    }

    public void incapacitatedClientTick() {
        IncapacitatedSyncState sync_state = this.dog.getIncapSyncState();
        DefeatedType type = sync_state.type;
        switch (type) {
            case BURN: {
                if (!(this.dog.getDogHunger() <= 10.0f)) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    float f2 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    this.dog.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.dog.m_20185_() + (double)f1, this.dog.m_20186_() + 0.4, this.dog.m_20189_() + (double)f2, 0.0, -0.05, 0.0);
                }
                if (this.dog.m_217043_().m_188503_(3) != 0) break;
                float f1 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.5f;
                float f2 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.5f;
                this.dog.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.dog.m_20185_() + (double)f1, this.dog.m_20186_() + (double)this.dog.m_20192_(), this.dog.m_20189_() + (double)f2, 0.0, 0.05, 0.0);
                break;
            }
            case BLOOD: {
                if (!(this.dog.getDogHunger() <= 10.0f) || this.dog.f_19797_ % 8 != 0) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    float f2 = (this.dog.m_217043_().m_188501_() * 2.0f - 1.0f) * this.dog.m_20205_() * 0.8f;
                    this.dog.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42588_)), this.dog.m_20185_() + (double)f1, this.dog.m_20186_() + 0.4, this.dog.m_20189_() + (double)f2, 0.0, -0.05, 0.0);
                }
                break;
            }
        }
    }

    public void incapacitatedTick() {
        IncapacitatedSyncState incap_state;
        IncapacitatedSyncState new_incap_state;
        if (!this.appliedIncapChanges) {
            this.dog.setAttributeModifier(Attributes.f_22279_, INCAP_MOVEMENT, (d, u) -> new AttributeModifier(u, "Defeated Slowness", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.appliedIncapChanges = true;
        }
        if ((new_incap_state = (incap_state = this.dog.getIncapSyncState()).updateBandaid(this.bandagesCount)) != incap_state) {
            this.dog.setIncapSyncState(new_incap_state);
        }
        this.healWithBandaid(new_incap_state.bandaid);
        if (this.bandageCooldown > 0) {
            --this.bandageCooldown;
        }
        LivingEntity owner = this.dog.m_269323_();
        BlockState dog_b0_state = this.dog.f_19853_.m_8055_(this.dog.m_20183_());
        Block dog_b0_block = dog_b0_state.m_60734_();
        if (this.dog.getDogHunger() >= (float)this.dog.getMaxIncapacitatedHunger()) {
            this.incapacitatedExit();
            return;
        }
        if (dog_b0_block == Blocks.f_50016_) {
            this.dog.addHunger(0.001f * (float)this.recoveryMultiplier);
        } else if (dog_b0_block == DoggyBlocks.DOG_BED.get()) {
            this.incapacitatedHealWithBed(owner);
        }
    }

    private void incapacitatedExit() {
        Level level;
        this.dog.m_21153_(20.0f);
        this.dog.setMode(EnumMode.DOCILE);
        this.dog.setDogHunger(this.dog.getMaxHunger());
        this.dog.m_21839_(true);
        this.dog.setIncapSyncState(IncapacitatedSyncState.NONE);
        if (this.appliedIncapChanges) {
            this.appliedIncapChanges = false;
            this.dog.removeAttributeModifier(Attributes.f_22279_, INCAP_MOVEMENT);
            this.bandagesCount = 0;
            this.recoveryMultiplier = 1;
        }
        if ((level = this.dog.f_19853_) instanceof ServerLevel) {
            ServerLevel sL = (ServerLevel)level;
            sL.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.dog.m_20185_(), this.dog.m_20186_(), this.dog.m_20189_(), 24, (double)this.dog.m_20205_(), (double)0.8f, (double)this.dog.m_20205_(), 0.1);
        }
    }

    private void incapacitatedHealWithBed(LivingEntity owner) {
        this.dog.addHunger(0.002f * (float)this.recoveryMultiplier);
        if (owner == null) {
            return;
        }
        if (this.dog.m_20280_((Entity)owner) > 100.0) {
            return;
        }
        this.dog.addHunger(0.02f * (float)this.recoveryMultiplier);
        if (!(this.dog.f_19853_ instanceof ServerLevel)) {
            return;
        }
        if (this.dog.f_19797_ % 10 != 0) {
            return;
        }
        ((ServerLevel)this.dog.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.dog.m_20185_(), this.dog.m_20186_(), this.dog.m_20189_(), 1, (double)this.dog.m_20205_(), (double)0.8f, (double)this.dog.m_20205_(), 0.1);
    }

    private void healWithBandaid(BandaidState state) {
        switch (state) {
            case FULL: {
                this.dog.addHunger(0.02f * (float)this.recoveryMultiplier);
                break;
            }
            case HALF: {
                this.dog.addHunger(0.01f * (float)this.recoveryMultiplier);
                break;
            }
        }
    }

    public boolean canMove() {
        return this.bandagesCount >= 8;
    }

    public void save(CompoundTag tag) {
        CompoundTag tg0 = new CompoundTag();
        IncapacitatedSyncState syncState = this.dog.getIncapSyncState();
        tg0.m_128405_("type", syncState.type.getId());
        tg0.m_128405_("bandaid", this.bandagesCount);
        tag.m_128365_("doggyIncapacitated", (Tag)tg0);
    }

    public void load(CompoundTag tag) {
        int bandaid_count;
        CompoundTag tg0 = tag.m_128469_("doggyIncapacitated");
        DefeatedType type = DefeatedType.byId(tg0.m_128451_("type"));
        this.bandagesCount = bandaid_count = tg0.m_128451_("bandaid");
        this.dog.setIncapSyncState(new IncapacitatedSyncState(type));
    }

    public static class IncapacitatedSyncState {
        public static IncapacitatedSyncState NONE = new IncapacitatedSyncState(DefeatedType.NONE);
        public DefeatedType type = DefeatedType.NONE;
        public BandaidState bandaid = BandaidState.NONE;

        public IncapacitatedSyncState(DefeatedType type) {
            this.type = type;
        }

        public IncapacitatedSyncState(DefeatedType type, BandaidState bandaid) {
            this.type = type;
            this.bandaid = bandaid;
        }

        public IncapacitatedSyncState copy() {
            return new IncapacitatedSyncState(this.type, this.bandaid);
        }

        public IncapacitatedSyncState updateBandaid(int bandaid_count) {
            BandaidState new_state = BandaidState.getState(bandaid_count);
            if (new_state == this.bandaid) {
                return this;
            }
            return new IncapacitatedSyncState(this.type, new_state);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IncapacitatedSyncState)) {
                return false;
            }
            IncapacitatedSyncState state = (IncapacitatedSyncState)obj;
            if (this.type != state.type) {
                return false;
            }
            return this.bandaid == state.bandaid;
        }
    }

    public static enum DefeatedType {
        NONE(0),
        BLOOD(1),
        BURN(2),
        POISON(3);

        private final int id;

        private DefeatedType(int id) {
            this.id = id;
        }

        public static DefeatedType byId(int i) {
            DefeatedType[] values = DefeatedType.values();
            if (i < 0) {
                return NONE;
            }
            if (i >= values.length) {
                return NONE;
            }
            return values[i];
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum BandaidState {
        NONE(0),
        HALF(1),
        FULL(2);

        private final int id;

        private BandaidState(int id) {
            this.id = id;
        }

        public static BandaidState byId(int i) {
            BandaidState[] values = BandaidState.values();
            if (i < 0) {
                return NONE;
            }
            if (i >= values.length) {
                return NONE;
            }
            return values[i];
        }

        public static BandaidState getState(int bandaid_count) {
            if (bandaid_count <= 3) {
                return NONE;
            }
            if (bandaid_count <= 7) {
                return HALF;
            }
            return FULL;
        }

        public int getId() {
            return this.id;
        }
    }
}

