/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.collect.Maps;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGreetOwnerAction;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DogOwnerDistanceManager {
    private static final int OWNER_FAR_AWAY_DISTANCE_SQR = 400;
    private static final int OWNER_START_GREET_DISTANCE_SQR = 144;
    private static final long START_MISSING_OWNER_TIME = 96000L;
    private static final int UPDATE_INTERVAL = 5;
    private static Map<UUID, Integer> GREETING_DOG_LIMIT_MAP = Maps.newConcurrentMap();
    private final Dog dog;
    private long lastWithOwnerTime;
    private boolean willGreet;
    private int tickTillUpdate;
    private long lastOwnerLeftInteval;

    public DogOwnerDistanceManager(Dog dog) {
        this.dog = dog;
        this.lastWithOwnerTime = dog.f_19853_.m_46468_();
    }

    public void tick() {
        if (--this.tickTillUpdate <= 0) {
            this.tickTillUpdate = 5;
            LivingEntity owner = this.dog.m_269323_();
            if (owner != null) {
                this.updateGreetingCondition(this.dog, owner);
            }
        }
    }

    private void updateGreetingCondition(Dog dog, @Nonnull LivingEntity owner) {
        if (this.isOwnerReturned(dog, owner)) {
            long gtime = dog.f_19853_.m_46468_();
            long dtime = gtime - this.lastWithOwnerTime;
            if (dtime >= 96000L) {
                this.willGreet = true;
                this.lastOwnerLeftInteval = dtime;
            }
            this.lastWithOwnerTime = gtime;
        }
        if (this.canStartGreeting(dog, owner)) {
            this.triggerGreetingAction(dog, owner, this.lastOwnerLeftInteval);
            this.lastOwnerLeftInteval = 0L;
        }
    }

    private boolean isOwnerReturned(Dog dog, LivingEntity owner) {
        return dog.m_20280_((Entity)owner) < 400.0;
    }

    private boolean canStartGreeting(Dog dog, LivingEntity owner) {
        return this.willGreet && dog.m_20280_((Entity)owner) <= 144.0 && !owner.m_5833_() && !dog.isBusy();
    }

    public void save(CompoundTag tag) {
        CompoundTag tg0 = new CompoundTag();
        tg0.m_128356_("lastWithOwnerTime", this.lastWithOwnerTime);
        tg0.m_128379_("willGreet", this.willGreet);
        tag.m_128365_("ownerDistanceManager", (Tag)tg0);
    }

    public void load(CompoundTag tag) {
        if (tag.m_128425_("ownerDistanceManager", 10)) {
            CompoundTag tg0 = tag.m_128469_("ownerDistanceManager");
            this.lastWithOwnerTime = tg0.m_128454_("lastWithOwnerTime");
            this.willGreet = tg0.m_128471_("willGreet");
        } else {
            this.lastWithOwnerTime = this.dog.f_19853_.m_46468_();
            this.willGreet = false;
        }
    }

    public void triggerGreetingAction(Dog dog, @Nonnull LivingEntity owner, long ownerLeftInterval) {
        this.willGreet = false;
        boolean greetOwnerEnabled = (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GREET_OWNER);
        int greetOwnerLimit = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GREET_OWNER_LIMIT);
        if (!greetOwnerEnabled) {
            return;
        }
        if (greetOwnerLimit > 0 && DogOwnerDistanceManager.getGreetCountForOwner(owner) >= greetOwnerLimit) {
            return;
        }
        dog.triggerAction(new DogGreetOwnerAction(dog, owner, ownerLeftInterval));
        DogOwnerDistanceManager.incGreetCountForOwner(owner);
    }

    public static int getGreetCountForOwner(LivingEntity owner) {
        return GREETING_DOG_LIMIT_MAP.getOrDefault(owner.m_20148_(), 0);
    }

    public static void incGreetCountForOwner(LivingEntity owner) {
        GREETING_DOG_LIMIT_MAP.compute(owner.m_20148_(), (uuid, old_val) -> {
            if (old_val == null) {
                return 1;
            }
            return old_val + 1;
        });
    }

    public static void decGreetCountForOwner(LivingEntity owner) {
        GREETING_DOG_LIMIT_MAP.computeIfPresent(owner.m_20148_(), (uuid, old_val) -> {
            if (old_val == null) {
                return null;
            }
            int new_val = old_val - 1;
            if (new_val <= 0) {
                return null;
            }
            return new_val;
        });
    }
}

