/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.collect.ImmutableMap;
import doggytalents.DoggyAccessories;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class HelmetInteractHandler
implements IDogItem {
    private static final Map<Item, RegistryObject<? extends Accessory>> MAPPING = new ImmutableMap.Builder().put((Object)Items.f_42468_, DoggyAccessories.IRON_HELMET).put((Object)Items.f_42472_, DoggyAccessories.DIAMOND_HELMET).put((Object)Items.f_42476_, DoggyAccessories.GOLDEN_HELMET).put((Object)Items.f_42464_, DoggyAccessories.CHAINMAIL_HELMET).put((Object)Items.f_42354_, DoggyAccessories.TURTLE_HELMET).put((Object)Items.f_42480_, DoggyAccessories.NETHERITE_HELMET).put((Object)Items.f_42471_, DoggyAccessories.IRON_BODY_PIECE).put((Object)Items.f_42475_, DoggyAccessories.DIAMOND_BODY_PIECE).put((Object)Items.f_42479_, DoggyAccessories.GOLDEN_BODY_PIECE).put((Object)Items.f_42467_, DoggyAccessories.CHAINMAIL_BODY_PIECE).put((Object)Items.f_42483_, DoggyAccessories.NETHERITE_BODY_PIECE).put((Object)Items.f_42469_, DoggyAccessories.IRON_BODY_PIECE).put((Object)Items.f_42473_, DoggyAccessories.DIAMOND_BODY_PIECE).put((Object)Items.f_42477_, DoggyAccessories.GOLDEN_BODY_PIECE).put((Object)Items.f_42465_, DoggyAccessories.CHAINMAIL_BODY_PIECE).put((Object)Items.f_42481_, DoggyAccessories.NETHERITE_BODY_PIECE).put((Object)Items.f_42407_, DoggyAccessories.LEATHER_HELMET).put((Object)Items.f_42463_, DoggyAccessories.LEATHER_BOOTS).put((Object)Items.f_42408_, DoggyAccessories.LEATHER_BODY_PIECE).put((Object)Items.f_42462_, DoggyAccessories.IRON_BODY_PIECE).put((Object)Items.f_42470_, DoggyAccessories.IRON_BODY_PIECE).put((Object)Items.f_42474_, DoggyAccessories.DIAMOND_BODY_PIECE).put((Object)Items.f_42478_, DoggyAccessories.GOLDEN_BODY_PIECE).put((Object)Items.f_42466_, DoggyAccessories.CHAINMAIL_BODY_PIECE).put((Object)Items.f_42482_, DoggyAccessories.NETHERITE_BODY_PIECE).build();

    public static RegistryObject<? extends Accessory> getMappedResource(Item item) {
        RegistryObject<? extends Accessory> x = MAPPING.get(item);
        if (x != null) {
            return x;
        }
        EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)new ItemStack((ItemLike)item));
        switch (slot) {
            case CHEST: {
                return DoggyAccessories.IRON_BODY_PIECE;
            }
            case FEET: {
                return DoggyAccessories.IRON_BOOTS;
            }
            case HEAD: {
                return DoggyAccessories.IRON_HELMET;
            }
            case LEGS: {
                return DoggyAccessories.IRON_BODY_PIECE;
            }
        }
        return DoggyAccessories.IRON_BODY_PIECE;
    }

    @Override
    public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        AccessoryInstance inst;
        RegistryObject<? extends Accessory> associatedAccessory;
        ItemStack stack;
        if (dogIn.m_21824_() && dogIn.canInteract((LivingEntity)playerIn) && !(stack = playerIn.m_21120_(handIn)).m_41619_() && (associatedAccessory = MAPPING.get(stack.m_41720_())) != null && dogIn.addAccessory(inst = ((Accessory)associatedAccessory.get()).createFromStack(stack.m_41777_().m_41620_(1)))) {
            dogIn.consumeItemFromStack((Entity)playerIn, stack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

