/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;

public class DogBreedGoal
extends Goal {
    private static final TargetingConditions breedPredicate = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final Dog dog;
    private final Level world;
    private final double moveSpeed;
    protected Dog targetMate;
    private int spawnBabyDelay;

    public DogBreedGoal(Dog dog, double moveSpeed) {
        this.dog = dog;
        this.world = dog.f_19853_;
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.dog.isDoingFine()) {
            return false;
        }
        if (!this.dog.m_27593_()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean m_8045_() {
        if (!this.dog.isDoingFine()) {
            return false;
        }
        if (!this.targetMate.isDoingFine()) {
            return false;
        }
        return this.targetMate.m_27593_() && this.spawnBabyDelay < 60;
    }

    public void m_8041_() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void m_8037_() {
        this.dog.m_21563_().m_24960_((Entity)this.targetMate, 10.0f, (float)this.dog.m_8132_());
        this.dog.m_21573_().m_5624_((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.dog.m_20280_((Entity)this.targetMate) < 9.0) {
            this.dog.m_27563_((ServerLevel)this.world, (Animal)this.targetMate);
        }
    }

    @Nullable
    private Dog getNearbyMate() {
        List entities = this.world.m_6443_(Dog.class, this.dog.m_20191_().m_82400_(8.0), this::filterEntities);
        return (Dog)EntityUtil.getClosestTo((Entity)this.dog, entities);
    }

    private boolean filterEntities(Dog dog) {
        return breedPredicate.m_26885_((LivingEntity)this.dog, (LivingEntity)dog) && this.dog.m_7848_((Animal)dog);
    }
}

