/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import com.mojang.datafixers.util.Pair;
import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.InventoryUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.items.IItemHandler;

public class DogEatFromChestDogGoal
extends Goal {
    private Dog dog;
    private int tickTillPathRecalc;
    private float oldWaterCost;
    private final double speedModifier;
    private final float stopDist;
    private List<Dog> chestDogs;
    private Dog chestDog = null;
    private int tickTillNextChestDogSearch = 0;
    private final int SEARCH_RADIUS = 12;
    private static final ChestDogFoodHandler FOOD_VALIDATOR = new ChestDogFoodHandler();

    public DogEatFromChestDogGoal(Dog dog, double speedModifier) {
        this.dog = dog;
        this.speedModifier = speedModifier;
        this.stopDist = 1.5f;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.dog.getDogHunger() >= 50.0f || this.dog.isDefeated()) {
            return false;
        }
        this.invalidateChestDogCache();
        this.inspectNearbyChestDogsForFood();
        return this.chestDog != null;
    }

    public boolean m_8045_() {
        if (this.chestDog == null) {
            return false;
        }
        return this.dog.getDogHunger() <= 80.0f || this.dog.isDogLowHealth() && this.dog.getDogHunger() < this.dog.getMaxHunger();
    }

    public void m_8056_() {
        this.tickTillPathRecalc = 0;
        this.oldWaterCost = this.dog.m_21439_(BlockPathTypes.WATER);
        this.dog.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.dog.m_21573_().m_26573_();
        this.dog.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        this.dog.setBegging(false);
    }

    public void m_8037_() {
        this.invalidateChestDogCache();
        if (this.chestDog == null) {
            return;
        }
        if (!this.chestDog.isDoingFine()) {
            this.chestDog = null;
            return;
        }
        if (this.dog.m_20280_((Entity)this.chestDog) > (double)(this.stopDist * this.stopDist)) {
            this.moveToChestDog();
        } else {
            this.checkAndEatFromChestDog();
        }
    }

    private void moveToChestDog() {
        this.dog.m_21563_().m_24960_((Entity)this.chestDog, 10.0f, (float)this.dog.m_8132_());
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 10;
            if (!this.checkChestDogForFood(this.chestDog)) {
                this.chestDog = null;
                return;
            }
            if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                DogUtil.moveToIfReachOrElse(this.dog, this.chestDog.m_20183_(), this.speedModifier, 1, 1, d -> {
                    this.chestDog = null;
                });
            }
        }
    }

    private void inspectNearbyChestDogsForFood() {
        if (--this.tickTillNextChestDogSearch <= 0) {
            this.tickTillNextChestDogSearch = 10;
            if (this.chestDog == null) {
                this.fetchChestDogs();
                this.chooseRandomChestDog();
            }
            if (!this.checkChestDogForFood(this.chestDog)) {
                this.chestDog = null;
            }
        }
    }

    private void chooseNearestChestDog() {
        if (this.chestDogs == null) {
            return;
        }
        if (this.chestDogs.isEmpty()) {
            return;
        }
        Dog target = this.chestDogs.get(0);
        double mindistanceSqr = target.m_20280_((Entity)this.dog);
        for (Dog i : this.chestDogs) {
            double d = i.m_20280_((Entity)this.dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        this.chestDog = target;
    }

    private void invalidateChestDogCache() {
        if (this.chestDog != null && !this.chestDog.isDoingFine()) {
            this.chestDog = null;
        }
    }

    private void chooseRandomChestDog() {
        if (this.chestDogs == null) {
            return;
        }
        if (this.chestDogs.isEmpty()) {
            return;
        }
        int rIndx = this.dog.m_217043_().m_188503_(this.chestDogs.size());
        this.chestDog = this.chestDogs.get(rIndx);
    }

    private void fetchChestDogs() {
        this.chestDogs = this.dog.f_19853_.m_6443_(Dog.class, this.dog.m_20191_().m_82377_(12.0, 4.0, 12.0), d -> this.isChestDog((Dog)d));
    }

    private boolean isChestDog(Dog chestDog) {
        return chestDog.getDogLevel((Supplier)DoggyTalents.PACK_PUPPY) > 0;
    }

    private boolean checkChestDogForFood(Dog chestDog) {
        if (chestDog == null) {
            return false;
        }
        if (!this.isChestDog(chestDog)) {
            return false;
        }
        LivingEntity chestDogOwner = chestDog.m_269323_();
        if (chestDogOwner == null) {
            return false;
        }
        if (chestDogOwner != this.dog.m_269323_()) {
            return false;
        }
        if (chestDog.m_20280_((Entity)this.dog) > 144.0) {
            return false;
        }
        PackPuppyItemHandler inventory = chestDog.getTalent((Supplier)DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null);
        if (inventory == null) {
            return false;
        }
        return InventoryUtil.findStack((IItemHandler)inventory, stack -> {
            boolean willEat = FOOD_VALIDATOR.canConsume(chestDog, (ItemStack)stack, null);
            return willEat;
        }) != null;
    }

    private void checkAndEatFromChestDog() {
        if (this.dog.m_20280_((Entity)this.chestDog) <= 5.0 && this.dog.m_142582_((Entity)this.chestDog)) {
            ItemStack stack;
            int i;
            PackPuppyItemHandler inventory = this.chestDog.getTalent((Supplier)DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null);
            if (inventory == null) {
                return;
            }
            if (this.dog.isDogLowHealth() && !this.dog.m_21023_(MobEffects.f_19605_)) {
                for (i = 0; i < inventory.getSlots(); ++i) {
                    stack = inventory.getStackInSlot(i);
                    if (stack.m_41720_() != DoggyItems.EGG_SANDWICH.get()) continue;
                    FOOD_VALIDATOR.consume(this.dog, stack, null);
                    return;
                }
            }
            for (i = 0; i < inventory.getSlots(); ++i) {
                stack = inventory.getStackInSlot(i);
                boolean willEat = FOOD_VALIDATOR.canConsume(this.chestDog, stack, null);
                if (!willEat) continue;
                FOOD_VALIDATOR.consume(this.dog, stack, null);
                return;
            }
        }
    }

    public static class ChestDogFoodHandler
    extends MeatFoodHandler {
        @Override
        public boolean canConsume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
            return super.canConsume(dog, stack, entityIn);
        }

        @Override
        public InteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
            if (dog.f_19853_.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Item item = stack.m_41720_();
            FoodProperties props = item.m_41473_();
            if (props == null) {
                return InteractionResult.FAIL;
            }
            int heal = props.m_38744_() * 5;
            dog.addHunger(heal);
            dog.consumeItemFromStack(entityIn, stack);
            if (item == DoggyItems.EGG_SANDWICH.get()) {
                for (Pair pair : props.m_38749_()) {
                    if (pair.getFirst() == null || !(dog.m_217043_().m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    dog.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                }
            }
            if (dog.f_19853_ instanceof ServerLevel) {
                ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)item));
            }
            dog.m_5496_(SoundEvents.f_11912_, dog.m_6121_(), (dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
            return InteractionResult.SUCCESS;
        }
    }
}

