/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyBlocks;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DogGoRestOnBedGoalDefeated
extends Goal {
    private final int SEARCH_RADIUS = 5;
    private Dog dog;
    private int tickTillSearch = 10;
    private int tickTillPathRecalc = 0;
    private BlockPos targetBed;
    private int tickTillValidateNeabyDogs = 5;

    public DogGoRestOnBedGoalDefeated(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.dog.isDefeated()) {
            return false;
        }
        if (this.dog.m_21827_()) {
            return false;
        }
        this.targetBed = null;
        if (--this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            this.targetBed = this.searchForBed();
        }
        return this.targetBed != null;
    }

    public boolean m_8045_() {
        if (!this.dog.isDefeated()) {
            return false;
        }
        if (this.dog.m_21827_()) {
            return false;
        }
        return this.targetBed != null;
    }

    public void m_8056_() {
        this.tickTillPathRecalc = 0;
        this.dog.m_21837_(false);
    }

    public void m_8041_() {
        this.dog.m_21573_().m_26573_();
        this.dog.m_21837_(false);
    }

    public void m_8037_() {
        boolean onBed;
        this.validateTarget();
        if (this.targetBed == null) {
            return;
        }
        PathNavigation nav = this.dog.m_21573_();
        double d_targetBed = this.dog.m_20238_(Vec3.m_82539_((Vec3i)this.targetBed));
        boolean bl = onBed = d_targetBed < 0.35;
        if (!onBed && --this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 10;
            nav.m_26519_((double)this.targetBed.m_123341_() + 0.5, (double)this.targetBed.m_123342_(), (double)this.targetBed.m_123343_() + 0.5, 1.0);
        }
        if (nav.m_26571_() && !onBed) {
            this.dog.m_21566_().m_6849_((double)this.targetBed.m_123341_() + 0.5, (double)this.targetBed.m_123342_(), (double)this.targetBed.m_123343_() + 0.5, 1.0);
        }
        this.dog.m_21837_(d_targetBed < 1.0);
    }

    private void validateTarget() {
        if (this.targetBed == null) {
            return;
        }
        int invalidate_dist = 36;
        if (this.dog.m_20238_(Vec3.m_82539_((Vec3i)this.targetBed)) > (double)invalidate_dist) {
            this.targetBed = null;
            return;
        }
        BlockState state = this.dog.f_19853_.m_8055_(this.targetBed);
        if (!this.isBed(state)) {
            this.targetBed = null;
            return;
        }
        if (--this.tickTillValidateNeabyDogs <= 0) {
            List nearby_defeated_dogs;
            this.tickTillValidateNeabyDogs = 5;
            Vec3 bed_center = Vec3.m_82539_((Vec3i)this.targetBed);
            if (!this.noDogsIsNearby(bed_center, nearby_defeated_dogs = this.dog.f_19853_.m_6443_(Dog.class, new AABB(bed_center.m_82520_(-2.0, -2.0, -2.0), bed_center.m_82520_(2.0, 2.0, 2.0)), filter_dog -> filter_dog.isDefeated()))) {
                this.targetBed = null;
                return;
            }
        }
    }

    private BlockPos searchForBed() {
        List nearby_defeated_dogs = this.dog.f_19853_.m_6443_(Dog.class, this.dog.m_20191_().m_82377_(6.0, 2.0, 6.0), filter_dog -> filter_dog.isDefeated());
        BlockPos dog_b0 = this.dog.m_20183_();
        for (BlockPos bpos : BlockPos.m_121940_((BlockPos)dog_b0.m_7918_(-5, -1, -5), (BlockPos)dog_b0.m_7918_(5, 1, 5))) {
            BlockState state = this.dog.f_19853_.m_8055_(bpos);
            if (!this.isBed(state) || !this.noDogsIsNearby(Vec3.m_82539_((Vec3i)bpos), nearby_defeated_dogs)) continue;
            return bpos;
        }
        return null;
    }

    private boolean isBed(BlockState state) {
        Block block = state.m_60734_();
        if (block == DoggyBlocks.DOG_BED.get()) {
            return true;
        }
        return state.m_204336_(BlockTags.f_13038_);
    }

    private boolean noDogsIsNearby(Vec3 pos, List<Dog> nearbys) {
        for (Dog dog : nearbys) {
            if (dog == this.dog || !(dog.m_20238_(pos) < 0.35)) continue;
            return false;
        }
        return true;
    }
}

