/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.IDogAlteration;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DogMeleeAttackGoal
extends Goal {
    protected final Dog dog;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private int ticksUntilPathRecalc = 10;
    private int ticksUntilNextAttack;
    private int awayFromOwnerDistance;
    private int timeOutTick;
    private int waitingTick;
    private BlockPos.MutableBlockPos dogPos0;
    private int detectReachPenalty = 0;
    private final float START_LEAPING_AT_DIS_SQR = 2.0f;
    private final float DONT_LEAP_AT_DIS_SQR = 1.0f;
    private final float LEAP_YD = 0.4f;

    public DogMeleeAttackGoal(Dog dog, double speedModifier, boolean followingTargetIfNotSeen, int awayFromOwnerDistance, int timeOutTick) {
        this.dog = dog;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetIfNotSeen;
        this.awayFromOwnerDistance = awayFromOwnerDistance;
        this.timeOutTick = timeOutTick;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.isDogLowHealth() && this.dog.getLowHealthStrategy() == Dog.LowHealthStrategy.RUN_AWAY) {
            return false;
        }
        if (this.dog.f_19789_ > 7.0f) {
            return false;
        }
        LivingEntity owner = this.dog.m_269323_();
        if (owner != null && this.dog.m_20280_((Entity)owner) > this.getMaxDistanceAwayFromOwner()) {
            return false;
        }
        LivingEntity target = this.dog.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            this.dog.m_6710_(null);
            return false;
        }
        if (--this.detectReachPenalty > 0) {
            return false;
        }
        this.detectReachPenalty = 5;
        Path p = this.dog.m_21573_().m_6570_((Entity)target, 1);
        double d0 = this.dog.m_20280_((Entity)target);
        if (p == null) {
            return false;
        }
        this.detectReachPenalty += d0 > 256.0 ? 10 : 5;
        if (!DogUtil.canPathReachTargetBlock(this.dog, p, target.m_20183_(), 1, this.dog.m_6056_())) {
            this.dog.m_6710_(null);
            return false;
        }
        return true;
    }

    public boolean m_8045_() {
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.f_19789_ > 7.0f) {
            return false;
        }
        LivingEntity owner = this.dog.m_269323_();
        if (owner != null && this.dog.m_20280_((Entity)owner) > this.getMaxDistanceAwayFromOwner()) {
            return false;
        }
        if (this.waitingTick > this.timeOutTick) {
            return false;
        }
        LivingEntity livingentity = this.dog.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.dog.m_21573_().m_26571_();
        }
        if (!this.dog.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.dog.m_21573_().m_5624_((Entity)this.dog.m_5448_(), this.speedModifier);
        this.dog.m_21561_(true);
        this.ticksUntilPathRecalc = 0;
        this.ticksUntilNextAttack = 0;
        this.waitingTick = 0;
        this.dogPos0 = this.dog.m_20183_().m_122032_();
    }

    public void m_8041_() {
        LivingEntity livingentity = this.dog.m_5448_();
        this.dog.m_6710_(null);
        this.dog.m_21561_(false);
        this.dog.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity e = this.dog.m_5448_();
        if (e == null) {
            return;
        }
        PathNavigation n = this.dog.m_21573_();
        BlockPos dog_bp = this.dog.m_20183_();
        BlockPos target_bp = e.m_20183_();
        if (dog_bp.equals((Object)this.dogPos0)) {
            ++this.waitingTick;
        } else {
            this.waitingTick = 0;
            this.dogPos0.m_122178_(dog_bp.m_123341_(), dog_bp.m_123342_(), dog_bp.m_123343_());
        }
        this.dog.m_21563_().m_24960_((Entity)e, 30.0f, 30.0f);
        double d0 = this.dog.m_20275_(e.m_20185_(), e.m_20186_(), e.m_20189_());
        if ((this.followingTargetEvenIfNotSeen || this.dog.m_21574_().m_148306_((Entity)e)) && this.ticksUntilPathRecalc <= 0) {
            this.ticksUntilPathRecalc = 10;
            n.m_5624_((Entity)e, this.speedModifier);
        }
        --this.ticksUntilPathRecalc;
        --this.ticksUntilNextAttack;
        if (n.m_26571_() && dog_bp.m_123331_((Vec3i)target_bp) <= 2.25 && !this.canReachTarget(e, d0) && this.isTargetInSafeArea(this.dog, e)) {
            this.dog.m_21566_().m_6849_(e.m_20185_(), e.m_20186_(), e.m_20189_(), this.speedModifier);
        }
        if (n.m_26571_() && this.dog.f_19797_ % 2 != 0 && !this.canReachTarget(e, d0)) {
            this.ticksUntilPathRecalc = 0;
        }
        if (this.checkAndPerformAttack(e, d0)) {
            this.waitingTick = 0;
        }
        this.checkAndLeapAtTarget(e);
    }

    protected void checkAndLeapAtTarget(LivingEntity target) {
        if (!this.canLeapAtTarget(target)) {
            return;
        }
        Vec3 vec3 = this.dog.m_20184_();
        Vec3 vec31 = new Vec3(target.m_20185_() - this.dog.m_20185_(), 0.0, target.m_20189_() - this.dog.m_20189_());
        if (vec31.m_82556_() > 1.0E-7) {
            vec31 = vec31.m_82541_().m_82490_(0.4).m_82549_(vec3.m_82490_(0.2));
        }
        double d = vec31.f_82479_;
        Objects.requireNonNull(this);
        this.dog.m_20334_(d, 0.4f, vec31.f_82481_);
    }

    protected boolean canLeapAtTarget(@NotNull LivingEntity target) {
        if (this.dog.m_20160_()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        if (!target.m_20096_()) {
            return false;
        }
        double d0 = this.dog.m_20280_((Entity)target);
        if (!(d0 >= 1.0) || !(d0 <= 2.0)) {
            return false;
        }
        if (this.dog.m_217043_().m_188503_(DogMeleeAttackGoal.m_186073_((int)5)) != 0) {
            return false;
        }
        BlockPos tpos = target.m_20183_();
        if (WalkNodeEvaluator.m_77604_((BlockGetter)this.dog.f_19853_, (BlockPos.MutableBlockPos)tpos.m_122032_()) != BlockPathTypes.WALKABLE) {
            return false;
        }
        Vec3 v_offset = new Vec3(target.m_20185_() - this.dog.m_20185_(), 0.0, target.m_20189_() - this.dog.m_20189_()).m_82541_();
        Vec3 v_dog = this.dog.m_20182_();
        for (int i = 1; i <= 3; ++i) {
            if (WalkNodeEvaluator.m_77604_((BlockGetter)this.dog.f_19853_, (BlockPos.MutableBlockPos)BlockPos.m_274446_((Position)(v_dog = v_dog.m_82549_(v_offset))).m_122032_()) == BlockPathTypes.WALKABLE) continue;
            return false;
        }
        return true;
    }

    protected boolean checkAndPerformAttack(LivingEntity target, double distanceToTargetSqr) {
        if (this.canReachTarget(target, distanceToTargetSqr) && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.dog.m_6674_(InteractionHand.MAIN_HAND);
            this.dog.m_7327_((Entity)target);
            return true;
        }
        return false;
    }

    protected boolean isTargetInSafeArea(Dog dog, LivingEntity target) {
        BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)dog.f_19853_, (BlockPos.MutableBlockPos)target.m_20183_().m_122032_());
        for (IDogAlteration x : dog.getAlterations()) {
            if (!x.isBlockTypeWalkable(dog, type).m_19080_()) continue;
            type = BlockPathTypes.WALKABLE;
            break;
        }
        return type == BlockPathTypes.WALKABLE;
    }

    protected boolean canReachTarget(LivingEntity target, double distanceToTargetSqr) {
        return this.getAttackReachSqr(target) >= distanceToTargetSqr;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }

    protected double getAttackReachSqr(LivingEntity target) {
        return this.dog.m_20205_() * 2.0f * this.dog.m_20205_() * 2.0f + target.m_20205_();
    }

    protected double getMaxDistanceAwayFromOwner() {
        return this.awayFromOwnerDistance * this.awayFromOwnerDistance;
    }
}

