/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.EntityUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class MoveToClosestItemGoal
extends Goal {
    protected final Dog dog;
    protected final Predicate<ItemEntity> predicate;
    protected final Comparator<Entity> sorter;
    protected final double followSpeed;
    protected final PathNavigation dogNavigator;
    protected final float minDist;
    protected ItemEntity target;
    private int timeToRecalcPath;
    private float maxDist;
    private float oldWaterCost;
    private double oldRangeSense;

    public MoveToClosestItemGoal(Dog dogIn, double speedIn, float maxDist, float stopDist, @Nullable Predicate<ItemStack> targetSelector) {
        this.dog = dogIn;
        this.dogNavigator = dogIn.m_21573_();
        this.followSpeed = speedIn;
        this.maxDist = maxDist;
        this.minDist = stopDist;
        this.predicate = entity -> {
            if (entity.m_20145_()) {
                return false;
            }
            if (targetSelector != null && !targetSelector.test(entity.m_32055_())) {
                return false;
            }
            return (double)entity.m_20270_((Entity)this.dog) <= EntityUtil.getFollowRange((LivingEntity)this.dog);
        };
        this.sorter = new EntityUtil.Sorter((Entity)dogIn);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        double d0 = EntityUtil.getFollowRange((LivingEntity)this.dog);
        List list = this.dog.f_19853_.m_6443_(ItemEntity.class, this.dog.m_20191_().m_82377_(d0, 4.0, d0), this.predicate);
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.sorter);
        this.target = (ItemEntity)list.get(0);
        return true;
    }

    public boolean m_8045_() {
        ItemEntity target = this.target;
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double d0 = EntityUtil.getFollowRange((LivingEntity)this.dog);
        double dist = this.dog.m_20280_((Entity)target);
        return !(dist > d0 * d0) && !(dist < (double)(this.minDist * this.minDist));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dog.m_21439_(BlockPathTypes.WATER);
        this.dog.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.oldRangeSense = this.dog.m_21051_(Attributes.f_22277_).m_22135_();
        this.dog.m_21051_(Attributes.f_22277_).m_22100_((double)this.maxDist);
    }

    public void m_8037_() {
        if (!this.dog.m_21825_() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.dogNavigator.m_5624_((Entity)this.target, this.followSpeed)) {
                this.dog.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.dog.m_8132_());
            }
        }
    }

    public void m_8041_() {
        this.target = null;
        this.dogNavigator.m_26573_();
        this.dog.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        this.dog.m_21051_(Attributes.f_22277_).m_22100_(this.oldRangeSense);
    }
}

