/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class DogPathNavigation
extends GroundPathNavigation {
    private Dog dog;

    public DogPathNavigation(Dog dog, Level level) {
        super((Mob)dog, level);
        this.dog = dog;
    }

    protected void m_7636_() {
        boolean canCutCorner;
        if (this.invalidateIfNextNodeIsTooHigh()) {
            return;
        }
        Vec3 currentPos = this.m_7475_();
        this.f_26505_ = this.f_26494_.m_20205_() > 0.75f ? this.f_26494_.m_20205_() / 2.0f : 0.75f - this.f_26494_.m_20205_() / 2.0f;
        BlockPos nextPos = this.f_26496_.m_77400_();
        double dx = Math.abs(this.f_26494_.m_20185_() - ((double)nextPos.m_123341_() + 0.5));
        double dy = Math.abs(this.f_26494_.m_20186_() - (double)nextPos.m_123342_());
        double dz = Math.abs(this.f_26494_.m_20189_() - ((double)nextPos.m_123343_() + 0.5));
        boolean isCloseEnough = dx <= (double)this.f_26505_ && dy < 1.0 && dz <= (double)this.f_26505_;
        boolean bl = canCutCorner = this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.shouldTargetNextNodeInDirection(currentPos);
        if (isCloseEnough || canCutCorner) {
            this.f_26496_.m_77374_();
        }
        this.m_6481_(currentPos);
    }

    protected boolean invalidateIfNextNodeIsTooHigh() {
        Path path = this.f_26496_;
        if (path == null) {
            return true;
        }
        BlockPos nextPos = path.m_77400_();
        double dy = this.dog.m_20186_() - (double)nextPos.m_123342_();
        if (dy < -1.75) {
            this.m_26573_();
            return true;
        }
        Node nextNode = path.m_77401_();
        if (this.dog.m_21439_(nextNode.f_77282_) < 0.0f) {
            this.m_26573_();
            return true;
        }
        return false;
    }

    private boolean shouldTargetNextNodeInDirection(Vec3 current_pos) {
        Vec3 v_next_current;
        Path path = this.f_26496_;
        if (path == null) {
            return false;
        }
        if (path.m_77399_() + 1 >= path.m_77398_()) {
            return false;
        }
        Vec3 next_pos = Vec3.m_82539_((Vec3i)path.m_77400_());
        if (!current_pos.m_82509_((Position)next_pos, 2.0)) {
            return false;
        }
        Vec3 next2th_node = Vec3.m_82539_((Vec3i)path.m_77396_(path.m_77399_() + 1));
        Vec3 v_next_next2th = next2th_node.m_82546_(next_pos);
        if (v_next_next2th.m_82526_(v_next_current = current_pos.m_82546_(next_pos)) <= 0.0) {
            return false;
        }
        Vec3 v_current_next2th = next2th_node.m_82546_(current_pos);
        double v_current_next2th_lSqr = v_current_next2th.m_82556_();
        if (v_current_next2th_lSqr < 1.0) {
            return true;
        }
        Vec3 v_add = v_current_next2th.m_82541_();
        BlockPos check_b0 = BlockPos.m_274446_((Position)current_pos.m_82549_(v_add));
        BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)this.f_26495_, (BlockPos.MutableBlockPos)check_b0.m_122032_());
        return type == BlockPathTypes.WALKABLE;
    }
}

