/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DogGoBehindOwnerAction
extends TriggerableAction {
    @Nonnull
    private final LivingEntity owner;
    private BlockPos targetPos = null;
    private int holdTimeLeft;

    public DogGoBehindOwnerAction(Dog dog, @Nonnull LivingEntity owner) {
        super(dog, false, false);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.getBehindOwnerPos();
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.m_21573_().m_26573_();
        DogUtil.moveToIfReachOrElse(this.dog, this.targetPos, this.dog.getUrgentSpeedModifier(), 1, 1, d -> {
            this.targetPos = null;
        });
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.holdTimeLeft = 40;
    }

    @Override
    public void tick() {
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.dog.m_21573_().m_26571_()) {
            --this.holdTimeLeft;
        }
        if (this.holdTimeLeft <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    @Override
    public void onStop() {
    }

    private void getBehindOwnerPos() {
        Vec3 owner_pos0 = this.owner.m_20182_();
        float a1 = this.owner.m_6080_();
        float dx1 = Mth.m_14031_((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = -Mth.m_14089_((float)(a1 * ((float)Math.PI / 180)));
        Vec3 vec_back = new Vec3((double)dx1, 0.0, (double)dz1);
        double pX = owner_pos0.f_82479_;
        double pY = owner_pos0.f_82480_;
        double pZ = owner_pos0.f_82481_;
        BlockPos bpos = null;
        BlockState state = null;
        for (int i = 0; i < 3; ++i) {
            bpos = BlockPos.m_274561_((double)(pX += vec_back.f_82479_), (double)pY, (double)(pZ += vec_back.f_82481_));
            state = this.dog.f_19853_.m_8055_(bpos);
            if (state.m_60795_()) continue;
            pY += 1.0;
        }
        bpos = BlockPos.m_274561_((double)pX, (double)pY, (double)pZ);
        state = this.dog.f_19853_.m_8055_(bpos);
        this.targetPos = state != null && state.m_60795_() ? bpos : null;
    }
}

