/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogOwnerDistanceManager;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;

public class DogGreetOwnerAction
extends TriggerableAction {
    private LivingEntity owner;
    private static final int GREET_TICK_PER_LEFT_DAY = 20;
    private static final int MAX_GREET_TIME = 400;
    private static final int MAY_CANCEL_GREET_TIME = 100;
    private static final int START_GREET_DISTANCE_SQR = 4;
    private static final int GREET_RADIUS = 1;
    private static final int JUMP_BASE_INTERVAL = 7;
    private static final int WHINE_BASE_INTERVAL = 50;
    private static final int HEART_CHANCE_WINDOW = 8;
    private static final int MSG_CHANCE_WINDOW = 10;
    int greetTime;
    int tickTillPathRecalc;
    BlockPos rbAroundOwner;
    int tickTillWhine;
    int tickTillJump;
    boolean tellOwner;
    final int greetStopTime;

    public DogGreetOwnerAction(Dog dog, @Nonnull LivingEntity owner, long ownerLeftInterval) {
        super(dog, true, true);
        this.owner = owner;
        this.greetStopTime = this.calculateGreetTime(ownerLeftInterval);
    }

    private int calculateGreetTime(long ownerLeftInterval) {
        int a = Mth.m_14143_((float)(ownerLeftInterval / 24000L * 20L));
        return Math.min(a, 400);
    }

    @Override
    public void onStart() {
        this.tickTillPathRecalc = 0;
        this.greetTime = 0;
        this.tickTillWhine = this.dog.m_217043_().m_188503_(5) * 10;
        this.tellOwner = true;
    }

    @Override
    public void tick() {
        if (this.greetTime >= this.greetStopTime) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        double d0 = this.dog.m_20280_((Entity)this.owner);
        this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
        if (d0 > 4.0) {
            if (--this.tickTillPathRecalc <= 0) {
                this.tickTillPathRecalc = 20;
                DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 400.0, false, false, 400.0, this.dog.m_6056_());
            }
        } else {
            if (this.tellOwner) {
                this.tellOwner = false;
                int r = this.dog.m_217043_().m_188503_(10);
                if (r < 5) {
                    this.owner.m_213846_((Component)Component.m_237110_((String)("dog.msg.greet_owner." + r), (Object[])new Object[]{this.dog.m_7755_().getString()}));
                }
            }
            this.doGreet();
        }
    }

    private void doGreet() {
        Level level;
        ++this.greetTime;
        PathNavigation n = this.dog.m_21573_();
        if (n.m_26571_() && this.dog.f_19797_ % 2 != 0) {
            this.rbAroundOwner = this.getRandomPosAroundOwner(this.owner);
            n.m_26519_((double)this.rbAroundOwner.m_123341_(), (double)this.rbAroundOwner.m_123342_(), (double)this.rbAroundOwner.m_123343_(), 1.0);
        }
        if (--this.tickTillJump <= 0) {
            this.tickTillJump = 7;
            this.dog.m_21569_().m_24901_();
        }
        if (--this.tickTillWhine <= 0) {
            this.tickTillWhine = 50 + this.dog.m_217043_().m_188503_(3) * 20;
            this.dog.m_5496_(SoundEvents.f_12625_, this.dog.m_6121_(), this.dog.m_6100_());
        }
        if (this.dog.m_217043_().m_188503_(8) == 0 && (level = this.dog.f_19853_) instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.dog.m_20185_(), this.dog.m_20186_(), this.dog.m_20189_(), 1, (double)this.dog.m_20205_(), (double)0.8f, (double)this.dog.m_20205_(), 0.1);
        }
    }

    @Override
    public void onStop() {
        int greetOwnerLimit = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GREET_OWNER_LIMIT);
        if (greetOwnerLimit < 0) {
            return;
        }
        DogOwnerDistanceManager.decGreetCountForOwner(this.owner);
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }

    @Override
    public boolean canPreventSit() {
        return this.greetTime < 100;
    }

    private BlockPos getRandomPosAroundOwner(LivingEntity owner) {
        BlockPos owner_b0 = owner.m_20183_();
        RandomSource r = owner.m_217043_();
        int rX = r.m_216332_(-1, 1);
        int rY = r.m_216332_(-1, 1);
        int rZ = r.m_216332_(-1, 1);
        return owner_b0.m_7918_(rX, rY, rZ);
    }
}

