/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class DogMoveToBedAction
extends TriggerableAction {
    @Nonnull
    private final BlockPos targetBedPos;
    private final boolean claimBed;
    private boolean bedReached = false;
    private int timeOut;

    public DogMoveToBedAction(Dog dog, @Nonnull BlockPos targetBedPos, boolean claimBed) {
        super(dog, false, false);
        this.targetBedPos = targetBedPos;
        this.claimBed = claimBed;
    }

    @Override
    public void onStart() {
        this.timeOut = 400;
        this.dog.m_21573_().m_26519_((double)this.targetBedPos.m_123341_() + 0.5, (double)(this.targetBedPos.m_123342_() + 1), (double)this.targetBedPos.m_123343_() + 0.5, 1.0);
    }

    @Override
    public void tick() {
        --this.timeOut;
        if (this.timeOut <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        boolean bl = this.bedReached = this.dog.m_20183_().m_123331_((Vec3i)this.targetBedPos) <= 1.5;
        if (this.dog.m_21573_().m_26571_()) {
            if (this.bedReached) {
                if (this.claimBed) {
                    this.claimBed();
                }
                this.dog.m_21839_(true);
            }
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    private void claimBed() {
        BlockPos target = this.targetBedPos;
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((BlockGetter)this.dog.f_19853_, target, DogBedTileEntity.class);
        if (dogBedTileEntity == null) {
            return;
        }
        if (dogBedTileEntity.getOwnerUUID() != null) {
            return;
        }
        dogBedTileEntity.setOwner(this.dog);
        this.dog.setBedPos((ResourceKey<Level>)this.dog.f_19853_.m_46472_(), target);
        this.dog.f_19853_.m_7605_((Entity)this.dog, (byte)7);
    }

    @Override
    public void onStop() {
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }
}

