/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogTriggerableGoal
extends Goal {
    Dog dog;
    final boolean trivial;

    public DogTriggerableGoal(Dog dog, boolean trivial) {
        this.dog = dog;
        this.trivial = trivial;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        TriggerableAction action = this.dog.getTriggerableAction();
        return action != null && action.isTrivial() == this.trivial;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8037_() {
        TriggerableAction action = this.dog.getTriggerableAction();
        if (action == null) {
            return;
        }
        if (this.dog.hasDelayedActionStart()) {
            return;
        }
        switch (action.getState()) {
            case PENDING: {
                action.setState(TriggerableAction.ActionState.RUNNING);
                action.onStart();
                break;
            }
            case PAUSED: {
                action.setState(TriggerableAction.ActionState.RUNNING);
                action.tick();
                break;
            }
            case RUNNING: {
                action.tick();
                break;
            }
            case FINISHED: {
                this.dog.triggerAction(null);
                break;
            }
        }
    }

    public void m_8041_() {
        TriggerableAction action;
        TriggerableAction stashed_action;
        if (!this.trivial && (stashed_action = this.dog.getStashedTriggerableAction()) != null) {
            if (!stashed_action.canPause()) {
                this.dog.setStashedTriggerableAction(null);
            }
            stashed_action.setState(TriggerableAction.ActionState.PAUSED);
        }
        if ((action = this.dog.getTriggerableAction()) != null) {
            if (action.isTrivial() != this.trivial) {
                return;
            }
            if (!action.canPause()) {
                this.dog.triggerAction(null);
            }
            action.setState(TriggerableAction.ActionState.PAUSED);
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

