/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.event;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.ai.triggerable.DogPlayTagAction;
import doggytalents.common.talent.HunterDogTalent;
import doggytalents.common.util.Util;
import doggytalents.common.util.doggyasynctask.DogAsyncTaskManager;
import doggytalents.common.util.doggyasynctask.promise.DogBatchTeleportToDimensionPromise;
import doggytalents.common.util.doggyasynctask.promise.DogHoldChunkToTeleportPromise;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    public final int COLLECT_RADIUS = 26;
    public final int MIN_DISTANCE_TO_TRIGGER_TELEPORT_SQR = 400;

    @SubscribeEvent
    public void onServerTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !event.haveTime()) {
            return;
        }
        DogAsyncTaskManager.tick();
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        DogAsyncTaskManager.forceStop();
    }

    @SubscribeEvent
    public void onWolfRightClickWithTreat(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Player owner = event.getEntity();
        if (stack.m_41720_() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (target.m_6095_() != EntityType.f_20499_) {
            return;
        }
        if (!(target instanceof Wolf)) {
            return;
        }
        Wolf wolf = (Wolf)target;
        event.setCanceled(true);
        if (!this.checkValidWolf(wolf, owner)) {
            event.setCancellationResult(InteractionResult.FAIL);
            return;
        }
        if (!level.f_46443_) {
            if (!owner.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.trainWolf(wolf, owner, level);
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    private boolean checkValidWolf(Wolf wolf, Player owner) {
        if (!wolf.m_6084_()) {
            return false;
        }
        if (!wolf.m_21824_()) {
            return false;
        }
        return wolf.m_21830_((LivingEntity)owner);
    }

    private void trainWolf(Wolf wolf, Player owner, Level level) {
        Dog dog = (Dog)((EntityType)DoggyEntityTypes.DOG.get()).m_20615_(level);
        if (dog == null) {
            throw new IllegalStateException("Creator function for the dog returned \"null\"");
        }
        dog.m_21828_(owner);
        dog.m_21153_(dog.m_21233_());
        dog.m_21839_(false);
        dog.m_146762_(wolf.m_146764_());
        dog.m_19890_(wolf.m_20185_(), wolf.m_20186_(), wolf.m_20189_(), wolf.m_146908_(), wolf.m_146909_());
        dog.m_5616_(wolf.m_6080_());
        dog.m_5618_(wolf.m_213816_());
        DyeColor wolf_collar_color = wolf.m_30428_();
        int color = Util.srgbArrayToInt(wolf_collar_color.m_41068_());
        AccessoryInstance dog_collar = ((DyeableAccessory)DoggyAccessories.DYEABLE_COLLAR.get()).create(color);
        if (dog_collar != null) {
            dog.addAccessory(dog_collar);
        }
        if (wolf.m_8077_()) {
            dog.m_6593_(wolf.m_7770_());
        }
        level.m_7967_((Entity)dog);
        wolf.m_146870_();
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractSkeleton) {
            AbstractSkeleton skeleton = (AbstractSkeleton)entity;
            skeleton.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)skeleton, Dog.class, 6.0f, 1.0, 1.2));
        }
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.STARTING_ITEMS)).booleanValue()) {
            CompoundTag persistTag;
            Player player = event.getEntity();
            CompoundTag tag = player.getPersistentData();
            if (!tag.m_128441_("PlayerPersisted")) {
                tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            if (!(persistTag = tag.m_128469_("PlayerPersisted")).m_128471_("gotDTStartingItems")) {
                persistTag.m_128379_("gotDTStartingItems", true);
                player.m_150109_().m_36054_(new ItemStack((ItemLike)DoggyItems.DOGGY_CHARM.get()));
                player.m_150109_().m_36054_(new ItemStack((ItemLike)DoggyItems.WHISTLE.get()));
            }
        }
    }

    @SubscribeEvent
    public void onLootDrop(LootingLevelEvent event) {
        HunterDogTalent.onLootDrop(event);
    }

    @SubscribeEvent
    public void onProjectileHit(ProjectileImpactEvent event) {
        AbstractArrow arrow;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHitResult = (EntityHitResult)hitResult;
        Entity entity = entityHitResult.m_82443_();
        if (!(entity instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)entity;
        Projectile projectile = event.getProjectile();
        Entity projectileOnwer = projectile.m_19749_();
        if (projectileOnwer == null) {
            return;
        }
        LivingEntity dogOwner = dog.m_269323_();
        if (projectile instanceof Snowball) {
            if (projectileOnwer == dogOwner && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PLAY_TAG_WITH_DOG)).booleanValue() && !dog.isBusy()) {
                dog.triggerAction(new DogPlayTagAction(dog, dogOwner));
            }
            return;
        }
        boolean flag = EventHandler.checkIfArrowShouldNotHurtDog(dog, projectileOnwer, dogOwner);
        if (!flag) {
            return;
        }
        if (projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).m_36796_() > 0) {
            arrow.m_36767_((byte)0);
        }
        event.setCanceled(true);
    }

    private static boolean checkIfArrowShouldNotHurtDog(Dog dog, Entity projectileOnwer, LivingEntity dogOwner) {
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && projectileOnwer instanceof Player) {
            return true;
        }
        return !dog.canOwnerAttack() && dog.checkIfAttackedFromOwnerOrTeam(dogOwner, projectileOnwer);
    }

    @SubscribeEvent
    public void onEntityChangeDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity.f_19853_.f_46443_) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity;
            this.onOwnerChangeDimension(event, owner);
        }
    }

    private void onOwnerChangeDimension(EntityTravelToDimensionEvent event, ServerPlayer owner) {
        Level level = owner.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        MinecraftServer mcServer = sLevel.m_7654_();
        ServerLevel fromLevel = sLevel;
        ServerLevel toLevel = mcServer.m_129880_(event.getDimension());
        if (fromLevel == toLevel) {
            return;
        }
        List crossOriginTpList = fromLevel.m_6443_(Dog.class, owner.m_20191_().m_82377_(26.0, 4.0, 26.0), d -> this.isDogReadyToTeleport((Dog)d, (LivingEntity)owner));
        if (crossOriginTpList.isEmpty()) {
            return;
        }
        DogAsyncTaskManager.addPromiseWithOwnerAndStartImmediately(new DogBatchTeleportToDimensionPromise(crossOriginTpList, fromLevel, owner.m_20148_(), (ResourceKey<Level>)event.getDimension()), owner);
    }

    @SubscribeEvent
    public void onOwnerTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer owner = (ServerPlayer)entity;
        Level level = owner.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        if (this.distanceTooShortToTeleport(event.getPrev(), event.getTarget())) {
            return;
        }
        List crossOriginTpList = sLevel.m_6443_(Dog.class, owner.m_20191_().m_82377_(26.0, 4.0, 26.0), d -> this.isDogReadyToTeleport((Dog)d, (LivingEntity)owner));
        if (crossOriginTpList.isEmpty()) {
            return;
        }
        DogAsyncTaskManager.addPromiseWithOwnerAndStartImmediately(new DogHoldChunkToTeleportPromise(crossOriginTpList, sLevel), owner);
    }

    private boolean isDogReadyToTeleport(Dog dog, LivingEntity owner) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (dog.m_269323_() != owner) {
            return false;
        }
        if (dog.m_21827_()) {
            return false;
        }
        if (!dog.getMode().shouldFollowOwner()) {
            return false;
        }
        return dog.crossOriginTp();
    }

    private boolean distanceTooShortToTeleport(Vec3 from, Vec3 to) {
        return from.m_82557_(to) < 400.0;
    }
}

