/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.client.screen.AmnesiaBoneScreen.AmneisaBoneScreen;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AmnesiaBoneItem
extends Item
implements IDogItem {
    public AmnesiaBoneItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public InteractionResult processInteract(AbstractDog dog, Level level, Player player, InteractionHand hand) {
        UUID ownerUUID = dog.m_21805_();
        if (ownerUUID == null) {
            return InteractionResult.FAIL;
        }
        if (level.f_46443_ && hand == InteractionHand.MAIN_HAND && dog instanceof Dog) {
            Dog d = (Dog)dog;
            if (ownerUUID.equals(player.m_20148_())) {
                AmneisaBoneScreen.open(d);
            }
        }
        this.requestOwnership(level, ownerUUID, player, hand, dog);
        return InteractionResult.SUCCESS;
    }

    private void requestOwnership(Level level, UUID ownerUUID, Player player, InteractionHand hand, AbstractDog dog) {
        if (level.f_46443_) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        if (ownerUUID.equals(playerUUID)) {
            return;
        }
        if (!(dog instanceof Dog)) {
            return;
        }
        Dog d = (Dog)dog;
        if (!d.willObeyOthers()) {
            player.m_5661_((Component)Component.m_237115_((String)"item.doggytalents.amnesia_bone.reject").m_130940_(ChatFormatting.RED), true);
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() != this) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128403_("request_uuid") && tag.m_128342_("request_uuid").equals(playerUUID)) {
            return;
        }
        tag.m_128362_("request_uuid", player.m_20148_());
        tag.m_128359_("request_str", player.m_7755_().getString());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128425_("amnesia_bone_used_time", 3)) {
            components.add((Component)Component.m_237110_((String)"item.doggytalents.amnesia_bone.use_status", (Object[])new Object[]{AmnesiaBoneItem.getUseCap() - tag.m_128451_("amnesia_bone_used_time"), AmnesiaBoneItem.getUseCap()}).m_130940_(ChatFormatting.RED));
        }
        if (tag.m_128425_("request_str", 8)) {
            components.add((Component)Component.m_237110_((String)"item.doggytalents.amnesia_bone.status", (Object[])new Object[]{tag.m_128461_("request_str")}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static int getUseCap() {
        return 8;
    }

    public static int getUntameXPCost() {
        return 3;
    }

    public static int getMigrateOwnerXPCost() {
        return 5;
    }
}

