/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.DogLevel;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class TreatItem
extends Item
implements IDogItem {
    private final int maxLevel;
    private final DogLevel.Type type;

    public TreatItem(int maxLevel, DogLevel.Type typeIn, Item.Properties properties) {
        super(properties);
        this.maxLevel = maxLevel;
        this.type = typeIn;
    }

    @Override
    public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!dogIn.m_21824_() || !dogIn.canInteract((LivingEntity)playerIn)) {
            return InteractionResult.FAIL;
        }
        DogLevel dogLevel = dogIn.getDogLevel();
        if (dogIn.m_146764_() < 0) {
            if (!worldIn.f_46443_) {
                worldIn.m_7605_((Entity)dogIn, (byte)6);
                playerIn.m_213846_((Component)Component.m_237115_((String)("treat." + this.type.getName() + ".too_young")));
            }
            return InteractionResult.CONSUME;
        }
        if (!dogLevel.canIncrease(this.type)) {
            if (!worldIn.f_46443_) {
                worldIn.m_7605_((Entity)dogIn, (byte)6);
                playerIn.m_213846_((Component)Component.m_237115_((String)("treat." + this.type.getName() + ".low_level")));
            }
            return InteractionResult.CONSUME;
        }
        if (dogLevel.getLevel(this.type) < this.maxLevel) {
            if (!playerIn.f_19853_.f_46443_) {
                if (!playerIn.m_150110_().f_35937_) {
                    playerIn.m_21120_(handIn).m_41774_(1);
                }
                dogIn.increaseLevel(this.type);
                float h = dogIn.getDogLevel().getMaxHealth();
                if (h != dogIn.m_21233_()) {
                    dogIn.m_21051_(Attributes.f_22276_).m_22100_((double)h);
                }
                dogIn.m_21153_(dogIn.m_21233_());
                dogIn.m_21839_(true);
                worldIn.m_7605_((Entity)dogIn, (byte)7);
                playerIn.m_213846_((Component)Component.m_237115_((String)("treat." + this.type.getName() + ".level_up")));
            }
            return InteractionResult.SUCCESS;
        }
        if (!worldIn.f_46443_) {
            worldIn.m_7605_((Entity)dogIn, (byte)6);
            playerIn.m_213846_((Component)Component.m_237115_((String)("treat." + this.type.getName() + ".max_level")));
        }
        return InteractionResult.CONSUME;
    }
}

